#charset "utf-8"

#include "tads.h"
#include "tok.h"
#include "adv3.h"
#include "cs_cz.h"
#include <vector.h>
#include <dict.h>
#include <gramprod.h>
#include <strcomp.h>

VerbRule(GetOut)
    ('vystup' | 'vystoupit' | 'vys') ( | 'ven')
    : GetOutAction
    verbPhrase = 'dostat/dostáv{áš}/dostal{a} ven'
;

/*
 *   "askDobjResponseProd = toSingleNoun" říká, že na otázku "Do čeho chceš
 *   nastoupit?" mohu odpovědět s předložkou, např. "do loďky", ale i "na
 *   palubu". Ale proč to nefunguje?
 */
VerbRule(Board)
    ('nastup' | 'nastoupit' | 'nas') ('na' | 'do' | ) singleDobj
    : BoardAction
    verbPhrase = 'nastoupit/nastupu{ješ}/nastoupil{a} (do čeho)'
    askDobjResponseProd = toSingleNoun
;

VerbRule(Sleep)
    ('spi' | 'spát')
    | ('vyspi' | 'vyspat') ('se' | )
    : SleepAction
    verbPhrase = 'spát/sp{íš}/spal{a}'
;

VerbRule(Fasten)
    ('připoutej' | 'připoutat') dobjList
    : FastenAction
    verbPhrase = 'připoutat/připoutáv{áš}/připoutal{a} (co)'
;

VerbRule(FastenTo)
    ('připoutej' | 'připoutat') dobjList ('k' | 'ke') singleIobj
    : FastenToAction
    verbPhrase = 'připoutat/připoutáv{áš}/připoutal{a} (co) (k čemu)'
    askIobjResponseProd = atSingleNoun
;

VerbRule(Unfasten)
    ('odpoutej' | 'odpoutat') dobjList
    : UnfastenAction
    verbPhrase = 'odpoutat/odpoutáv{áš}/odpoutal{a} (co)'
;

VerbRule(UnfastenFrom)
    ('odpoutej' | 'odpoutat') dobjList ('od' | 'z' | 'ze') singleIobj
    : UnfastenFromAction
    verbPhrase = 'odpoutat/odpoutáv{áš}/odpoutal{a} (co) (od čeho)'
    askIobjResponseProd = fromSingleNoun
;

VerbRule(PlugInto)
    ('připoj' | 'připojit' | 'napoj' | 'napojit' | 'zapoj' | 'zapojit'
    | 'nasaď' | 'nasadit') dobjList ('do' | 'k' | 'ke' | 'na') singleIobj
    | ('spoj' | 'spojit' | 'propoj' | 'propojit') dobjList ('s' | 'se')
    singleIobj
    : PlugIntoAction
    verbPhrase = 'připojit/připoju{ješ}/připojil{a} (co) (k čemu)'
    askIobjResponseProd = atSingleNoun
;

VerbRule(PlugIntoWhat)
    [badness 500] ('připoj' | 'připojit' | 'napoj' | 'napojit' | 'zapoj'
    | 'zapojit' | 'spoj' | 'spojit' | 'propoj' | 'propojit' | 'nasaď'
    | 'nasadit') dobjList
    : PlugIntoAction
    verbPhrase = 'připojit/připoju{ješ}/připojil{a} (co) (k čemu)'
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = atSingleNoun;
    }
;

VerbRule(PlugIn)
    ('zapoj' | 'zapojit') dobjList
    : PlugInAction
    verbPhrase = 'zapojit/zapoju{ješ}/zapojil{a} (co)'
;

VerbRule(UnplugFrom)
    ('odpoj' | 'odpojit' | 'vypoj' | 'vypojit') dobjList
    ('z' | 'ze' | 'od') singleIobj
    : UnplugFromAction
    verbPhrase = 'odpojit/odpoju{ješ}/odpojil{a} (co) (z čeho)'
    askIobjResponseProd = outOfSingleNoun
;

VerbRule(Unplug)
    ('odpoj' | 'odpojit' | 'vypoj' | 'vypojit') dobjList
    : UnplugAction
    verbPhrase = 'odpojit/odpoju{ješ}/odpojil{a} (co)'
;

VerbRule(Screw)
    ('zašroubuj' | 'zašroubovat') dobjList
    : ScrewAction
    verbPhrase = 'přišroubovat/přišroubováv{áš}/přišrouboval{a} (co)'
;

/* TODO: rozdělit na prepositional phrasing a nonprep. phrasing */
VerbRule(ScrewWith)
    ('zašroubuj' | 'zašroubovat') dobjList singleIobj
    | ('zašroubuj' | 'zašroubovat') singleIobj dobjList
    : ScrewWithAction
    verbPhrase = 'přišroubovat/přišroubováv{áš}/přišrouboval{a} (co) (čím)'
    omitIobjInDobjQuery = true
    askIobjResponseProd = singleNoun
;

VerbRule(Unscrew)
    ('odšroubuj' | 'odšroubovat') dobjList
    : UnscrewAction
    verbPhrase = 'odšroubovat/odšroubováv{áš}/odšrouboval{a} (co)'
;

/* TODO: rozdělit na prepositional phrasing a nonprep. phrasing */
VerbRule(UnscrewWith)
    ('odšroubuj' | 'odšroubovat') dobjList singleIobj
    | ('odšroubuj' | 'odšroubovat') singleIobj dobjList
    : UnscrewWithAction
    verbPhrase = 'odšroubovat/odšroubováv{áš}/odšrouboval{a} (co) (čím)'
    omitIobjInDobjQuery = true
    askIobjResponseProd = singleNoun
;

VerbRule(PushTravelDir)
    ('tlač' | 'tlačit' | 'odtlač' | 'odtlačit' | 'vytlač' | 'vytlačit' |
    'strkej' | 'strkat' | 'vystrkej' | 'vystrkat') singleDobj
    ( | 'na') singleDir
    : PushTravelDirAction
    verbPhrase = ('tlačit/tlač{íš}/tlačil{a} (co) ' + dirMatch.dir.name)
;

VerbRule(PushTravelThrough)
    ('tlač' | 'tlačit' | 'odtlač' | 'odtlačit' | 'protlač' | 'protlačit'
    | 'prostrč' | 'prostrčit') singleDobj ('skrz' | ) singleIobj
    : PushTravelThroughAction
    verbPhrase = 'tlačit/tlač{íš}/tlačil{a} (co) (skrz co)'
;

VerbRule(PushTravelEnter)
    ('tlač' | 'tlačit' | 'odtlač' | 'odtlačit' | 'zatlač' | 'zatlačit')
    singleDobj 'do' singleIobj
    : PushTravelEnterAction
    verbPhrase = 'tlačit/tlač{íš}/tlačil{a} (co) (do čeho)'
;

VerbRule(PushTravelGetOutOf)
    ('tlač' | 'tlačit' | 'odtlač' | 'odtlačit' | 'vytlač' | 'vytlačit')
    singleDobj ('ven' | ) ('z' | 'ze') singleIobj
    : PushTravelGetOutOfAction
    verbPhrase = 'tlačit/tlač{íš}/tlačil{a} (co) (ven z čeho)'
;

/* TODO: Tyhle dvě jsou nějaké divné, nedovedu si představit využití. Mozna na schodech, ktere reaguji na climb? */
VerbRule(PushTravelClimbUp)
    ('tlač' | 'tlačit' | 'odtlač' | 'odtlačit') singleDobj
    'na' singleIobj
    : PushTravelClimbUpAction
    verbPhrase = 'tlačit/tlač{íš}/tlačil{a} (co) (na co)'
    omitIobjInDobjQuery = true
;

VerbRule(PushTravelClimbDown)
    ('tlač' | 'tlačit' | 'odtlač' | 'odtlačit') singleDobj
    'pod' singleIobj
    : PushTravelClimbDownAction
    verbPhrase = 'tlačit/tlač{íš}/tlačil{a} (co) (pod co)'
;

VerbRule(Exits)
    ('ukaž' | 'ukázat' | ) ('mi' | ) ('směry' | 'východy' | 'cesty' | 'pohyby')
    : ExitsAction
    verbPhrase = 'ukázat/ukazu{ješ}/ukázal{a} směry'
;

VerbRule(ExitsMode)
    ('zapnout'->on_ | 'všechny'->on_ | 'vypnout'->off_ | 'žádné'->off_ )
    ('směry' | 'východy' | 'cesty' | 'pohyby')
    | ('směry' | 'východy' | 'cesty' | 'pohyby')
    'v' ('záhlaví'->stat_ | 'popisu'->look_)
    : ExitsModeAction
    verbPhrase = 'vypnout/vypín{áš}/vypnul{a} zobrazení směrů'
;

VerbRule(HintsOff)
    ('vypni' | 'vypnout' | 'vyp') ('rady')
    | ('rady') ('vypni' | 'vypnout' | 'vyp')
    : HintsOffAction
    verbPhrase = 'vypnout/vypín{áš}/vypnul{a} rady'
;

VerbRule(Hint)
    ('ukaž' | 'ukázat') ('radu' | 'rady')
    | ('poraď' | 'poradit') ( | 'mi')
    | 'rada' | 'rady'
    : HintAction
    verbPhrase = 'ukázat/ukazu{ješ}/ukázal{a} rady'
;

VerbRule(Oops)
    ('oprava' | 'opr' | 'op') singleLiteral
    : OopsAction
    verbPhrase = 'opravit/opravu{ješ}/opravil{a} (co)'
;

VerbRule(OopsOnly)
    ('oprava' | 'opr' | 'op')
    : OopsIAction
    verbPhrase = 'opravit/opravu{ješ}/opravil{a}'
;

/* ------------------------------------------------------------------------ */
/*
 *   "debug" verb - special verb to break into the debugger.  We'll only
 *   compile this into the game if we're compiling a debug version to begin
 *   with, since a non-debug version can't be run under the debugger.
 */
#ifdef __DEBUG

VerbRule(Debug)
    'debuguj' | 'debugovat' | 'debug'
    : DebugAction
    verbPhrase = 'debugovat/debugu{ješ}/debugoval{a}'
;

#endif /* __DEBUG */

/* ------------------------------------------------------------------------ */
/*
 *   Execute a command line, as issued by the given actor and as given as a
 *   list of tokens.
 *   
 *   If 'firstInSentence' is true, we're at the start of a "sentence."  The
 *   meaning and effect of this may vary by language.  In English, a
 *   sentence ends with certain punctuation marks (a period, semicolon,
 *   exclamation mark, or question mark), so anything after one of these
 *   punctuation marks is the start of a new sentence.  Also in English, we
 *   can address a command to an explicit target actor using the "actor,"
 *   prefix syntax, which we can't use except at the start of a sentence.
 *   
 *   If the command line consists of multiple commands, we will only
 *   actually execute the first command before returning.  We'll schedule
 *   any additional commands for later execution by putting them into the
 *   target actor's pending command queue before we return, but we won't
 *   actually execute them.  
 */
find_np(obj)
{
	if(obj.noun_ != nil) return obj.noun_.noun_;
	if(obj.np_ != nil) return find_np(obj.np_);
	return nil;
}

modify executeCommand(targetActor, issuingActor, toks, firstInSentence)
{
    local actorPhrase;
    local actorSpecified;

    /*
     *   Turn on sense caching while we're working, until execution
     *   begins.  The parsing and resolution phases of command processing
     *   don't involve any changes to game state, so we can safely cache
     *   sense information; caching sense information during these phases
     *   is desirable because these steps (noun resolution in particular)
     *   involve repeated inspection of the current sensory environment,
     *   which can require expensive calculations.  
     */
    libGlobal.enableSenseCache();

    /* we don't have an explicit actor phrase yet */
    actorPhrase = nil;
    
    /* presume an actor will not be specified */
    actorSpecified = nil;
    
    /*
     *   If this is the start of a new sentence, and the issuing actor
     *   wants to cancel any target actor designation at the end of each
     *   sentence, change the target actor back to the issuing actor.  
     */
    if (firstInSentence
        && issuingActor != targetActor
        && issuingActor.revertTargetActorAtEndOfSentence)
    {
        /* switch to the target actor */
        targetActor = issuingActor;

        /* switch to the issuer's sense context */
        senseContext.setSenseContext(targetActor, sight);
    }

    /*
     *   Keep going until we've processed the command.  This might take
     *   several iterations, because we might have replacement commands to
     *   execute.  
     */
parseTokenLoop:
    for (;;)
    {
        local lst;
        local action;
        local match;
        local nextIdx;
        local nextCommandTokens;
        local extraIdx;
        local extraTokens;
        
        /*
         *   Catch any errors that occur while executing the command,
         *   since some of them are signals to us that we should reparse
         *   some new text read or generated deep down inside the command
         *   processing.  
         */
        try
        {
            local rankings;

            /* we have no extra tokens yet */
            extraTokens = [];

            /* 
             *   Parse the token list.  If this is the first command on
             *   the command line, allow an actor prefix.  Otherwise, just
             *   look for a command.  
             */
            lst = (firstInSentence ? firstCommandPhrase : commandPhrase)
                  .parseTokens(toks, cmdDict);

            /*
             *   As a first cut at reducing the list of possible matches
             *   to those that make sense, eliminate from this list any
             *   matches which do not have valid actions.  In grammars for
             *   "scrambling" languages (i.e., languages with flexible
             *   word ordering), it is possible to construct commands that
             *   fit the grammatical rules of sentence construction but
             *   which make no sense because of the specific constraints
             *   of the verbs involved; we can filter out such nonsense
             *   interpretations immediately by keeping only those
             *   structural interpretations that can resolve to valid
             *   actions.  
             */
            lst = lst.subset(
                {x: x.resolveFirstAction(issuingActor, targetActor) != nil});

            /* if we have no matches, the command isn't understood */
            if (lst.length() == 0)
            {
                /* 
                 *   If this is a first-in-sentence phrase, try looking for
                 *   a target actor phrase.  If we can find one, we can
                 *   direct the 'oops' to that actor, to allow the game to
                 *   customize messages more specifically.  
                 */
                if (firstInSentence)
                {
                    local i;
                    
                    /* try parsing an "actor, <unknown>" phrase */
                    lst = actorBadCommandPhrase.parseTokens(toks, cmdDict);

                    /* if we got any matches, try to resolve actors */
                    lst = lst.mapAll({x: x.resolveNouns(
                        issuingActor, issuingActor,
                        new TryAsActorResolveResults())});

                    /* drop any that didn't yield any results */
                    lst = lst.subset({x: x != nil && x.length() != 0});

                    /*
                     *
                     *   if anything's left, and one of the entries 
                     *   resolves to an actor, arbitrarily pick the 
                     *   first such entry use the resolved actor as the 
                     *   new target actor 
                     */
                    if (lst.length() != 0
                        && (i = lst.indexWhich(
                            {x: x[1].obj_.ofKind(Actor)})) != nil)
                        targetActor = lst[i][1].obj_;
                }

                /* 
                 *   We don't understand the command.  Check for unknown
                 *   words - if we have any, give them a chance to use
                 *   OOPS to correct a typo.  
                 */
                tryOops(toks, issuingActor, targetActor,
                        1, toks, rmcCommand);

                /* 
                 *   try running it by the SpecialTopic history to see if
                 *   they're trying to use a special topic in the wrong
                 *   context - if so, explain that they can't use the
                 *   command right now, rather than claiming that the
                 *   command is completely invalid 
                 */
                if (specialTopicHistory.checkHistory(toks))
                {
                    /* the special command is not currently available */
                    targetActor.notifyParseFailure(
                        issuingActor, &specialTopicInactive, []);
                }
                else
                {
                    /* tell the issuer we didn't understand the command */
                    targetActor.notifyParseFailure(
                        issuingActor, &commandNotUnderstood, []);
                }
                
                /* 
                 *   we're done with this command, and we want to abort
                 *   any subsequent commands on the command line 
                 */
                return;
            }

            /* show the matches if we're in debug mode */
            dbgShowGrammarList(lst);
        
            /* 
             *   Perform a tentative resolution on each alternative
             *   structural interpretation of the command, and rank the
             *   interpretations in order of "goodness" as determined by
             *   our ranking criteria encoded in CommandRanking.
             *   
             *   Note that we perform the tentative resolution and ranking
             *   even if we have only one interpretation, because the
             *   tentative resolution is often useful for the final
             *   resolution pass.  
             */
            rankings = CommandRanking
                       .sortByRanking(lst, issuingActor, targetActor);
                
            /* 
             *   Take the interpretation that came up best in the rankings
             *   (or, if we have multiple at the same ranking, arbitrarily
             *   pick the one that happened to come up first in the list)
             *   - they're ranked in descending order of goodness, so take
             *   the first one.
             */
            match = rankings[1].match;

            /* if we're in debug mode, show the winner */
            dbgShowGrammarWithCaption('Winner', match);
            
            /*
             *   Get the token list for the rest of the command after what
             *   we've parsed so far.
             *   
             *   Note that we'll start over and parse these tokens anew,
             *   even though we might have parsed them already into a
             *   subcommand on the previous iteration.  Even if we already
             *   parsed these tokens, we want to parse them again, because
             *   we did not have a suitable context for evaluating the
             *   semantic strengths of the possible structural
             *   interpretations this command on the previous iteration;
             *   for example, it was not possible to resolve noun phrases
             *   in this command because we could not guess what the scope
             *   would be when we got to this point.  So, we'll simply
             *   discard the previous match tree, and start over, treating
             *   the new tokens as a brand new command.  
             */
            nextIdx = match.getNextCommandIndex();
            nextCommandTokens = toks.sublist(nextIdx);

            /* if the pending command list is empty, make it nil */
            if (nextCommandTokens.length() == 0)
                nextCommandTokens = nil;

            /*
             *   Get the part of the token list that the match doesn't use
             *   at all.  These are the tokens following the tokens we
             *   matched. 
             */
            extraIdx = match.tokenList.length() + 1;
            extraTokens = toks.sublist(extraIdx);

            /*
             *   We now have the best match for the command tree.
             *   
             *   If the command has an actor clause, resolve the actor, so
             *   that we can direct the command to that actor.  If the
             *   command has no actor clause, the command is to the actor
             *   who issued the command.
             *   
             *   Do NOT process the actor clause if we've already done so.
             *   If we edit the token list and retry the command after
             *   this point, there is no need to resolve the actor part
             *   again.  Doing so could be bad - if resolving the actor
             *   required player interaction, such as asking for help with
             *   an ambiguous noun phrase, we do not want to go through
             *   the same interaction again just because we have to edit
             *   and retry a later part of the command.  
             */
            if (match.hasTargetActor())
            {
                local actorResults;

                /*
                 *   If we haven't yet explicitly specified a target
                 *   actor, and the default target actor is different from
                 *   the issuing actor, then this is really a new command
                 *   from the issuing actor.
                 *   
                 *   First, an actor change mid-command is allowed only if
                 *   the issuing actor waits for NPC commands to be
                 *   carried out; if not, then we can't change the actor
                 *   mid-command.
                 *   
                 *   Second, since the command comes from the issuing
                 *   actor, not from the default target actor, we want to
                 *   issue the orders on the issuing actor's turn, so put
                 *   the command into the queue for the issuer, and let
                 *   the issuer re-parse the command on the issuer's next
                 *   turn.  
                 */
                if (!actorSpecified && issuingActor != targetActor)
                {
                    /* 
                     *   don't allow the command if the issuing actor
                     *   doesn't wait for orders to be completed 
                     */
                    if (!issuingActor.issueCommandsSynchronously)
                    {
                        /* turn off any sense capturing */
                        senseContext.setSenseContext(nil, sight);

                        /* show the error */
                        issuingActor.getParserMessageObj()
                            .cannotChangeActor();

                        /* done */
                        return;
                    }

                    /* put the command into the issuer's queue */
                    issuingActor.addFirstPendingCommand(
                        firstInSentence, issuingActor, toks);

                    /* done */
                    return;
                }

                /* create an actor-specialized results object */
                actorResults = new ActorResolveResults();
                
                /* set up the actors in the results object */
                actorResults.setActors(targetActor, issuingActor);
                
                /* resolve the actor object */
                match.resolveNouns(issuingActor, targetActor, actorResults);

                /* get the target actor from the command */
                targetActor = match.getTargetActor();

                /* pull out the phrase specifying the actor */
                actorPhrase = match.getActorPhrase();

                /*
                 *   Copy antecedents from the issuing actor to the target
                 *   actor.  Since the issuer is giving us a new command
                 *   here, pronouns will be given from the issuer's
                 *   perspective.  
                 */
                targetActor.copyPronounAntecedentsFrom(issuingActor);

                /* let the actor phrase know we're actually using it */
                match.execActorPhrase(issuingActor);
                
                /* 
                 *   Ask the target actor if it's interested in the
                 *   command at all.  This only applies when the actor was
                 *   actually specified - if an actor wasn't specified,
                 *   the command is either directed to the issuer itself,
                 *   in which case the command will always be accepted; or
                 *   the command is a continuation of a command line
                 *   previously accepted.  
                 */
                if (!targetActor.acceptCommand(issuingActor))
                {
                    /* 
                     *   the command was immediately rejected - abandon
                     *   the command and any subsequent commands on the
                     *   same line 
                     */
                    return;
                }

                /* note that an actor was specified */
                actorSpecified = true;

                /*
                 *   Pull out the rest of the command (other than the
                 *   target actor specification) and start over with a
                 *   fresh parse of the whole thing.  We must do this
                 *   because our tentative resolution pass that we used to
                 *   pick the best structural interpretation of the
                 *   command couldn't go far enough - since we didn't know
                 *   the actor involved, we weren't able to resolve nouns
                 *   in the rest of the command.  Now that we know the
                 *   actor, we can start over and resolve everything in
                 *   the rest of the command, and thus choose the right
                 *   structural match for the command.  
                 */
                toks = match.getCommandTokens();

                /* what follows obviously isn't first in the sentence */
                firstInSentence = nil;

                /* go back to parse the rest */
                continue parseTokenLoop;
            }

            /* pull out the first action from the command */        
            action = match.resolveFirstAction(issuingActor, targetActor);
            
            if(action.dobjList_ != nil)
            {
                if(action.dobjList_.length() > 0)
                {
                    action.dobjList_[1].obj_.parsedAs
                        = find_np(action.dobjList_[1].np_);
                }
            }

            /*
             *   If the winning interpretation had any unknown words, run
             *   a resolution pass to resolve those interactively, if
             *   possible.  We want to do this before doing any other
             *   interactive resolution because OOPS has the unique
             *   property of forcing us to reparse the command; if we
             *   allowed any other interactive resolution to happen before
             *   processing an OOPS, we'd likely have to repeat the other
             *   resolution on the reparse, which would confuse and
             *   irritate users by asking the same question more than once
             *   for what is apparently the same command.  
             */
            if (rankings[1].unknownWordCount != 0)
            {
                /* 
                 *   resolve using the OOPS results gatherer - this runs
                 *   essentially the same preliminary resolution process
                 *   as the ranking results gatherer, but does perform
                 *   interactive resolution of unknown words via OOPS 
                 */
                match.resolveNouns(
                    issuingActor, targetActor,
                    new OopsResults(issuingActor, targetActor));
            }

            /* 
             *   If the command is directed to a different actor than the
             *   issuer, change to the target actor's sense context.  
             */
            if (actorSpecified && targetActor != issuingActor)
                senseContext.setSenseContext(targetActor, sight);

            /*
             *   Vyresetujeme uvozovkový automat, aby případné nespárované
             *   uvozovky se netáhly celým zbytkem hry.
             */
            languageGlobals.quotesLevel = 0;

            /* set up a transcript to receive the command results */
            withCommandTranscript(CommandTranscript, function()
            {
                /* 
                 *   Execute the action.
                 *   
                 *   If a target actor was specified, and it's not the same
                 *   as the issuing actor, this counts as a turn for the
                 *   issuing actor.  
                 */
                executeAction(targetActor, actorPhrase, issuingActor,
                              actorSpecified && issuingActor != targetActor,
                              action);
            });

            /*
             *   If we have anything remaining on the command line, insert
             *   the remaining commands at the start of the target actor's
             *   command queue, since we want the target actor to continue
             *   with the rest of this command line as its next operation.
             *   
             *   Since the remainder of the line represents part of the
             *   work the actor pulled out of the queue in order to call
             *   us, put the remainder back in at the START of the actor's
             *   queue - it was before anything else that might be in the
             *   actor's queue before, so it should stay ahead of anything
             *   else now.  
             */
            if (nextCommandTokens != nil)
            {
                /* 
                 *   Prepend the remaining commands to the actor's queue.
                 *   The next command is the start of a new sentence if
                 *   the command we just executed ends the sentence. 
                 */
                targetActor.addFirstPendingCommand(
                    match.isEndOfSentence(), issuingActor, nextCommandTokens);
            }

            /*
             *   If the command was directed from the issuer to a
             *   different target actor, and the issuer wants to wait for
             *   the full set of issued commands to complete before
             *   getting another turn, tell the issuer to begin waiting.  
             */
            if (actorSpecified && issuingActor != targetActor)
                issuingActor.waitForIssuedCommand(targetActor);

            /* we're done */
            return;
        }
        catch (ParseFailureException rfExc)
        {
            /*
             *   Parsing failed in such a way that we cannot proceed.
             *   Tell the target actor to notify the issuing actor.  
             */
            rfExc.notifyActor(targetActor, issuingActor);

            /* 
             *   the command cannot proceed, so abandon any remaining
             *   tokens on the command line 
             */
            return;
        }
        catch (CancelCommandLineException cclExc)
        {
            /* 
             *   if there are any tokens remaining, the game might want to
             *   show an explanation 
             */
            if (nextCommandTokens != nil)
                targetActor.getParserMessageObj().explainCancelCommandLine();

            /* stop now, abandoning the rest of the command line */	
            return;
        }
        catch (TerminateCommandException tcExc)
        {
            /* 
             *   the command cannot proceed - we can't do any more
             *   processing of this command, so simply return, abandoning
             *   any additional tokens we have 
             */
            return;
        }
        catch (RetryCommandTokensException rctExc)
        {
            /* 
             *   We want to replace the current command's token list with
             *   the new token list - get the new list, and then go back
             *   and start over processing it.
             *   
             *   Note that we must retain any tokens beyond those that the
             *   match tree used.  The exception only edits the current
             *   match tree's matched tokens, since it doesn't have access
             *   to any of the original tokens beyond those, so we must
             *   now add back in any tokens beyond the originals.  
             */
            toks = rctExc.newTokens_ + extraTokens;

            /* go back and process the command again with the new tokens */
            continue parseTokenLoop;
        }
        catch (ReplacementCommandStringException rcsExc)
        {
            local str;
            
            /* retrieve the new command string from the exception */
            str = rcsExc.newCommand_;

            /* 
             *   if the command string is nil, it means that the command
             *   has been fully handled already, so we simply return
             *   without any further work 
             */
            if (str == nil)
                return;

            /* 
             *   Replace the entire command string with the one from the
             *   exception - this cancels any previous command that we
             *   had.
             */
            toks = cmdTokenizer.tokenize(str);

            /* 
             *   we have a brand new command line, so we're starting a
             *   brand new sentence 
             */
            firstInSentence = true;

            /* set the issuing and target actor according to the exception */
            issuingActor = rcsExc.issuingActor_;
            targetActor = rcsExc.targetActor_;

            /* 
             *   Put this work into the target actor's work queue, so that
             *   the issuer will carry out the command at the next
             *   opportunity.  This is a brand new command line, so it
             *   starts a new sentence.  
             */
            targetActor.addPendingCommand(true, issuingActor, toks);

            /* we're done processing this command */
            return;
        }
    }
}

modify SpecialTopic
    qwe {} 
    matchPreParse(str, procStr)
    {
        /* build the regular expression pattern if there isn't one */
        if (matchPat == nil)
        {
            local pat;

            /* start with the base pattern string */
            pat = '<nocase><space>*(%<';

            /* add the keywords */
            for (local i = 1, local len = keywordList.length() ;
                 i <= len ; ++i)
            {
                /* add this keyword to the pattern */
                for(local j = 1, local len2 = keywordList[i].length() ;
                    j <= len2 ; ++j)
                {
                    local ch = keywordList[i].substr(j, 1);
                    local found = nil;
            	    
                    for(local k = 1; k <= mappings.length(); k++)
                    {
                        if(ch == mappings[k][1])
                        {
                            pat += '[' + ch + mappings[k][2] + ']';
                            found = true;
                            break;
                        }
                    }
            	    
                    if(!found) pat += ch;
                }

                /* add the separator or terminator, as appropriate */
                if (i == len)
                    pat += '%><space>*)+';
                else
                    pat += '%><space>*|%<';
            }

            /* create the pattern object */
            matchPat = new RexPattern(pat);
        }

        /* we have a match if the pattern matches the processed input */
        return rexMatch(matchPat, procStr) == procStr.length();
    }
    mappings =
    [
        ['ř', 'r'],
        ['í', 'i'],
        ['š', 's'],
        ['ž', 'z'],
        ['ť', 't'],
        ['č', 'c'],
        ['ý', 'y'],
        ['ů', 'u'],
        ['ň', 'n'],
        ['ú', 'u'],
        ['ě', 'e'],
        ['ď', 'd'],
        ['á', 'a'],
        ['é', 'e'],
        ['ó', 'o']
    ]
;
