#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   KAPITÁN S VELITELEM VYŘIZUJÍ PAPÍRY
 *
 *   Když kapitán s velitelem vyřizují v kajutě papíry, hráč za nimi přijde s
 *   různými otázkami. Kdyby nic jiného, tak časem zejména zjistí, že nemá dost
 *   součástek na opravu lodi. Během toho je potřeba, abychom vyvolali dojem, že
 *   rozmlouvá s oběma postavami najednou. To ale v TADSu není běžně možné, hráč
 *   vždy mluví jen s jednou postavou.
 *
 *   Pod objektem commonTopics sdílíme témata konverzace pro obě postavy a
 *   zároveň synchronizujeme konverzační stavy obou postav, aby se vyvolal dojem
 *   společného rozhovoru.
 */
commonTopics: CommonTopicDatabase;

/*
 *   V knihovně neexistuje kombinace AskTellShowTopic s AskForTopic, ale můžeme
 *   ji nakombinovat sami. Stačí vyjít z TopicOrThingMatchTopic, která spojuje
 *   oba druhy (ThingMatchTopic a TopicMatchTopic). Všechny definované kombinace
 *   jsou pak už jen o vyjmenování možností v includeInList.
 */
+ TopicOrThingMatchTopic, SuggestedAskTopic @firstModule
    "<.p><q>No, chtěl bych se zeptat,</q> začínáš váhavě, <q>co s tím
        modulem?</q>

        <.p><q>A to se ptáš mě?</q> opáčil kapitán, <q>ty budeš muset vylízt ven
        a podívat se na to zblízka.</q>

        <.p><q>Boris se v tomhle celkem vyzná,</q> radí velitel, <q>zajdi za ním
        a třeba ti poradí.</q> "

    includeInList = [&askTopics, &tellTopics, &showTopics, &askForTopics]

    /*
     *   Jestliže nastavíme téma jako doporučené (SuggestedAskTopic), aby se na
     *   něj hráč zeptal, musíme napsat, jak bude téma označené v nabídce, tj.
     *   uvedeme název objektu ve čtvrtém pádě (zeptat se na koho/co). V případě
     *   SuggestedTellTopic pak mohl bys mu říci o kom/čem 6. pád.
     */
    name = 'modul'
;

/*
 *   AltTopic je odpověď, která nahradí výše uvedenou odpověď na @firstModule,
 *   jakmile je splněna podmínka isActive. V tomto případě po té, co hráč modul
 *   vyjmul z trupu lodi.
 */
++ AltTopic
    "<.p>Hrdě jsi prohlásil: <q>Tak ten první modul je zcela v pořádku, jsem
        si s tím zcela jistý!</q>

        <.p><q>Jo, jasně,</q> dostalo se ti odpovědi, <q>tak už ho nech být a
        řeš ten vadný.</q> "

    /*
     *   Jakmile modul vezmu, velitel s kapitánem vysmahnou a nevrátí se dříve,
     *   než budu vědět, že je modul v pořádku.
     */
    isActive = firstModule.moved
;

/* ------------------------------------------------------------------------ */

+ AskTellTopic, SuggestedTellTopic
    [secondModule, brokenComponents, newComponent, componentsGroup]
    "<.p><q>Kapitáne, veliteli, provedl jsem diagnózu vadného modulu a stačí
        vyměnit několik součástek. Na lodi je ale nemáme.</q>

        <.p><q>Pokud vím,</q> ozval se velitel, <q>měl vám technik umožnit
        přístup do databáze. Najděte si tam, co potřebujete.</q> "

    name = 'porouchaných součástkách'

    /*
     *   Objekt brokenComponents je zpočátku skrytý (Hidden) a vlastnost
     *   discovered testuje, zda jsme ho už nechali ve hře objevit.
     */
    isActive = brokenComponents.discovered
;

/*
 *   Do textu v uvozovkách lze vložit různé výrazy ohraničené dvojitými
 *   špičatými závorkami a ty se vhodnotí. Buď mohou něco zobrait, jako jméno
 *   předmětu v prvním případě nebo jen něco udělat na pozadí, jako v případě
 *   druhém.
 *
 *   Také se tu objevuje tag <.topics>, který vynutí vypsání doporučených témat
 *   konverzace a tag <.reveal give-components>, který je obdobou volání makra
 *   gReveal('give-components').
 */
++ AltTopic
    "<.p><q>Kapitáne, máme problém,</q> s povzdechem jsi začal řeč, <q>veliteli,
        prohlédl jsem vaši databázi a potřebnou součástku jsem našel jen jednu.
        Na opravu modulu potřebuju tři,</q> dořekl jsi tu jobovku a upřel pohled
        na <<commonTopics.fromActor.nameKohoCeho>>.

        <.p>Velitel se podíval na kapitána, kapitán se podíval na velitele a pak
        se oba společně zahleděli na tebe: <q>No, to je pěkné. Ukažte, co je to
        za součástky,</q> ozval se velitel, <q>v jakém jsou stavu?</q>
        <.reveal give-components><.topics><<me.setThem(brokenComponents)>> "

    isActive = gRevealed('low-stock')
;

/* ------------------------------------------------------------------------ */
/*
 *   Zde dublujeme AskTellTopic vyse, nez se nam rozdeli pozdeji reakce. Kromě
 *   běžných témat zeptej se na / řekni o existují i taková témata jako
 *   GiveShowTopic, který reaguje napředání či ukázání předmětu postavě.
 */
+ GiveShowTopic [brokenComponents, newComponent, componentsGroup]
    "<.p><q>Kapitáne, veliteli, provedl jsem diagnózu vadného modulu a stačí
        vyměnit několik součástek. Na lodi je ale nemáme.</q>

        <.p><q>Pokud vím,</q> ozval se velitel, <q>měl vám technik umožnit
        přístup do databáze. Najděte si tam, co potřebujete.</q> "
;

++ AltTopic
    "<.p><q>Kapitáne, máme problém,</q> s povzdechem jsi začal řeč, <q>veliteli,
        prohlédl jsem vaši databázi a potřebnou součástku jsem našel jen jednu.
        Na opravu modulu potřebuju tři,</q> dořekl jsi tu jobovku a upřel pohled
        na <<commonTopics.fromActor.nameKohoCeho>>.

        <.p>Velitel se podíval na kapitána, kapitán se podíval na velitele a pak
        se oba společně zahleděli na tebe: <q>No, to je pěkné. Ukažte, co je to
        za součástky,</q> ozval se velitel, <q>v jakém jsou stavu?</q>
        <.reveal give-components><.topics> "

    isActive = gRevealed('low-stock')
;

++ AltTopic, SuggestedGiveTopic
    topicResponse()
    {
        /*
         *   Metoda isIn(me) testuje, zda je předmět obsažen v objektu me, tedy
         *   v inventáři hráče.
         */
        if(brokenComponents.isIn(me) && newComponent.isIn(me))
        {
            "<.p>Podáváš <<commonTopics.fromActor.nameKomuCemu>> součástky,
                zvlášť tu správnou a pak ty vadné. I <<commonTopics.fromActor ==
                commander ? 'kapitán' : 'velitel' >> se zvědavě kouká.

                <.p><q>Takže tohle jsou ty vadné a tahle je v pořádku?</q>
                ujistil se velitel a obracel v rukou jednu ze součástek. Kývnul
                jsi hlavou na souhlas. Kapitán se zvedl a mávnutím ruky tě
                propouští: <q>Dej si oraz, my tady s Ivanem ještě objedeme
                venkovní stanoviště a cestou to probereme. U jídla se pak
                domluvíme, co dál.</q>

                <.p>Vyšli jste ven na chodbu, velitel zaklapl dveře kajuty, a
                pak s kapitánem odešli zelenými dveřmi do druhé části
                základny. ";

            /* Hráč mohl jen ukázat, i tak si je velitel nechá. */
            brokenComponents.moveInto(commander);
            newComponent.moveInto(commander);

            /*
             *   Postavy na rozdíl od předmětů přesouváme funkcí
             *   moveIntoForTravel.
             */
            me.moveIntoForTravel(corridorEast);
            captain.moveIntoForTravel(nil);
            commander.moveIntoForTravel(nil);

            /* Zavřeme za sebou dveře. */
            commandersDoor.makeOpen(nil);

            /*
             *   Nyní začne Borisova kofeinová závislost. Je zde celá řada
             *   PresentLater předmětů, které se mají na základně objevit, tak
             *   je najednou zhmotníme pomocí klíče, kterým jsou identifikovány.
             */
            gReveal('coffee');
            PresentLater.makePresentByKey('coffee');

            /*
             *   Protože jsme vyšli na chodbu, rozhlédneme se, aby o přesunu
             *   hráč věděl.
             */
            "<.p>";
            me.lookAround(nil);

            clock.eventReached();
            achievement.awardPointsOnce();
        }
        else if(brokenComponents.isIn(me))
        {
            "<.p>Podáváš veliteli vadné součástky.

                <.p><q>Takže tohle jsou ty vadné?</q> ujistil se velitel a
                obracel v rukou jednu ze součástek. Kývnul jsi hlavou na
                souhlas.

                <.p><q>Kde máš tu v pořádku?</q> pokračoval velitel.

                <.p><q>No,</q> zaváhal jsi s odpovědí,
                <q><<if !gRevealed('viz54-found')>>podle systému by ve skladu
                jedna měla být, ale ještě jsem ji nenašel.<<else>>našel jsem ji
                ve skladu, ale nechal jsem ji někde povalovat.<<end>></q>

                <.p><q>Dobře,</q> vrátil ti velitel vadné součástky. <q>Běž
                ještě najít tu novou a přines ji sem také.</q> ";
        }
        else
        {
            "<.p>Podáváš veliteli novou součástku.

                <.p><q>Takže tohle je ta nová?</q> ujistil se velitel a obracel
                ji v rukou. Kývnul jsi hlavou na souhlas.

                <.p><q>Kde máš ty špatné?</q> pokračoval velitel.

                <.p><q>No,</q> zaváhal jsi s odpovědí, <q>asi jsem je někde
                nechal položené.</q>

                <.p><q>Dobře,</q> vrátil ti velitel součástku. <q>Běž a přines
                sem i ty vadné.</q> ";
        }
    }

    clock: ClockEvent { eventTime = [2, 9, 38] }
    achievement: Achievement { +1 "předání porouchaných součástek" }

    name = brokenComponents.nameKohoCo
    isActive = gRevealed('give-components')
;

/* ------------------------------------------------------------------------ */
/*
 *   Velitel sice má téma kapitána ve své databázi a naopak, ale při
 *   dvorozhovoru se může stát, že se hráč zeptá kapitána na kapitána, i když
 *   to myslí obráceně.
 */
+ AskTellTopic @captain
    "<.p><q>Veliteli?</q> vznesl jsi dotaz, <q>znáte kapitána Scotta už hodně
        dlouho?</q>

        <.p><q>Roky, chlapče, celé roky, ale nestalo se v nich nic, co by tě
        mohlo zajímat,</q> odpálkoval tě velitel. "
;

+ AskTellTopic @commander
    "<.p><q>Kapitáne?</q> zeptal ses, <q>je velitel váš dobrý známý?</q>

        <.p><q>Jo,</q> houkl na tebe kapitán a jeho stažené obočí ti odseklo
        další dotazy. "
;

/* ------------------------------------------------------------------------ */
/*
 *   Zde máme specifické DefaultTopicy kvůli navození atmosféry. To ale znamená,
 *   že zaujmou roli každého tématu, které zde nenalezne a tím by překryla i
 *   všechna témata, které nejsou zde ve společné databázi, což nechceme. Proto
 *   pomocí deferToEntry řekneme, že jiná, než DefaultTopic témata se mají
 *   hledat v nadřazené databázi témat, tj. ne jen zde, ale i přímo u postavy.
 */
+ DefaultAskTopic, ShuffledEventList
    [
        '<.p><q>Mohl bych se ještě zeptat,</q> začal jsi a pokračoval otázkou,
            ale odpovědi ses nedočkal:
            <.p><q>Myslíš, že je tohle téma v tuto chvíli podstatné?</q>
            významně si poklepal kapitán na čelo. ',
        '<.p>Tvá otázka evidentně nepadla na úrodnou půdu:
            <.p><q>Tak to máš smůlu,</q> pokrčil velitel rameny a kapitán
            pokračoval, <q>strýček Google právě šel spát.</q> ',
        '<.p>vyložil jsi svůj problém, ale kapitán se jen ušklíbl:
            <.p><q>Tsss,</q> pohoršil se, <q>to tě doma nenaučili neklást tak
            blbé otázky?</q> '
    ]

    deferToEntry(entry) { return !entry.ofKind(DefaultTopic); }
;

+ DefaultAnyTopic
    "<.p>
        <.p>A něco, co ještě nevíme, nám říci nemůžeš? zakroutil hlavou
        velitel. "

    deferToEntry(entry) { return !entry.ofKind(DefaultTopic); }
;
