#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/*
 *   V tomto souboru jsou definovány rady k příběhu pro případ, že by se hráči
 *   někde zasekli a nevěděli, jak dál. Rady jsou uspořádány do kapitol podle
 *   části hry, které se týkají a v každé kapitole je řada témat. Pro každé téma
 *   jsou rady graduálně odstupňovány, aby si hráč sám zvolil, jak silnou radu
 *   chce dostat.
 *
 *   Nabídka témat se řídí kontextem, kde zrovna hráč ve příběhu je, aby se
 *   nedozvěděl o nekterých věcech příliš brzy a aby v nabídce nebyly věci,
 *   které dávno vyřešil. Kontext se odvozuje z podmínek openWhen a closeWhen.
 *   Často se testují určité události pomocí makra gRevealed(), které jsou všude
 *   možně v kódu hry značené.
 */
topHintMenu: TopHintMenu 'Rady a nápovědy k příběhu';

/* Nejprve poskytneme návod k použití samotného systému rad a nápověd. */
+ HintLongTopicItem 'Informace o systému rad'
    'Dávat dobré rady v textovkách je ošidné. Pokud vyzradíme příliš mnoho, může
    to zkazit všechnu zábavu, ale někdy zase může být zaseknutí na jednom puzzlu
    tak frustrující, že už budeš chtít celé řešení naservírovat na podnose. Náš
    systém rad se snaží zachovat rovnováhu tím, že se ty sám rozhodneš, jak
    silnou radu chceš získat.
    <.p>
    Rady jsou připraveny ve formě otázek a odpovědí a otázky jsou zatříděné
    podle oblastí příběhu. Abychom zabránili příliš brzkému vyzrazení
    potenciálních zápletek, systém se pokusí podle toho, kde v příběhu jsi,
    zobrazit jen ta témata, o kterých bys měl už vědět.
    <.p>
    Vyber si obecnou oblast hry, ve které ses zasekl, a tím se dostaneš k
    seznamu otázek. Z něj si vyber otázku, která se nejvíce přibližuje problému,
    na který se snažíš přijít, a hra ti začne nabízet nápovědy k dané otázce
    jednu po druhé. První nápovědy budou velice vágní a obecné a obvykle ti nic
    neprozradí. Každá další však bude postupně čím dál tím více odkrývat, až k
    té poslední, která u každé otázky obvykle prozradí přesné řešení. Zastavit
    můžeš po kterékoliv radě -- stačí zmáčknout <b>K</b> a budeš vrácen do
    příběhu. Pokus se zastavit hned po první radě, která ti vnukne jakékoliv
    nové myšlenky, aby ses vyhnul prozrazení příliš mnoha najednou; později se
    ke stejnému tématu můžeš kdykoliv vrátit a v případě potřeby si přečíst
    další rady.
    <.p>
    Uvědom si ale, že většina lidí si užije hru mnohem více, když sama vyřeší
    všechny puzzly bez jakýchkoliv rad. Ve hře jsme se snažili navrhnout všechny
    puzzly tak, aby byly férové, takže většina hráčů bude moci postupovat
    příběhem bez šílených logických kotrmelců, nahodilého hádání či čtení mysli
    autora. Pokud se přesto zasekneš, rady máš připravené, jen pamatuj, že rady
    se mají užívat velice střídmě. '

    /* Tohle bude první položka v menu. */
    topicOrder = 1
;

/* ------------------------------------------------------------------------ */
/*
 *   PŘED PŘISTÁNÍM NA ASTEROIDU
 */
+ HintMenu 'Na palubě lodi';

++ Goal 'Kdo jsem?'
    [
        'Hra ti prostřednictvím intra a různých předmětů sděluje, kdo a kde jsi.
            Zkus se chvíli po lodi pohybovat a prozkoumat různě věci a promluvit
            si s kapitánem. ',
        'Zadej příkaz PROZKOUMEJ SEBE, ve své kajutě máš své rozkazy, takže
            PŘEČTI ROZKAZY. Kromě toho můžeš PROZKOUMAT LOĎ a dojít na příd si
            promluvit s kapitánem. Zadej nejprve MLUV S KAPITÁNEM a potom ZEPTEJ
            SE NA ASTEROID a ZEPTEJ SE NA CESTU. ',
        'Jsi čerstvý absolvent orbitální akademie a jsi své první delší cesta
            vesmírem. Máš za úkol dopravit zásoby na těžařskou základnu na
            asteroidu. '
    ]

    /* Bude k dispozici od samého začátku. */
    openWhenTrue = true

    /* Vlastnost described předmětu určuje, zda ho hráč už prozkoumal. */
    closeWhenTrue = me.described && orders.described || gRevealed('ship-landed')
;

++ Goal 'Co mám udělat?'
    [
        'Až přijde čas, tak máš vystřídat kapitána ve službě a převzít řízení.
            Ale zatím máš ještě trochu času, takže se porozhlédni po lodi a nauč
            se příběh trochu ovládat. ',
        'Ve společenské místnosti je běžecký pás, trochu si na něm zacvič. Pak
            se také nasnídej, kapitán ti nechal v troubě sendvič. ',
        'Jdi do společenské místnosti a potom dej příkaz STOUPNI SI NA PÁS.
            Potom ho prozkoumej a prozkoumej ovládací pultík. Příkazem OTOČ
            REGULÁTOR NA 2 pustíš pás na střední rychlost. Na ovládacím pultíku
            můžeš PROZKOUMAT POČÍTADLO a až budeš mít dost, SLEZ Z PÁSU. ',
        'Pokud jsi tubu z ohřívače nevzal, tak jen ZAPNI OHŘÍVAČ a potom SNĚZ
            TUBU. '
    ]
    openWhenTrue = true

    /*
     *   Jakmile si hráč na začátku hry zaběhá na pásu, nastavíme pomocí příkazu
     *   gReveal('treadmill-run') vlajku nazvanou treadmill-run informující, že
     *   tento úkol byl splněn. Tady makrem gRevealed testujeme, že byla vlajka
     *   nastavena.
     */
    closeWhenTrue = gRevealed('treadmill-run') && tube.eated
;

++ Goal 'Jak převezmu službu?'
    [
        'Dojdi si promluvit s kapitánem. ',
        'Jdi do pilotní kabiny a zadej příkaz MLUV S KAPITÁNEM a potom PŘEVEZMI
            SLUŽBU. '
    ]

    /* Vlastnost eated určuje, zda jsme potravinu snědli. */
    openWhenTrue = gRevealed('treadmill-run') && tube.eated

    /* Pokud testujeme jen jednu reveal vlajku, můžeme zápis zkrátit. */
    closeWhenRevealed = 'me-driving'
;

++ Goal 'Jak se řídí loď?'
    [
        'Povětšinu času ji řídí autopilot a na tobě je jen dozor nad přístroji
            na palubní desce, které můžeš prozkoumat. '
    ]
    openWhenRevealed = 'me-driving'
    closeWhenRevealed = 'ship-landed'
;

/* ------------------------------------------------------------------------ */
/*
 *   NEHODA
 */
+ HintMenu 'Nehoda lodi';

++ Goal 'Co se to stalo za havárii?'
    [
        'To se snadno dozvíš, zkus se po lodi pohybovat a prozkoumat různé
            věci. ',
        'Kde se nejspíš dozvíš, jaký je stav palubních systémů? ',
        'Co třeba v pilotní kabině? ',
        'Prohlédl sis dobře palubní desku? ',
        'Prozkoumal jsi obrazovky na palubní desce? ',
        'Na obrazovce letového plánu uvidíš, že se loď řítí do srážky a na
            obrazovce stavu, že vypadlo osvětlení, topení a radarová navigace.
            Podpora života však funguje.<<gReveal('hint-collision')>> '
    ]
    openWhenRevealed = 'ship-malfunction'
    closeWhenRevealed = 'ship-landed'
;

++ Goal 'Jak mám vzbudit kapitána?'
    [
        'A zkoušel jsi to důkladně? ',
        'Promiň, ne opravdu vzbudit nejde. Vzal si piluli na spaní a farmacie
            učinila neuvěřitelné pokroky. '
    ]
    openWhenRevealed = 'hint-wake-up'
    closeWhenRevealed = 'ship-landed'
;

++ Goal 'Jak mám zabránit srážce?'
    [
        'Co se to vlastně na lodi porouchalo? ',
        'Porouchala se automatická navigace a vede loď do srážky. Co ji zkusit
            vypnout? ',
        'Či přesněji řečeno, co zkusit vypnout autopilota? ',
        'Ovládání autopilota najdeš nejspíše v pilotní kabině. ',
        'Prohlédl sis dobře palubní desku? ',
        'Prozkoumal jsi tlačítka na palubní desce? ',
        'V kokpitu zadej příkaz STISKNI TLAČÍTKO AUTOPILOTA. '
    ]
    openWhenRevealed = 'hint-collision'
    closeWhenTrue = gRevealed('autopilot-frozen') || gRevealed('ship-landed')
;

++ Goal 'Jak to, že autopilot nejde vypnout?'
    [
        'Je nějaký zaseknutý, budeš muset najít jinou cestu. ',
        'Zkoušel ses dozvědět více informací o lodi, ve které letíš? ',
        'V takovýchto lodích bývají servisní manuály. ',
        'Hledal jsi důkladně? Hledej někde, kde by ho měl pilot při ruce. ',
        'Prozkoumal jsi v kokpitu palubní desku? ',
        'Ve štěrbině na palubní desce je zasunutý manuál. Zadej příkaz VEM
            MANUÁL a potom PŘEČTI MANUÁL. '
    ]
    openWhenRevealed = 'autopilot-frozen'

    /* Vlastnost moved předmětu určuje, zda s ním hráč manipuloval, tj. vzal. */
    closeWhenTrue = manual.moved
    closeWhenRevealed = 'ship-landed'
;

++ Goal 'Jak se dostanu do servisního podpalubí?'
    [
        'Žádné dveře do něj nevedou. Přesto ale když je to podpalubí, kde by
            mohlo být? ',
        'Co třeba pod některou z místností v lodi? ',
        'Nebo konkrétně pod podlahou největší místnosti v lodi. ',
        'Prozkoumal jsi podlahu ve společenské místnosti? ',
        'Ve společenské místnosti zadej příkaz PROZKOUMEJ PODLAHU. '
    ]
    openWhenTrue = manual.moved

    /* Testovat lze i přidělení bodů za nějakou akci. */
    closeWhenAchieved = lrPanelLock.achievement
;

++ Goal 'Jak otevřu podlahový panel ve společenské místnosti?'
    [
        'Prozkoumal jsi ho důkladně? ',
        'Všiml sis otočných zámků? ',
        'Zkusil jsi je otočit? ',
        'Zadej příkaz OTOČ ZÁMKY nebo ODEMKNI ZÁMKY. '
    ]

    /* Podmínku prozkoumání jednoho předmětu lze zapsat i zkráceně. */
    openWhenDescribed = lrFloor

    closeWhenAchieved = lrPanelLock.achievement
;

++ Goal 'Jak získám světlo v servisním podpalubí?'
    [
        'V podpalubí žádný zdroj světla není, budeš si ho muset přinést. ',
        'Hledal jsi důkladně po celé lodi? ',
        'Nemusí to být zrovna svítilna, co něco méně obvyklého? ',
        'Čím si posvítíš v nouzi, když se třeba trefuješ klíčem do zámku a nemáš jiný
            zdroj světla k dispozici? ',
        'Hledal jsi ve svých věcech ve své kajutě? ',
        'Hledal jsi v přihrádkách? ',
        'Použij tablet, když ho zapneš, displej vydává dost oslnivé světlo. '
    ]
    openWhenRevealed = 'ship-dark'
    closeWhenAchieved = lowerDeck.scoreMarker
;

++ Goal 'Co mám udělat v servisním podpalubí?'
    [
        'Manuál se zmiňoval o nouzovém ovládacím panelu, na kterém jde vypnout
            porouchaný autopilot. Našel jsi ho? ',
        'Všiml sis tlačítek na panelu? ',
        'Zkus tlačítka mačkat a pozorovat, co se stane. Zadej např. příkaz
            STISKNI TLAČÍTKO 3. '
    ]
    openWhenAchieved = lowerDeck.scoreMarker
    closeWhenRevealed = 'hint-panel-operated'
;

++ Goal 'Co mám na nouzovém panelu udělat?'
    [
        'Máš vypnout porouchaného autopilota a zapnout ruční řízení. ',
        'Či přesněji máš mačkáním tlačítek dosáhnout toho, aby se prohodily
            barvy kontrolek na panelu přesně naopak. '
    ]
    openWhenRevealed = 'hint-panel-operated'
    closeWhenRevealed = 'ship-landed'
;

++ Goal 'Proč se panel občas zasekne a nejde s ním už nic dělat?'
    [
        'Zkoušel jsi trochu s panelem experimentovat, abys přišel na pravidla,
            podle kterých se chová? Když se zasekne, tak zadej STISKNI R. ',
        'Pokud stále nevíš, nedá se někde o panelu ještě něco zjistit? Co ti už
            párkrát pomohlo? ',
        'Zkus opět pročíst manuál k lodi. ',
        'Panel se zasekne tehdy, když už není možné přesunout žádnou kontrolkou,
            když už došly možné tahy. ',
        'Zelené je možné přesouvat jen doprava a červené jen doleva. Přeskočit
            lze jen ob jednu kontrolku opačné barvy. '
    ]
    openWhenRevealed = 'hint-panel-stalled'
    closeWhenRevealed = 'ship-landed'
;

++ Goal 'Pravidla přesouvání jsou jasná, ale stále se zasekávám.'
    [
        'Přeskočit můžeš jen jednu kontrolku opačné barvy, takže se musíš
            vyhnout situaci, že bys měl dvě stejné kontrolky vedle sebe. ',
        'Zkus začít stisknutím 3 a 5. Potom přemýšlej, co neudělat. ',
        'Po stisknutí 3 a 5 nemačkej 4, protože pak ať dáš 2 nebo 6, skončí dvě
            stejné u sebe. ',
        'Po stisknutí 3 a 5 zmáčkni 6 a pak popocházej jen zelenými, dokud to
            půjde. ',
        'Pak zase jen červenými, dokud to jde a takhle to střídej až do
            vyřešení. ',
        'Celá správná sekvence se dá zadat příkazem ZADEJ 356421357642354 NA
            PANELU. '
    ]
    openWhenRevealed = 'hint-panel-stalled'
    closeWhenRevealed = 'ship-landed'
;

/* ------------------------------------------------------------------------ */
/*
 *   OPRAVA LODI
 */
+ HintMenu 'Oprava lodi na základně';

++ Goal 'Co mám dělat těsně po přistání?'
    [
        'Nech se unášet příběhem, vše se postupně vysvětlí. ',
        'Jdi s kapitánem do základny a přivítejte se s posádkou asteroidu.
            Nabídnou ti své vybavení, které ti pomůže s opravou lodi. ',
        'Po přistání zadej NÁSLEDUJ KAPITÁNA a ocitnete se v kupoli základny.
            Potom zadej NE a potom ANO. Boris tě odvede do dílny, zadej dvakrát
            po sobě NÁSLEDUJ. '
    ]
    openWhenRevealed = 'ship-landed'
    closeWhenRevealed = 'hint-supply-visited'
;

++ Goal 'Jak mám opravit loď'
    [
        'Rozbila se radarová navigace autopilota, takže tu navigaci budeš muset
            najít a zjistit, co se s ní stalo. ',
        'Kde by mohla být? Uvnitř lodi ji nehledej, čidla musejí být
            venku. ',
        'Vyprav se ven k lodi a modul navigace najdeš v trupu na přídi. '
    ]
    openWhenRevealed = 'hint-supply-visited'
    closeWhenTrue = firstModule.moved
;

++ Goal 'Jak projdu přechodovou komorou?'
    [
        'Obléknul sis v kupoli vesmírný skafandr? ',
        'Vejdi do přechodové komory, pákami se ovládají dveře. ',
        'Nejprve zavři vnitřní dveře příkazem POHNI ZELENOU PÁKOU a pak otevři
            venkovní příkazem POHNI ČERVENOU a vyjdi VEN. '
    ]
    openWhenRevealed = 'hint-airlock-visited'
    closeWhenRevealed = 'hint-port-visited'
;

++ Goal 'Jak mám opravit modul navigace?'
    [
        'Nejprve budeš muset zjistit, jakou má závadu. ',
        'Jaký přístroj by ti mohl pomoci závadu odhalit? ',
        'Jaký přístroj je přímo dělaný na hledání závad? ',
        'Co ti Boris ukazoval ve skladu? ',
        'Vem modul s sebou do skladu. Prověř ho UniDiPem. ',
        'Přines modul do dílny a zadej příkaz PŘIPOJ MODUL K UNIDIPU. '
    ]
    openWhenTrue = firstModule.moved
    closeWhenRevealed = 'module1-ok'
;

++ Goal 'Modul navigace je v pořádku, jak to?'
    [
        'Zkusil jsi ho prověřit pořádně? ',
        'Modul je opravdu v pořádku, závada bude asi někde úplně jinde. ',
        'Nevíš-li si rady, třeba ti někdo pomůže. ',
        'Boris je technik, v takovýchto věcech se vyzná. ',
        'Zajdi za Borisem do velínu a ZEPTEJ SE NA MODUL. ',
        'Závada je ve skutečnosti ve vysílacím modulu a ne přijímacím.
            <<gReveal('hint-second-module')>> '
    ]
    openWhenRevealed = 'module1-ok'
    closeWhenTrue = secondModule.moved
;

++ Goal 'Kde najdu vysílací modul?'
    [
        'A zkoušel jsi ho vůbec hledat? ',
        'Opravdu? ',
        'Je na úplně stejném místě, jako přijímací modul, v přední části trupu
            lodi. '
    ]
    openWhenRevealed = 'hint-second-module'
    closeWhenTrue = secondModule.moved
;

++ Goal 'Co mám udělat s vysílacím modulem?'
    [
        'Nejprve budeš muset zjistit, jakou má závadu. ',
        'Postupuj stejně, jako s přijímacím modulem. ',
        'Vem modul s sebou do skladu. Prověř ho UniDiPem. ',
        'Přines modul do dílny a zadej příkaz PŘIPOJ VYSÍLACÍ MODUL K UNIDIPU. '
    ]
    openWhenTrue = secondModule.moved

    /* Vlastnost discovered skrytého Hidden předmětu určuje, zda byl objeven. */
    closeWhenTrue = brokenComponents.discovered
;

++ Goal 'Kde seženu součástky na výměnu?'
    [
        'Balíků ve skladu je příliš mnoho na nahodilé přebírání. Zjisti nejprve,
            kde přesně hledat. ',
        'Zkoušel ses někoho zeptat? ',
        'Zkoušel jsi hledat v databázi základny? ',
        'Vem svůj tablet a zadej příkaz HLEDEJ VIZ-54. ',
        'Dozvěděl ses, ve kterém balíku hledat novou součástku. Nejprve najdi
            balík ',
        'Jdi do skladu a zadej HLEDEJ BALÍK C3-A24 V REGÁLECH. Potom OTEVŘI
            BALÍK a VEM SOUČÁSTKU. '
    ]
    openWhenTrue = brokenComponents.discovered
    closeWhenRevealed = 'low-stock'
;

++ Goal 'Našel jsem jen jednu součástku na výměnu, potřebuji ale tři!'
    [
        'Líná huba, holé neštěstí. ',
        'Poraď se o svém problému s velitelem základny. ',
        'Zajdi do kajuty velitele a ŘEKNI O SOUČÁSTKÁCH. ',
        'I když na skladě je jen jedna náhradní součástka, přesto ji najdi a vem
            s sebou. ',
        'Jakmile tě kapitán s velitelem vyzve, abys jim součástky ukázal, tak
            UKAŽ SOUČÁSTKY VELITELI. '
    ]
    openWhenRevealed = 'low-stock'
    closeWhenRevealed = 'coffee';
;

++ Goal 'Kde najdu velitele a kapitána?'
    [
        'Prošel jsi celou základnu? ',
        'Chodba ve spodním patře pokračuje na východ, kde jsou kajuty. ',
        'Kapitán šel s velitelem do jeho kajuty. ',
        'Ze skladu jdi VEN, potom na VÝCHOD a do kajuty na SEVER. '
    ]
    openWhenRevealed = 'hint-supply-visited'
    closeWhenRevealed = 'coffee';
;

++ Goal 'Co to přede mnou ve spěchu ukryli do trezoru?'
    [
        'Jsi zvědavý? ',
        'To je dobře! '
    ]
    openWhenRevealed = 'hint-hiding'
    closeWhenAchieved = tresor.subContainer.scoreMarker
;

/* ------------------------------------------------------------------------ */
/*
 *   PODEZŘELÝ KONTEJNER
 */
+ HintMenu 'Podezřelý kontejner';

++ Goal 'Mohu něco zjistit o podezřelé bedně?'
    [
        'Co se poohlédnout v nějaké databázi? ',
        'Neumožnil ti Boris někam přistupovat? ',
        'Zkus použít svůj tablet. ',
        'Vem tablet do ruky a zadej příkaz HLEDEJ KBR-3867. '
    ]
    openWhenTrue = suspiciousContainer.discovered
    closeWhenAchieved = suspiciousTopic.achievement
;

++ Goal 'Jak zjistím, kdo nám bednu naložil do lodi?'
    [
        'Věnoval jsi dostatečnou pozornost informacím o bedně v databázi? ',
        'Databáze ukrývají informace o spoustě věcí. ',
        'Třeba i o vesmírných letech. ',
        'V informacích o bedně v databázi bylo zmíněno i číslo letu, zkus ho
            vyhledat. ',
        'Vem tablet a zadej příkaz HLEDEJ AV53-81. '
    ]
    openWhenAchieved = suspiciousTopic.achievement
    closeWhenAchieved = plutoTopic.achievement
;

++ Goal 'Kde tu bednu vlastně najdu?'
    [
        'Přímo nikde, ale když se budeš po základně trochu pohybovat a zkoumat,
            tak na obsah zásilky přijdeš. '
    ]

    /* Zde testujeme, zda jsme objekt už vyhodili ze hry. */
    openWhenTrue = !suspiciousContainer.location

    closeWhenAchieved = tresor.subContainer.scoreMarker
;

/* ------------------------------------------------------------------------ */
/*
 *   PO ODCHODU KAPITÁNA S VELITELEM
 */
+ HintMenu 'Po odchodu kapitána s velitelem';

++ Goal 'Co mám dělat?'
    [
        'Nevrtá ti hlavou pár věcí, které se staly? ',
        'Třeba ta podezřelá bedna tam venku nebo ty papíry, které před tebou
            ukryli do trezoru, nebo kam to vlastně kapitán s velitelem odjeli? '
    ]
    openWhenRevealed = 'coffee'
    closeWhenRevealed = 'lunch'
;

++ Goal 'Mohu se nějak zbavit Borise?'
    [
        'Pobyl jsi chvíli v jeho blízkosti? ',
        'Určitě si všimneš, že má jednu slabůstku. ',
        'Boris je velice závislý na své kávě, která ho udržuje ve formě. ',
        'Možná bys té zavislosti mohl využít proti němu. ',
        'Možná bys mu mohl s kávou něco provést. ',
        'Rozhlížel ses pořádně ve skladu? ',
        'Všiml sis lékárny? ',
        'V lékárně je mj. projímadlo. Zkus být trochu darebák! ',
        'Přichystej past, pohraj si s jedním z připravených kafovaků v
            zásobníku. ',
        'Zadej příkaz DEJ PROJÍMADLO DO KAFOVAKU V ZÁSOBNÍKU. '
    ]
    openWhenRevealed = 'guard'
    closeWhenRevealed = 'hint-poisoned'
;

++ Goal 'Boris je na záchodě, kapitán s velitelem pryč, kdo mi teď poradí?'
    [
        'Máš pravdu, Boris je poněkud indisponován po tvém zásahu, i když… ',
        'Pokud bys naléhal, je možnost s Borisem mluvit. ',
        'Ne, vlézt k němu na záchod nemůžeš, ale zkousil jsi mluvit přes
            dveře? ',
        'Prostě na chodbě zadej příkaz MLUV S BORISEM a on se ozve. '
    ]
    openWhenRevealed = 'hint-poisoned'
    closeWhenRevealed = 'lunch'
;

/* ------------------------------------------------------------------------ */
/*
 *   TREZOR
 */
+ HintMenu 'Trezor v kajutě velitele';

++ Goal 'Lze se nějak dostat do trezoru?'
    [
        'Prozkoumal jsi číselník kódového zámku? ',
        'Zkoušel jsi s číselníkem otáčet? ',
        'Pomocí číselníku lze zadat na trezoru šestimístnou kombinaci.
            Nejsnažší je použít příkaz ZADEJ 123456 NA TREZORU. '
    ]
    openWhenRevealed = 'hint-poisoned'
    closeWhenAchieved = tresor.subContainer.scoreMarker
;

++ Goal 'Kde seženu kód od trezoru?'
    [
        'Dobrý kasař kód vědět nepotřebuje, dokáže na něj přijít sám. ',
        'Zkus si se zámkem trezoru trochu hrát, zadávat různé kombinace. '
    ]
    openWhenRevealed = 'hint-tried-tresor'
    closeWhenAchieved = tresor.subContainer.scoreMarker
;

++ Goal 'Mohu nějak zesílit zvuky, které z trezoru slyším?'
    [
        'Jak by se daly takové zvuky zesílit? Třeba nějakou pomůckou? ',
        'Rozhlížel ses pořádně ve skladu? ',
        'Všiml sis lékárny? ',
        'V lékárně je mj. lékařský stetoskop. Zahraj si na doktora! ',
        'Zadej příkaz NASAĎ SI STETOSKOP a potom PŘILOŽ STETOSKOP K TREZORU. '
    ]
    openWhenRevealed = 'hint-amplify'
    closeWhenAchieved = tresor.scoreMarker2
;

++ Goal 'Ok, teď slyším klapání trezoru, ale co s ním?'
    [
        'Budeš-li poslouchat pozorně, z trezoru se ozývají dva druhy zvuků --
            klik a klap. ',
        'Dokážeš zjistit, podle čeho se počet a druh klapání mění? ',
        'Zkoušej zadávat různé jednoduché kombinace, např. 111111, 222222
            apod. ',
        'Když trezor klape, tak jsi na dobré stopě. Vytipuj si číslice, na které
            reaguje. ',
        'Proč ale dva druhy klapání? Zkus ty správné číslice různě
            přehazovat. ',
        'Zkus umístit jednu správnou číslici mezi samé špatné a měnit její
            pozici. ',
        'Všimni si, že jsou nejdřív jen samé kliky a pak jen samé klapy. ',
        'Klik značí správnou číslici na správné pozici, klap správnou číslici na
            špatné pozici. Musíš se dostat k šesti klikům za sebou. ',
        'Správný kód je 645852. Napiš příkaz ZADEJ 645852 NA TREZORU. '
    ]
    openWhenAchieved = tresor.scoreMarker2
    closeWhenAchieved = tresor.subContainer.scoreMarker
;

/* ------------------------------------------------------------------------ */
/*
 *   POČÍTAČ
 */
+ HintMenu 'Počítač ve velínu';

++ Goal 'Lze se nějak dostat do počítače?'
    [
        'Boris počítač zamknul. Zkoušel jsi na terminálu zadávat nějaká
            hesla? ',
        'Nepřipomínají ti podivná písmenka, která počítač píše, něco, co jsi
            viděl? ',
        'Nevšiml sis něčeho podobného přímo ve velínu? ',
        'Prozkoumal jsi pořádně papírky přilepené na monitoru? ',
        'Zkoušel jsi něco z nich do počítače zadat? ',
        'Byl jsi dost trpělivý a důkladný? ',
        'Když do počítače zadáš obsah jednoho z papírků, počítač zareaguje! ',
        'Začni napsáním příkazu ZADEJ IŘOZA. '
    ]
    openWhenRevealed = 'hint-poisoned'
    closeWhenTrue = gRevealed('hint-computer-first')
        || gRevealed('computer-solved')
;

++ Goal 'Ok, IŘOZA něco udělala, ale stejně tomu nerozumím.'
    [
        'Neboj se zkusit další papírky. ',
        'Pokud to napoprvé nevyjde, nenech se odradit, časem počítač donutíš
            napsat více. ',
        'Potřebuješ se dostat do stavu, kdy počítač úspěšně vezme všechny kódy z
            papírků, pak se zase něco stane. ',
        'Správné pořadí je IŘOZA, ASÍDK, EUANŘ, S-E-N, ÝOPEK. Postupně je
            zadej. '
    ]
    openWhenRevealed = 'hint-computer-first'
    closeWhenRevealed = 'hint-computer-all'
;

++ Goal 'Zadal jsem všechny papírky a co dál?'
    [
        'Dál bys měl poslechnout výzvu a zadat heslo. ',
        'Stačí se jen trochu zamyslet nad tím, co jsi doposud zadával a co
            počítač odpovídal. ',
        'Vždyť ta písmenka vypadají docela česky. ',
        'Tedy to nevypadá na žádný posun abecedy ani na nějaké meziřádkové
            transformace. ',
        'Možná, když na to budeš chvilku koukat, tak se najednou zaraduješ! ',
        'Opravdu nemusíš dělat skoro nic… ',
        '…jen číst. ',
        'Pořád to nedává smysl? Tak to zkus nějak jinak! ',
        'Nejen zleva doprava. ',
        'Text se dá číst po sloupcích, proto ho počítač vyžadoval zadat jen v
            tomto pořadí. ',
        'Heslo je kořínek, zadej ho do počítače. '
    ]
    openWhenRevealed = 'hint-computer-all'
    closeWhenRevealed = 'computer-solved'
;

/* ------------------------------------------------------------------------ */
/*
 *   MÍSTNOST ZA ZELENÝMI DVEŘMI
 */
+ HintMenu 'Místnost za zelenými dveřmi';

++ Goal 'Lze se do místnosti dostat?'
    [
        'Nenašel bys způsob, jak za ně alespoň nahlédnout? ',
        'Ovšem že když je neotevřeš, nenahlédneš osobně, ale jsou i jiné
            způsoby, jak vidět na dálku. ',
        'Leccos na základně se dělá na dálku. ',
        'Třeba Boris na dálku řídil nakládku a vykládku lodi. ',
        'Všiml sis obrazovek ve velínu? ',
        'Na jedné z nich se ukazují záběry z kamerového systému. ',
        'Ve velínu zadej příkaz PROZKOUMEJ OBRAZOVKU KAMEROVÉHO SYSTÉMU. '
    ]
    openWhenRevealed = 'hint-poisoned'

    /* Použijeme-li dvě různé vlastnosti, kombinují se pomocí nebo. */
    closeWhenRevealed = 'hint-seen-room'
    closeWhenAchieved = robot.scoreMarker
;

++ Goal 'Lze nějak robota za zelenými dveřmi ovládat?'
    [
        'Možná se ti to podaří, když si seženeš nějaký ovladač. ',
        'Na základně žádný ovladač není, ale prozkoumal jsi dobře své vlastní
            věci? ',
        'Jak dobře jsi zkoumal svůj tablet? Co všechno umí? ',
        'Tvůj tablet umí reagovat na různé elektronické vybavení. ',
        'Zkus tablet na robota, tedy na obrázek robota na obrazovce, namířit. ',
        'Jdi do velínu a zadej NAMIŘ TABLET NA ROBOTA. '
    ]
    openWhenRevealed = 'hint-seen-room'
    closeWhenAchieved = robot.scoreMarker
;

++ Goal 'Jakým způsobem mi může robot dveře otevřít?'
    [
        'Prohlédl sis místnost na záběru kamery důkladně? ',
        'Zaměřil jsi svou pozornost na zelené dveře z druhé strany? ',
        'Místo kliky mají velké široké madlo. ',
        'Úplně postačí, když robot do madla vrazí, tím se dveře otevřou. '
    ]
    openWhenRevealed = 'hint-seen-room'
    closeWhenRevealed = 'robot-solved'
;

++ Goal 'Jak se robot programuje, aby se začal pohybovat?'
    [
        'Naprogramuj ho a stiskni tlačítko start. ',
        'Postupně přidávej instrukce do programu, např. příkazem ZADEJ KROK DO
            PROGRAMU. ',
        'Až budeš mít program hotový zadej STISKNI START. Pokus se spleteš,
            zadej STISKNI CHYBA nebo rovnou STISKNI SMAZAT. '
    ]
    openWhenAchieved = robot.scoreMarker
    closeWhenRevealed = 'robot-solved'
    closeWhenTrue = appRobot.outOfMemory > 0
;

++ Goal 'Jakým příkazům robot rozumí?'
    [
        'Prozkoumal jsi ovládací panel robota důkladně? ',
        'Prozkoumej instrukce na ovládacím panelu. '
    ]
    openWhenAchieved = robot.scoreMarker
    closeWhenRevealed = 'robot-solved'
;

++ Goal 'Robota už umím řídit, ale nestačí mi jeho paměť!'
    [
        'Tak to budeš muset být lepší programátor! ',
        'Robot zvládne jen osm instrukcí. Napiš si celý program, který mu chceš
            zadat. Kolik má instrukcí? ',
        'Vidíš ve svém programu nějaké opakující se vzory? ',
        'Co opakující se příkazy nahradit jedním vzorem obaleným v instrukci
            <q>opakuj</q>? '
    ]
    openWhenTrue = appRobot.outOfMemory > 0
    closeWhenRevealed = 'robot-solved'
;

++ Goal 'Jak přiměji robota, aby se stále nevracel na svůj nabíjecí dok?'
    [
        'Nijak, budeš muset naprogramovat lepší program, aby robot celou akci
            zvládl na jeden zátah. '
    ]
    openWhenRevealed = 'hint-program-run'
    closeWhenRevealed = 'robot-solved'
;

++ Goal 'Jak funguje příkaz <q>opakuj</q>?'
    [
        'Zadáš příkaz např. OPAKUJ 5 KRÁT, potom uvedeš jeden či více příkazů,
            které chceš opakovat, a potom dáš příkaz KONEC OPAKOVÁNÍ. '
    ]
    openWhenRevealed = 'hint-program-run'
    closeWhenRevealed = 'robot-solved'
;

++ Goal 'Jak robota otočím doprava?'
    [
        'Robot se umí otáčet jen doleva. Přesto můžeš dosáhnout stavu, kdy bude
            natočený do směru, který chceš. ',
        'Musíš robota nechat otočit třikrát doleva, a pak bude v žádaném
            směru. '
    ]
    openWhenRevealed = 'hint-program-run'
    closeWhenRevealed = 'robot-solved'
;

++ Goal 'Vzdávám to, pořád mi to s tím robotem nejde.'
    [
        'Zadej postupně příkazy OPAKUJ 3 KRÁT, KROK, KROK, VLEVO VBOK, KONEC
            OPAKOVÁNÍ, VLEVO VBOK, VLEVO VBOK, KROK a spusť program. '
    ]
    openWhenRevealed = 'hint-repeat'
    closeWhenRevealed = 'robot-solved'
;

/* ------------------------------------------------------------------------ */
/*
 *   NÁVRAT KAPITÁNA S VELITELEM
 */
+ HintMenu 'Návrat kapitána s velitelem';

++ Goal 'Už jsem všechny tři šifry vyřešil, co teď?'
    [
        'Aby hra pokročila, musíš prozkoumat všechny věci v trezoru, všechny
            zprávy v počítači a zjistit ve vozítku, kam kapitán s velitelem
            odjeli. '
    ]
    openWhenTrue = gRevealed('robot-solved') && gRevealed('tresor-solved')
        && gRevealed('computer-solved')
    closeWhenTrue = gRevealed('robot-solved2') && gRevealed('tresor-solved2')
        && gRevealed('computer-solved2')
;

++ Goal 'Co mám dělat při setkání s kapitánem a velitelem?'
    [
        'Zvou tě na oběd, tak zajdi do jídelny a dej si! ',
        'Přivezli ti náhradní součástky, tak si popovídej a dej se do práce. ',
        'Oběd sníš příkazem SNĚZ JÍDLO. '
    ]
    openWhenRevealed = 'lunch'
    closeWhenTrue = technician.isIn(techniciansRoom)
;

++ Goal 'Pořád mi vrtají hlavou některé události.'
    [
        'A kde bys mohl zjistit více? Kam tě to láká? ',
        'Ke komu se stále upíná tvé podezření? ',
        'Co se vydat v něčích šlépějích? ',
        'Nenapadlo tě podívat se do zakázané oblasti, odkud se vrátlili kapitán
            s velitelem? ',
        'Jak se tam dostali kapitán s velitelem? ',
        'Ukradni vozítko!<<gReveal('want-drive')>> '
    ]
    openWhenRevealed = 'lunch'
    closeWhenRevealed = 'rover-driving'
;

++ Goal 'Jak se dá řídit vozítko?'
    [
        'Snadno, stačí pohnout řídicí pákou. ',
        'Ovšem nejprve musíš do slotu zasunout identifikační kartu, která tě
            opravňuje vozítko řídit. '
    ]
    openWhenRevealed = 'want-drive'
    closeWhenRevealed = 'rover-driving'
;

++ Goal 'Mohu získat Borisovu identifikační kartu?'
    [
        'Zkus to! A viděl jsi ji někde? ',
        'Boris šel spát a odložil ji na stolek ve své kajutě. Zkus ho
            požádat. ',
        'Zajdi k Borisovi do kajuty a POŽÁDEJ BORISE O KARTU. '
    ]
    openWhenTrue = technician.isIn(techniciansRoom)
    closeWhenRevealed = 'hint-wakeup'
    closeWhenAchieved = card.scoreMarker
;


++ Goal 'Jde světlo na chodbě nějak vypnout, rozbít nebo zastínit?'
    [
        'Kdepak, svítí pořád. '
    ]
    openWhenRevealed = 'hint-wakeup'
    closeWhenAchieved = supplyGrating.scoreMarker
;

++ Goal 'Lze se k technikovi proplížit, aby si mě nevšiml?'
    [
        'Kdepak, dveřmi to nepůjde, Boris se vždy vzbudí. ',
        'Možná existuje ale jiná cesta, zkus se trochu porozhlédnout po
            okolí. ',
        'Nezaslechl jsi někde něco? ',
        'Nezaslechl jsi Borisovo chrápání ve skladu? ',
        'Pátral jsi, odkud chrápání vychází? ',
        'Všiml sis mřížky vzduchotechniky? ',
        'Kudy a kam vedou rozvody vzduchotechniky? ',
        'Rozvody vedou nad skladem i kajutou technika, zkus se do nich dostat. '
    ]
    openWhenRevealed = 'hint-wakeup'
    closeWhenAchieved = supplyGrating.scoreMarker
;

++ Goal 'Na mřížku vzduchotechniky nedosáhnu!'
    [
        'A kde přesně je mřížka vzdochotechniky v místnosti? ',
        'Není poblíž něco dalšího? ',
        'Všiml sis, že je přímo nad stolem? ',
        'A vzpomínáš si na rozcvičku? ',
        'Na stůl si můžeš stoupnout a pak dosáhneš výš. ',
        'Zadej příkaz STOUPNI SI NA STŮL a pak OTEVŘI MŘÍŽKU. '
    ]
    openWhenRevealed = 'hint-distant'
    closeWhenAchieved = supplyGrating.scoreMarker
;

++ Goal 'Jak vezmu kartu, když jsem v rozvodech nad kajutou technika?'
    [
        'Ruku mřížkou neprostrčíš. Co něco jiného? ',
        'Nějaký nástroj či pomůcku? ',
        'Kde obvykle bývá nářadí? ',
        'Co na pracovním stole? ',
        'Prohledal jsi dobře bordel na stole ve skladu? ',
        'Zadej příkaz PROZKOUMEJ DÍLENSKÉ VYBAVENÍ a VEM PODÁVÁTKO, které
            najdeš. ',
        'V rozvodech pak jednoduše VEM KARTU a nebo DEJ PODÁVÁTKO DO MŘÍŽKY. '
    ]
    openWhenRevealed = 'hint-above-technician'
    closeWhenAchieved = card.scoreMarker
;

/* ------------------------------------------------------------------------ */
/*
 *   NA CESTĚ
 */
+ HintMenu 'Na cestě';

++ Goal 'Mohu se nějak vyhnout odhalení?'
    [
        'Ne, nemůžeš. Časem si tvého odjezdu všimnou. '
    ]
    openWhenRevealed = 'hint-avoid'
    closeWhenRevealed = 'hint-destination'
;

++ Goal 'Mám se vrátit, nebo říci pravdu?'
    [
        'A co ty myslíš? Jakou máš povahu? Rozhodni se sám! '
    ]
    openWhenRevealed = 'hint-destination'
    closeWhenRevealed = 'hint-questions'
;

++ Goal 'Na co se mám velitele zeptat, abych ho přitlačil?'
    [
        'Určitě jsi zkoušel vše, co tě napadá? ',
        'Co nebude moci popřít nebo se vymluvit? ',
        'Co hmatatelného jsi našel a zjistil? ',
        'Třeba něco, co měl velitel důkladně ukryté… ',
        'Něco, co narychlo ukryli přímo tobě před nosem… ',
        'Něco z toho, co jsi našel v trezoru! ',
        'Zadej např. ZEPTEJ SE NA DIAMANTY. '
    ]
    openWhenRevealed = 'hint-questions'
    closeWhenRevealed = 'hint-bribe'
;

++ Goal 'Mám se nechat podplatit?'
    [
        'A nechtěl by ses chvíli rozhodovat sám za sebe? '
    ]
    openWhenRevealed = 'hint-bribe'
    closeWhenRevealed = 'rover-destination'
;

/* ------------------------------------------------------------------------ */
/*
 *   V ZAKÁZANÉ OBLASTI
 */
+ HintMenu 'V zakázané oblasti';

++ Goal 'Co mám dělat?'
    [
        'Cesta dál už nevede a od základny se k tobě blíží kapitán s velitelem
            ve druhém vozítku. ',
        'A jsou mírně rečeno rozladění. Co udělají, až přijedou? ',
        'Asi nechceš, aby se ti stalo to samé, co Chrissovi… ',
        'Takže jak se budeš bránit? Máš něco na svou obranu? ',
        'A pokud ne, nenašel bys něco? ',
        'Prohlédl sis všechno důkladně? ',
        'I své vozítko, ve kterém jsi přijel? ',
        'Nenašel bys něco zvenku na vozítku? ',
        'V držácích nářadí? ',
        'Vezmi si svítilnu a laser, třeba ti pomohou. '
    ]
    openWhenRevealed = 'rover-destination'
    closeWhenTrue = laser.moved
;

++ Goal 'Co to je za neznámou hmotu, jejíž zbytky v tunelu jsou?'
    [
        'Zdá se, že to jsou zbytky nějaké mnohem větší konstrukce, kterou
            rypadlo zničilo. Zbyl jen kus chodby a jediná místnost. '
    ]
    openWhenRevealed = 'rover-destination'
    closeWhenRevealed = 'machine-working'
;

++ Goal 'Jak se obsluhuje laser?'
    [
        'Jednoduše, namíříš a stiskneš tlačítko. ',
        'Zadej příkaz NAMIŘ LASER NA <i>NĚCO</i> a pak STISKNI TLAČÍTKO. '
    ]
    openWhenTrue = laser.moved
;

++ Goal 'Kde seženu nějaký nabitý akumulátor?'
    [
        'Prozkoumal jsi všechno, co jsi našel? ',
        'Všiml sis svítilny? ',
        'Svítilna má v sobě jeden nabitý akumulátor. ',
        'Zadej VYNDEJ AKUMULÁTOR ZE SVÍTILNY. '
    ]
    openWhenRevealed = 'hint-charged'
    closeWhenTrue = charged1.moved
    closeWhenDescribed = charged1
;
    
++ Goal 'Kde seženu druhý nabitý akumulátor?'
    [
        'Viděl jsi někde nabíječku? ',
        'Ne? Tak si budeš muset poradit jinak. Beztak by nabíjení v nabíječce
            trvalo dlouho. ',
        'Neviděl jsi někde něco neobvyklého, co by stálo za důkladnější
            prozkoumání? ',
        'Místnost, kterou jsi v tunelu objevil, by neměla uniknout tvé
            pozornosti. ',
        'Měl by ses důkladně zajímat o ten nezvyklý stroj, který v místnosti
            je. '
    ]
    openWhenTrue = charged1.moved
    openWhenDescribed = charged1
    closeWhenRevealed = 'machine-working'
;

++ Goal 'Co je to za stroj? Co umí?'
    [
        'A když sem jel kapitán s velitelem, co to vlastně kutili? ',
        'Nebo nenašel bys tady nějakou stopu? ',
        'Třeba vypadnutý papír z poznámek? '
    ]
    openWhenDescribed = machine
    closeWhenDescribed = sheet
    closeWhenRevealed = 'machine-working'
;

++ Goal 'Já těm poznámkám nerozumím, co stroj doopravdy umí?'
    [
        'Zdá se, že to je replikátor -- stroj, který dokáže vyrobit kopii
            předmětu, když mu dodáš vhodný materiál. ',
        'Velitel ho používal ke kopírování diamantů a dodával uhlík ve formě
            tuhy. '
    ]
    openWhenDescribed = sheet
    closeWhenRevealed = 'machine-working'
;
    
++ Goal 'Jak stroj spustím, aby něco udělal?'
    [
        'Prohlédl sis ho důkladně? Čím by se mohl spouštět? ',
        'Zkoušel ses dotknout prohlubně? ',
        'Zadej příkaz STISKNI PROHLUBEŇ. '
    ]
    openWhenDescribed = machine
    closeWhenRevealed = 'hint-push'
;
    
++ Goal 'Proč stroj stále odmítá pracovat?'
    [
        'Aby stroj správně pracoval, budeš mu muset dát něco do přihrádek. ',
        'Co stroj dělá a co tedy v přihrádkách očekává? '
    ]
    openWhenRevealed = 'hint-push'
    closeWhenRevealed = 'machine-working'
;
    
++ Goal 'Jaký je rozdíl mezi levou a pravou přihrádkou?'
    [
        'Do jedné se dává předloha a do druhé materiál. ',
        'Materiál se vkládá tam, kde najdeš zbytky nevyužitého materiálu. ',
        'Tedy do pravé. '
    ]
    openWhenDescribed = machine
    closeWhenRevealed = 'machine-working'
;

++ Goal 'Proč se mi v mysli objevují početní úlohy?'
    [
        'Kdo ví? Je to dost tajemný stroj nezámého původu. Tvůrce se asi bohužel
            nezeptáme. ',
        'Třeba je to nějaká CAPTCHA? Tak ji vyřeš! ',
        'CAPTCHA jsou taková ta pokroucená písmenka, co často opisuješ na
            různých webových stránkách. ',
        'CAPTCHA má za úkol ověřit, že je na druhé straně inteligentní bytost a
            ne spammerský robot. '
    ]
    openWhenRevealed = 'machine-working'
    closeWhenRevealed = 'replicated'
;

++ Goal 'Jak stroji odpovím na položený příklad?'
    [
        'Úplně postačí napsat jen samotné číslo odpovědi. Můžeš také např.
            napsat MYSLI NA 123. '
    ]
    openWhenRevealed = 'machine-working'
    closeWhenRevealed = 'replicated'
;

++ Goal 'Proč mi občas říká něco o nesrozumitelných symbolech?'
    [
        'A v jaké situaci to říká? Dokážeš to přesně určit? ',
        'Klidně se na chvíli oprosti od zadaného příkladu a systematicky
            vyzkoušej, kdy ti to stroj řekne. ',
        'Stroj to říká, jen když zadáváš v odpovědi něco velmi specifického. ',
        'Říká to jen o některých číslicích. ',
        'Stroji se nelíbí, když se v odpovědi vystytuje číslice 8 nebo 9. '
    ]
    openWhenRevealed = 'hint-symbols'
    closeWhenRevealed = 'replicated'
;
    
++ Goal 'Jak to, že stroj nebere žádnou mou odpověď? Jsem si jistý, že počítám
        dobře!'
    [
        'Opravdu? Určitě neděláš nějakou chybu? ',
        'Možná ses jen nedokázal plně vžít do myšlení stroje. ',
        'Nebo spíše do myšlení jeho tvůrce? ',
        'Kdo ho sem mohl dát? Nezdá se ti, že se vymyká všemu, co znáš? ',
        'Jak asi vypadal jeho tvůrce? Nezanechal po sobě nějaký otisk, nějakou
            stopu? ',
        'Prohlédnul sis důkladně prohlubeň, které ses dotkl? ',
        'To ale vůbec nevypadá na lidský stroj! ',
        'Ať už to byla jakákoliv civilizace, zřejmě musela také objevit
            matematiku podobně, jako lidé. ',
        'Ale přesto nemusí být ta matematika úplně stejná, může se lišit v
            praktických detailech. ',
        'Proč si vlastně myslíš, že pět a pět je deset? ',
        'Jak ses vlastně ty učil počítat v první třídě? ',
        'Na prstech? Třeba se tak učil počítat i tvůrce stroje! ',
        'Ovšem jeho ruka vypadala trochu jinak, než tvoje. Jak by to ovlivnilo
            matematiku, kterou znáš? ',
        'Příklady se náhodně mění, ale všiml sis něčeho, co v nich nikdy
            není? ',
        'V příkladech se nikdy nevyskytují číslice 8 a 9. ',
        'To nebude jen náhoda! ',
        'Že lidé počítají v desítkové soustavě je opravdu jen tím, že mají deset
            prstů, desítková soustava jinak není zas až tak super. ',
        'Čtyřprstý mimozemšťaň, který má dvě ruce, by počítal spíš v osmičkové
            soustavě. ',
        'Takže hned po sedmičce následuje nula a přičte se přenos do dalšího
            řádu. ',
        'Pokud ti to stále nejde, tak sáhni po nějaké kalkulačce, ta v počítači
            se dá obvykle přepnout, aby uměla osmičkovou soustavu. '
    ]
    openWhenRevealed = 'machine-working'
    closeWhenRevealed = 'replicated'
;
