#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   Preparser, který zajistí, že když hráč zadá VIZ 54 s mezerou, tak se
 *   převede na jedno slovo, aby parser objekt poznal. Podobně další objekty,
 *   které mají v označení číslo.
 */
viz54PreParser: StringPreParser
    doParsing(str, which)
    {
        return str.findReplace('viz 54', 'viz54', ReplaceAll
            | ReplaceIgnoreCase);
    }
;

av5381PreParser: StringPreParser
    doParsing(str, which)
    {
        return str.findReplace('AV 53-81', 'AV53-81', ReplaceAll
            | ReplaceIgnoreCase);
    }
;

zworykPreParser: StringPreParser
    doParsing(str, which)
    {
        return str.findReplace('zworyk 42', 'zworyk-42', ReplaceAll
            | ReplaceIgnoreCase);
    }
;

ruskPreParser: StringPreParser
    doParsing(str, which)
    {
        return str.findReplace('rusk 31', 'rusk-31', ReplaceAll
            | ReplaceIgnoreCase);
    }
;

aplPreParser: StringPreParser
    doParsing(str, which)
    {
        return str.findReplace('APL 2', 'APL-2', ReplaceAll
            | ReplaceIgnoreCase);
    }
;

/* ------------------------------------------------------------------------ */
/*
 *   V tipech ke hře ukazujeme příkazy zapsané velkými písmeny, aby se odlišily
 *   od okolního textu. Začínající hráč by si mohl myslet, že i on musí psát
 *   velkými písmeny a tak takový pokus zachytíme a okomentujeme v dalším tipu.
 */
upperCaseDetectionPreParser: StringPreParser
    doParsing(str, which)
    {
        if(rexMatch(upperCasePat, str) != nil)
            gReveal('hint-lowercase');

        return str;
    }

    upperCasePat = static new RexPattern('^<Upper|Digit|Space>{10,}$')
;

/* ------------------------------------------------------------------------ */
/*
 *   Při zadávání tlačítek na panelu může hráč zadat více číslic oddělených
 *   mezerou. To by parser ale bral jako přídavná jména před podstatným, a tak
 *   oddělíme čárkou, aby bylo jasné, že tím hráč má na mysli seznam více
 *   objektů.
 */
spaceSeparatedDigitsPreParser: StringPreParser
    doParsing(str, which)
    {
        return rexReplace(pat, str, '%1, %2', ReplaceIgnoreCase);
    }

    pat = static new RexPattern('(%<[0-9r])<Space>+(?=[0-9r]%>)')
;

/* ------------------------------------------------------------------------ */
/*
 *   Ve frázi zadej, která nepracuje s objekty, ale s doslovným řetězcem, by
 *   čárka způsobila oddělení příkazu, takže vše za čárkou by se považovalo za
 *   další příkaz. Proto v takovém případě čárku zrušíme.
 */
commaInLiteralPreParser: StringPreParser
    doParsing(str, which)
    {
        if(rexMatch(pat, str) != nil)
            str = str.findReplace(',', ' ');

        return str;
    }

    pat = static new RexPattern('<NoCase>^zadej');
;

/* ------------------------------------------------------------------------ */
/*
 *   Sousloví "jejich vozítko" přepíšeme na "pronásledovatele".
 */
theirRoverPreParser: StringPreParser
    doParsing(str, which)
    {
        str = str.findReplace('jejich vozítko', 'pronásledovatele');
        str = str.findReplace('jejich vozitko', 'pronásledovatele');

        return str;
    }
;

/* ------------------------------------------------------------------------ */
/*
 *   Poslouchej něco něčím je neprepoziční fráze a tak si ji ohlídáme, aby
 *   nebyla pochopena obráceně. Proč jsem to řešil PreParserem a ne pomocí
 *   preferredIobj? Podobně podávátko.
 */
sthetoscopePreParser: StringPreParser
    doParsing(str, which)
    {
        if(rexMatch(pat1, str) != nil)
            str = 'nasaď si stetoskop';
        if(rexMatch(pat2, str) != nil || rexMatch(pat3, str) != nil)
            str = 'přilož stetoskop k trezoru';
        if(rexMatch(pat4, str) != nil && me.isIn(commandersRoom)
            && stethoscope.isIn(me))
            str = 'přilož stetoskop k trezoru';

        return str;
    }

    pat1 = static new RexPattern(
        '<NoCase>^(dej|nasaď) +(si +|)stetoskop +do +u[šs][íi]')
    pat2 = static new RexPattern('<NoCase>^(poslouchej|poslouchat|poslechni|poslechnout) +stetoskopem +trezor')
    pat3 = static new RexPattern('<NoCase>^(poslouchej|poslouchat|poslechni|poslechnout) +trezor +stetoskopem')
    pat4 = static new RexPattern('<NoCase>^(poslouchej|poslouchat|poslechni|poslechnout) +stetoskopem')
;

StringPreParser
    doParsing(str, which)
    {
        if(rexMatch(pat1, str) != nil || rexMatch(pat2, str) != nil
            || rexMatch(pat3, str) != nil) str = 'vem kartu';

        return str;
    }

    pat1 = static new RexPattern(
        '<NoCase>^(vem|vz[íi]t|podej|podat) +(si +)?kartu +pod[áa]v[áa]tkem')
    pat2 = static new RexPattern(
        '<NoCase>^(vem|vz[íi]t|podej|podat) +(si +)?pod[áa]v[áa]tkem +kartu')
    pat3 = static new RexPattern(
        '<NoCase>^(podej|podat) +(si +)?kartu')
;

/* ------------------------------------------------------------------------ */
/*
 *   Fráze "zaměřit vozítko" neobsahuje předložku "na" a přesto znamená, že
 *   vozítko je cílem zamíření a ne objektem, kterým se míří, jako ve frázi
 *   "zamiř laser".
 */
aimPreParser: StringPreParser
    doParsing(str, which)
    {
        if(rexMatch(pat1, str) != nil)
            str = 'zamiř na vozítko';

        return str;
    }

    pat1 = static new RexPattern('<NoCase>^(zami[řr]|zam[íiěe][řr]it) voz[íi]tko')
;
