#charset "utf-8"

#include <adv3.h>
#include <cs_cz.h>

/*
 *   Česká definice pro rozšíření Tads-3 Spelling Corrector, 1.1 od Steva
 *   Breslina a Andrease Seweho, který lze získat na adrese:
 *
 *     http://ifarchive.org/if-archive/programming/tads3/library/contributions/
 *     SpellingCorrector.t
 *
 *   Použití: Jen zařadit do projektu ke kompilaci. Nejprve SpellingCorrector.t
 *   a potom tento soubor.
 */

modify SpellingCorrector
    alphabet = 'abcdefghijklmnopqrstuvwxyzříšžťčýůňúěďáéó'
    
    disableMessage = '\n(Automatickou korekci překlepů můžete vypnout zadáním
		      příkazu PŘEKLEPY.)<.p>'
;

modify ToggleSpellingCorrectionAction
    execAction() {
        local enabled = SpellingCorrector.correctionEnabled;
        mainReport('Kontrola překlepů ' +
        (enabled ? 'vypnuta':'zapnuta') +'.');
        SpellingCorrector.correctionEnabled = !enabled;
    }
;

modify DisableSpellingCorrectionAction
    execAction() {
        mainReport('Kontrola překlepů vypnuta.');
        SpellingCorrector.correctionEnabled = nil;
    }
;

modify EnableSpellingCorrectionAction
    execAction() {
        mainReport('Kontrola překlepů zapnuta.');
        SpellingCorrector.correctionEnabled = true;
    }
;

replace VerbRule(DisableSpellingCorrection) ('vypni' | 'vypnout')
    ('překlepy' | ('opravu' | 'kontrolu' | 'korekci' | 'korekturu')
    ('překlepů' | )):
    DisableSpellingCorrectionAction
;

replace VerbRule(EnableSpellingCorrection) ('zapni' | 'zapnout')
    ('překlepy' | ('opravu' | 'kontrolu' | 'korekci' | 'korekturu')
    ('překlepů' | )):
    EnableSpellingCorrectionAction
;

replace VerbRule(ToggleSpellingCorrection) ('přepni' | 'přepnout' | )
    ('překlepy' | ('opravu' | 'oprava' | 'kontrolu' | 'kontrola' | 'korekci'
    | 'korekturu' | 'korektura') ('překlepů' | )):
    ToggleSpellingCorrectionAction
;
