#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

commandersRoom: BaseRoom 'Kajuta velitele' 'do kajuty velitele'
    "Kajuta velitele se velikostí téměř neliší od ostatních, postel u jedné
        stěny je připoutána k podlaze. Výklopný pracovní stolek i přihrádky
        okolo něj naproti posteli jsou zaplněné nejrůznějšími předměty.
        Nejvýraznější odlišností je trezor zabudovaný ve stěně přímo naproti
        vstupu. "

    south = commandersDoorInside
    out asExit(south)

    /* Tato metoda se spouští každý tah, dokud je hráč v místnosti. */
    roomDaemon()
    {
        /* Hráč splní cíl, jakmile si přečte *všechny* důležité informace. */
        if(tresorBills.described && tresorLetter.described
            && tresorPapers.described && tresorDiamonds.described)
        {
            gReveal('tresor-solved2');
            scoreMarker.awardPointsOnce();
        }

        inherited;
    }
    scoreMarker: Achievement { +2 "přečtení důležitých informací v trezoru" }

    gender = 3
    vocabWords = '(velitelovu) kajuta kajuty kajutě kajutu kajutou (velitele) -'
    gcName = 'kajuty velitele, kajutě velitele, kajutu velitele, kajutě
        velitele, kajutou velitele'
;

+ commandersDoorInside: Lockable, Door -> commandersDoor 'dveře' 'dveře' *3
    "Každá kajuta je uzavřena lehkými vzduchotěsnými a zvukotěsnými dveřmi. Měly
        by vydržet mírné výkyvy tlaku na základně. Zevnitř se dají zajistit
        proti otevření, ale astronauti je obvykle nezamykají. "

    /* Dveře jsou pomnožné, tj. mají vždy tvar množného čísla. */
    isPlural = true

    /* Lockable normálně začíná v zamčeném stavu, to nechceme. */
    initiallyLocked = nil

    /* Notifikace o odchodu. */
    noteTraversal(traveler)
    {
        /* Nenecháme hráče si předměty odnést, aby nevzbuzoval podezření. */
        if(!tresorBills.isIn(tresor) || !tresorLetter.isIn(tresor)
                || !tresorPapers.isIn(tresor) || !tresorDiamonds.isIn(tresor))
        {
            "Protože jsi nechtěl být obviněn z krádeže, tak jsi nejprve vrátil
                věci do trezoru a ten zase zavřel. ";

            tresorBills.moveInto(tresor.subContainer);
            tresorLetter.moveInto(tresor.subContainer);
            tresorPapers.moveInto(tresor.subContainer);
            tresorDiamonds.moveInto(tresor.subContainer);

            tresor.makeOpen(nil);
            tresorKnob.currentCombo = '';
        }

        inherited(traveler);
    }

    gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
    gcVocab = 'dveří/dveřím/dveřích/dveřmi'
;

/* ------------------------------------------------------------------------ */

+ Bed, Fixture 'lůžko/postel' 'lůžko' *4
    "Lůžko se podobá závěsným spacákům, jako bývají na kosmických lodích, ale je
        umístěno vodorovně a má navíc tenkou matraci. V zavěšeném spacím pytli
        by spáč přeci jen pomalu klesal k podlaze. "

    dobjFor(Enter) asDobjFor(LieOn)
    
    changeGender = 'post:3'
    gcName = 'lůžka, lůžku, lůžko, lůžku, lůžkem'
    gcVocab = 'lůžka/lůžku/lůžkem/postele/posteli/postelí'
;

++ Decoration 'tenká matrace' 'matrace' *3
    "Připomíná spíš tlustší deku. Ve zdejší nepatrné gravitaci není potřeba
        skoro nic, gravitace nestačí k tomu, aby se spáč otlačil. Matrace spíš
        jen tlumí prudší pohyby spáče, aby se ve spánku neotloukl. "

    gcName = 'matrace, matraci, matraci, matraci, matrací'
    gcVocab = 'tenké tenkou matraci/matrací'
;

+ Decoration 'přihrádky' 'přihrádky' *3
    "Jsou nacpané drobnostmi, ve kterých se ti nechce přehrabovat. "

    isPlural = true
    gcName = 'přihrádek, přihrádkám, přihrádky, přihrádkách, přihrádkami'
    gcVocab = 'přihrádek/přihrádkám/přihrádkách/přihrádkami'
;

++ Decoration 'různé předměty/drobnosti' 'různé předměty' *2
    "Různé osobní a pracovní drobnosti. Nic zajímavého mezi nimi není. "

    isPlural = true
    gcName = 'různých předmětů, různým předmětům, různé předměty,
        různých předmětech, různými předměty'
    gcVocab = 'různých různým různými předmětů/předmětům/předmětech'
;

/* ------------------------------------------------------------------------ */
/*
 *   Komplexní kontejner je takový předmět, který funguje jako více než jeden
 *   druh kontejneru. ComplexContainer je takový dispečer, který předává
 *   požadavky na patřičný podkontejner, v tomto případě máme subSurface pro
 *   plochu na stole a subUnderside pro věci pod stolem.
 */
+ desk: ComplexContainer, Fixture 'výklopný pracovní stolek/stůl' 'stolek' *2
    "Podobá se výbavě kosmických lodí, lehká pevná deska jednou stranou
        připevněná ke stěně kajuty, se suchými zipy a gumovými úchyty, aby se
        předměty nerozlétaly po okolí. "

    subSurface: ComplexComponent, Platform
    {
        maxSingleBulk = 10000
        objOutOfPrep = 'ze'

        /*
         *   This is one additional step we need to take to ensure that an
         *   actor can actually stand on the desk.
         *
         *   By default the stagingLocations property for a NestedRoom is
         *   [location], but the location of a ComplexComponent is
         *   considered to be the ComplexContainer of which it's a part, and
         *   a ComplexContainer can't (directly) hold an actor. We therefor
         *   need to change the stagingLocation to the ComplexContainer's
         *   location (the staging location is the place at actor needs to
         *   be in order to be able to enter a particular NestedRoom).
         */
        stagingLocations = [lexicalParent.location]
    }
    subUnderside: ComplexComponent, Underside { maxSingleBulk = 10000 }

    /*
     *   The other job that needs doing is remapping all the appropriate
     *   actions to the subSurface.
     */
    dobjFor(StandOn) remapTo(StandOn, subSurface)
    dobjFor(SitOn) remapTo(SitOn, subSurface)
    dobjFor(LieOn) remapTo(LieOn, subSurface)
    dobjFor(Board) remapTo(StandOn, subSurface)
    dobjFor(GetOffOf) remapTo(GetOffOf, subSurface)

    gcName = 'stolku, stolku, stolek, stolku, stolkem'
    gcVocab = 'výklopného výklopnému výklopném výklopným pracovního pracovnímu
        pracovním stolku/stolkem/stolu/stole/stolem'
;

/*
 *   Odpadkový pytel je jeden z mnoha objektů, které zviditelníme až po odjezdu
 *   kapitána a velitele na inspekci. Všechny tyto PresetLater objekty jsou
 *   označeny společným klíčem 'coffee'. StretchyContainer mění svou velikost
 *   podle věcí uvnitř.
 */
++ trash: PresentLater, StretchyContainer, OpenableContainer
    'odpadkový pytel/koš/odpadky' 'odpadkový pytel' *2
    "Odpadkový pytel je nevelký tuhý průhledný plastikový pytel se zipem
        sloužící k odkládání suchého netříditelného odpadu zachycený ke kraji
        stolku. Nyní je téměř prázdný.<<splinters.discover>> "

    /* Pytel je pod stolem, tedy v subkontejneru. */
    subLocation = &subUnderside

    material = glass
    initiallyOpen = true
    plKey = 'coffee'

    iobjFor(PutIn)
    {
        verify()
        {
            /*
             *   Kontejnery maji standardne logicky rank 70 resp. 60, pokud
             *   nejsou drzeny hracem. To pak ma ale za nasledek, ze prikaz
             *   "vloz kartu" ji vlozi radeji do neseneho odpadkoveho pytle,
             *   nez do slotu. Proto rank pytle snizime, po objeveni trisek
             *   je zbytecny.
             */
            logicalRank(50, '');
            inherited;
        }
    }

    changeGender = '!pyt:5'
    gcName = 'odpadkového pytle, odpadkovému pytli, odpadkový pytel,
        odpadkovém pytli, odpadkovým pytlem'
    gcVocab = 'odpadkového odpadkovému odpadkovém odpadkovým pytle/pytli/pytlem/
        koše/koši/košem/odpadků/odpadkům/odpadcích/odpadky'
;

+++ splinters: Hidden 'dřevěné třísky' 'dřevěné třísky' *3
    "Třísky jsou na první pohled zbytky rozštípaných tužek, na mnoha místech na
        nich zbývá povrchová barva i s kousky nápisů. Tuhu někdo pečlivě
        odstranil. "

    dobjFor(LookIn) asDobjFor(Examine)
    dobjFor(Search) asDobjFor(Examine)

    isPlural = true
    gcName = 'dřevěných třísek, dřevěným třískám, dřevěné třísky,
        dřevěných třískách, dřevěnými třískami'
    gcVocab = 'dřevěných dřevěným dřevěnými třísek/třískám/třískách/třískami'
;

++++ Component 'nápisy' 'nápisy' *2
    "Z kousků nápisů se ti po chvíli snažení povedlo rozluštit reklamní slogan
        výrobce: <q>Nejlepší grafitové tužky pro každého vesmířana.</q> "
        
    isPlural = true
    gcName = 'nápisů, nápisům, nápisy, nápisech, nápisy'
    gcVocab = 'nápisů/nápisům/nápisech'
;

++ figure: PresentLater, Thing
    'plastová plastové figurka/figurky' 'plastové figurky' *3
    "Jsou to klasické plastové figurky akčního superhrdiny, polohovatelné
        ručičky, nožičky, otočná hlavička s přilbou… a ta podoba, ten divný
        skafandr, co se už dávno nepoužívá, no to přeci nemůže být nikdo jiný
        než Ivan Bella. Že by byl velitel takový fanda do sběratelských figurek
        dávných kosmonautů?

        <.p>Zvláštní je, jak jsou si obě figurky podobné, dokonce i škrábance a
        odřenou barvu mají přesně na stejných místech. "

    plKey = 'coffee'
    subLocation = &subSurface

    isPlural = true
    gcName = 'figurek, figurkám, figurky, figurkách, figurkami'
    gcVocab = 'plastovou plastových plastovým plastovými figurce/figurku/
        figurkou/figurek/figurkám/figurkách/figurkami'
;

+++ Component 'odřená barva' 'odřená barva' *3
    "Figurky jsou natřené různými barvami, aby vypadaly realističtěji. "

    gcName = 'odřené barvy, odřené barvě, odřenou barvu, odřené barvě,
        odřenou barvou'
    gcVocab = 'odřené odřenou barvy/barvě/barvu/barvou'
;

+++ Component 'škrábance' 'škrábance' *2
    "Nezdá se, že by vznikly náhodou. O to divnější je, že se na obou figurkách
        opravdu shodují. "

    isPlural = true
    gcName = 'škrábanců, škrábancům, škrábance, škrábancích, škrábanci'
    gcVocab = 'škrábanců/škrábancům/škrábancích/škrábanci'
;

+++ Component 'ručičky/nožičky/končetiny' 'končetiny figurky' *3
    "Tak jako u jiných plastových figurek se dají ručičky a nožičky polohovat
        otáčním. "

    dobjFor(Turn)
    {
        verify() { }
        action()
        {
            "Zkusil jsi o kousek pohnout končetinami figurky a za zvuku efektů
                <q>per huba</q> jsi zkusil figurkou pochodovat po stole…
                <q>Vžůůům, hurá na Měsíc,</q> mávl jsi figurkou v ruce v širokém
                oblouku. ";
        }
    }
    dobjFor(Move) asDobjFor(Turn)
    dobjFor(Push) asDobjFor(Turn)
    dobjFor(Pull) asDobjFor(Turn)

    isPlural = true
    gcName = 'končetin figurky, končetinám figurky, končetiny figurky,
        končetinách figurky, končetinám figurky'
    gcVocab = 'ručiček/ručičkám/ručičkách/ručičkami/nožiček/nožičkám/nožičkách/
        nožičkami/končetin/končetinám/končetinách'
;

+++ Component 'hlavička' 'hlavička figurky' *3
    "Vypadá lidsky asi tak, jak může vypadat hlava plastové figurky. "

    gcName = 'hlavičky figurky, hlavičce figurky, hlavičku figurky,
        hlavičce figurky, hlavičkou figurky'
    gcVocab = 'hlavičky/hlavičce/hlavičku/hlavičkou'
;

/* ------------------------------------------------------------------------ */
/*
 *   Trezor je také komplexní kontejner, protože kromě věcí obsažených uvnitř
 *   má i komponenty zvenku (dvířka, číselník, kliku). Prostor uvnitř je tedy
 *   subContainer a detaily zvenku jsou umístěny do trezoru běžnou kontejnerovou
 *   hierarchií.
 */
+ tresor: Attachable, ComplexContainer, Fixture
    'trezor' 'trezor' *2
    "<<if subContainer.isOpen>>Trezor je ukrytý ve stěně kajuty. Dvířka s
        číselným zámkem jsou otevřená. Prostor uvnitř není příliš veliký, trezor
        je očividně určený k uchovávání malých věcí, třeba nejrůznějších
        dokumentů.
        <<else>>Trezor je ukrytý ve stěně kajuty, jsou z něj vidět jen dvířka s
        otočným číselníkem a otevírací klikou. Navzdory tomu, že je lehké
        konstrukce, pravděpodobně z tvrdé a lehké slitiny titanu, vypadá velmi
        odolně. "

    subContainer: ComplexComponent, LockableContainer
    {
        maxSingleBulk = 10000

        /* Pokud není zadán správný kód, je trezor zamčený. */
        isLocked() { return !isOpen && tresorKnob.currentCombo !=
            tresorKnob.correctCombo; }

        /* Jakmile ho hráč jednou odemkne, už ho pak odemykáme automaticky. */
        autoUnlockOnOpen = usedCombo
        lockStatusObvious = nil
        usedCombo = nil

        /*
         *   Tato metoda popíše zvuky ozývající se ze zámku. Zámek trezoru hraje
         *   hru bulls and cows známou v lehce odlišné variantě jako "logik".
         */
        wrongCombo()
        {
            local len = tresorKnob.correctCombo.length;

            /* Počet přesných shod a shod na nesprávných pozicích */
            local bulls = 0, cows = 0;

            /*
             *   V těchto vektorech budeme monitorovat, co už jsme
             *   přiřadili, abychom to nezapočítávali vícekrát. Vektory
             *   inicializujeme na správnou délku a celou délku necháme
             *   inicializovat na nil.
             */
            local usedCurrent = new Vector(len, len);
            local usedCorrect = new Vector(len, len);

            /* Nejprve spočítáme shody čísel i pozic */
            for(local i = 1; i <= len; i++)
            {
                if(tresorKnob.currentCombo.substr(i, 1) ==
                    tresorKnob.correctCombo.substr(i, 1))
                {
                    bulls++;
                    usedCurrent[i] = true;
                    usedCorrect[i] = true;
                }
            }

            /* Teď hledáme zbylé shody na neshodných pozicích */
            for(local i = 1; i <= len; i++)
            {
                if(usedCurrent[i]) continue;
                for(local j = 1; j <= len; j++)
                {
                    if(usedCorrect[j]) continue;
                    if(tresorKnob.currentCombo.substr(i, 1) ==
                        tresorKnob.correctCombo.substr(j, 1))
                    {
                        cows++;
                        usedCorrect[j] = true;
                        break;
                    }
                }
            }

            "Zkusil jsi vzít za kliku a otevřít dveře trezoru, ale ";

            if(bulls == 0 && cows == 0) "nic se nestalo a dveře
                zůstaly pevně zamčené. ";
            else
            {
                if(stethoscope.isWornBy(me) && stethoscope.isAttachedTo(tresor))
                {
                    "z mechanismu zámku se ozvalo se jen tlumené <q>";

                    local n = 0;
                    while(bulls--) "<<n++ ? ', ' : ''>>klik";
                    while(cows--) "<<n++ ? ', ' : ''>>klap";

                    "</q> a dveře zůstaly pevně zamčené. ";
                }
                else
                {
                    "z mechanismu zámku se ozvalo jen zvláštní tichounké
                        klapání. Byl bys přísahal, že na tom klapání něco je –
                        jakoby se zvuky každého klapnutí nepatrně lišily, ale
                        zvuk je tak tichý, že si nejsi jistý, co slyšíš. ";
                    gReveal('hint-amplify');

                    /*
                     *   Zmínili jsme klapání, tak kdyby hráč chtěl ho
                     *   prozkoumat, máme zvláštní objekt.
                     */
                    tresorNoise.makePresent();
                }
            }

            gReveal('hint-tried-tresor');

            /*
             *   Po vyzkoušení této kombinace ji vymažeme, aby hráč mohl zkusit
             *   jinou.
             */
            tresorKnob.currentCombo = '';
        }

        dobjFor(Open)
        {
            check()
            {
                if(commander.isIn(commandersRoom))
                    failCheck('Nemůžeš si přeci hrát s trezorem velitele před
                        jeho zraky. To by ses se zlou potázal. ');

                if(isLocked())
                {
                    wrongCombo();
                    exit;
                }
            }
            action()
            {
                inherited();

                if(isOpen)
                {
                    tresorKnob.currentCombo = '';
                    usedCombo = true;

                    stethoscope.detachFrom(tresor);

                    if(!gRevealed('tresor-solved'))
                    {
                        /*
                         *   Inherited výše nejen provedlo otevření dvířek, ale
                         *   i vypsalo "Otevření trezoru odhalilo účtenky,
                         *   listiny, dopis a diamanty." Tím, že použijeme makro
                         *   reportBefore, přidáme toto hlášení před odhalení.
                         */
                        reportBefore('Zkusil jsi vzít za kliku a otevřít dveře
                            trezoru. Z mechanismu zámku se ozvalo tlumené
                            <q>klik, klik, klik, klik, klik, klik</q> a dveře se
                            otevřely. ');

                        gReveal('tresor-solved');
                        scoreMarker.awardPointsOnce();
                    }
                }
            }
        }
        dobjFor(Unlock)
        {
            verify() { logicalRank(50, 'self-locking door'); }
            check()
            {
                if(commander.isIn(commandersRoom))
                    failCheck('Nemůžeš si přeci hrát s trezorem velitele před
                        jeho zraky. To by ses se zlou potázal. ');
                    
                /*
                 *   Pokud hráč trezor už nekdy otevřel, povolíme, ale pokud ne,
                 *   vysvětlíme, že musí manuálně zadat kombinaci na číselníku.
                 */
                if(!usedCombo)
                {
                    "Vypadá to, že budeš muset zadat kombinaci na číselníku. ";
                    exit;
                }
            }
            action()
            {
                /* Když jsme se dostali až sem, kód trezoru už známe. */
                "Otáčením číselníku jsi zadal kombinaci. ";
                tresorKnob.currentCombo = tresorKnob.correctCombo;
            }
        }
        scoreMarker: Achievement { +5 "odemčení trezoru" }
    }

    dobjFor(EnterOn) remapTo(EnterOn, tresorKnob, IndirectObject)
    dobjFor(TypeLiteralOn) remapTo(TypeLiteralOn, tresorKnob, IndirectObject)

    /* Major je ta věc, která je popisovaná, že k ní je ta druhá připevněná. */
    isMajorItemFor(obj) { return true; }
    handleAttach(other)
    {
        if(other.isWornBy(me))
        {
            "Přiložil jsi konec stetoskopu k trezoru nedaleko kódového
               číselníku. ";
        }
        else
        {
            other.makeWornBy(me);
            "Nasadil sis stetoskop do uší a jeho druhý konec přiložil k trezoru
                nedaleko kódového číselníku. ";
        }
        scoreMarker2.awardPointsOnce();
        tresorNoise.moveInto(nil);
    }
    scoreMarker2: Achievement { +3 "zesílení zvuků zámku" }
    majorAttachmentLister = perInstance(new tresorMajorAttachmentLister(self))

    dobjFor(Break)
    {
        verify() { illogical('Nemůžeš rozbít trezor. I na Zemi by bylo snazší
            trezor odemknout. '); }
    }

    soundDesc()
    {
        if(!attachedObjects.length())
            "Přitiskl jsi ucho na dvířka trezoru a zkusil poslouchat cvakání
                uvnitř zámku, ale zvuk je příliš slabý. ";
        else
            "Stetoskop je přiložen k trezoru. Teď jen zkusit něco se zámkem. ";
    }

    gcName = 'trezoru, trezoru, trezor, trezoru, trezorem'
    gcVocab = 'trezoru/trezorem'
;


class tresorMajorAttachmentLister: MajorAttachmentLister
    showListPrefixWide(cnt, pov, parent, selector)
    {
        gMessageParams(parent);
        "<.p>{K/ke parent} <<parent.nameKomuCemu>> <<tSel(selector < 4
            ? 'je' : 'jsou', ['byl', 'byla', 'bylo', 'byli', 'byly',
            'byla'][selector])>> přiložen<<['', 'a', 'o', 'i', 'y', 'a']
            [selector]>> ";
    }
;

++ tresorDoor: ComponentDeferrer, ContainerDoor 'dvířka trezoru/dvířka' 'dvířka trezoru' *3
    "Dvířka trezoru mají vnější tlustou desku chránící mechaniku zámku ukrytou
        pod dalším krytem na vnitřní straně dvířek, ocelové závory jsou zasunuté
        uvnitř. "

    dobjFor(Examine) maybeRemapTo(!location.subContainer.isOpen, Examine,
        location)

    iobjFor(AttachTo) remapTo(AttachTo, DirectObject, tresor)
    
    isPlural = true
    gcName = 'dvířek trezoru, dvířkám trezoru, dvířka trezoru, dvířkách trezoru,
        dvířkama trezoru'
    gcVocab = 'dvířek dvířkám dvířkách dvířkami'
;

+++ Button, Component 'klika' 'klika' *3
    "Po zadání správné sekvence čísel se zmáčknutím kliky dvířka otevřou.
        Nebyla-li kombinace čísel správná, zmáčknutí kliky kombinaci zruší a
        může být zadána znovu. "

    dobjFor(Push) remapTo(Open, tresor)
    dobjFor(Pull) remapTo(Open, tresor)
    dobjFor(Move) remapTo(Open, tresor)
    dobjFor(Switch) remapTo(Open, tresor)
    dobjFor(Flip) remapTo(Open, tresor)

    gcName = 'kliky, klice, kliku, klice, klikou'
    gcVocab = 'kliky/klice/kliku/klikou'
;

+++ tresorKnob: NumberedDial, Component 'číselník/zámek' 'číselník' *2
    "Číselník má po svém obvodu vyražená čísla od 0 do 9 a jeho otáčením se
        postupně zadává číselná kombinace. Teď je kolečko natočené na
        <<curSetting>>. Tyhle typy trezorů mívají šestimístnou číselnou
        kombinaci. "

    mustSpecifyTurnToMsg = 'Mus{[íš]|lel[a] [jsi]} specifikovat polohu, do které
        {ho/ji dobj} {chc[eš]|[jsi] chtěl[a]} {kdoco/postava} natočit, např.
        říci OTOČ ČÍSELNÍK NA 1. '

    minSetting = 0
    maxSetting = 9
    curSetting = '0'

    currentCombo = ''
    correctCombo = '645852'

    sayCurrentCombo()
    {
        for(local i = 1, local len = currentCombo.length(); i <= len; ++i)
        {
            say(currentCombo.substr(i, 1));
            if(i != len) "-";
        }
    }
    dobjFor(SetTo)
    {
        check()
        {
            if(commander.isIn(commandersRoom))
                failCheck('Nemůžeš si přeci hrát s trezorem velitele před
                    jeho zraky. To by ses se zlou potázal. ');

            inherited();
        }
        action()
        {
            inherited();

            currentCombo += toString(curSetting);

            "Fajn, zatím jsi zadal kombinaci <<sayCurrentCombo>>. ";

            if(currentCombo.length() == 6)
                nestedAction(Open, tresor);
        }
    }
    dobjFor(EnterOn)
    {
        verify() { }
        check()
        {
            if(commander.isIn(commandersRoom))
                failCheck('Nemůžeš si přeci hrát s trezorem velitele před
                    jeho zraky. To by ses se zlou potázal. ');

            inherited();
        }
        action()
        {
            local combo;
            combo = gLiteral;

            /* Zahodíme memzery a pomlčky. */
            combo = rexReplace('<space|->', combo, '', ReplaceAll);

            if(rexMatch('[0-9]+', combo, 1) != combo.length())
            {
                "Na trezoru můžeš zadávat jen číselnou kombinaci. ";
                return;
            }

            if(currentCombo.length() > 0)
                "Fajn, zatím jsi zadal kombinaci: ";
            else
                "Postupně jsi otáčením číselníku na trezoru zadal kombinaci: ";

            currentCombo += combo;
            if(currentCombo.length() > 6)
                currentCombo = currentCombo.substr(1, 6);

            "<<sayCurrentCombo>>. ";

            if(currentCombo.length() == 6)
                nestedAction(Open, tresor);
        }
    }
    dobjFor(TypeLiteralOn) asDobjFor(EnterOn)

    iobjFor(AttachTo) remapTo(AttachTo, DirectObject, tresor)

    gcName = 'číselníku, číselníku, číselník, číselníku, číselníkem'
    gcVocab = 'číselníku/číselníkem/zámku/zámkem'
;

++ tresorBills: Readable 'účtenky/účtenka' 'účtenky' *3
    "Koukáš na účet za laboratorní vybavení – že by si někdo chtěl splnit odznak
        Mladý chemik? Standardní vybavení dodává přece společnost, ale k čemu
        tady kdo potřebuje mikropipety, třepačky, ultrazvukové lázně,
        prosévačky? "

    subLocation = &subContainer

    isPlural = true
    gcName = 'účtenek, účtenkám, účtenky, účtenkách, účtenkami'
    gcVocab = 'účtenek/účtenkám/účtenkách/účtenkami/účtenky/účtence/účtenku/
        účtenkou'
;

++ tresorLetter: Readable 'dopis/dopisy' 'dopis' *2
    "Tohle je dopis dobré čtyři měsíce starý: <q>Vážený pane,… blablabla,… s
        lítostí oznamujeme, že náhradní cívka do vašeho mikroskopu TEM Rusk 31
        je naprosto nesehnatelná a nabízíme vám mikroskop SEM Zworyk 42. Je ze
        zrušené laboratoře z Tychova komplexu na Měsíci, ale je zcela funkční…
        blablabla… pokud nedáte jiné pokyny, přibalíme ho k následné zásilce… s
        pozdravem… blabla…</q>

        <.p><q>To jsou věci,</q> pomyslel sis. Elektronový mikroskop. Ten neměla
        ani vaše akademie. A tady si je někdo objednává jak na běžícím pásu. "

    subLocation = &subContainer

    gcName = 'dopisu, dopisu, dopis, dopisu, dopisem'
    gcVocab = 'dopisu/dopisem/dopisů/dopisům/dopisech'
;

++ tresorPapers: Readable 'listiny/listina' 'listiny' *3
    "Rozložil jsi před sebou několik listin. Jsou to snad ty, které kapitán s
        velitelem tak zaujatě studovali při tvém příchodu. Působí velmi
        oficiálně, ale nikde není uvedené jediné jméno. Vypadá to na nějakou
        dohodu o dodávce něčeho blíže neurčeného za velmi výhodných podmínek.
        Hlavně pro dodavatele. "

    subLocation = &subContainer

    isPlural = true
    gcName = 'listin, listinám, listiny, listinách, listinami'
    gcVocab = 'listin/listinám/listinách/listinami/listyny/listině/listinu/
        listinou'
;

++ tresorDiamonds: Thing 'diamanty/diamant' 'diamanty' *2
    "Několik malých diamantů v průhledném plastovém pytlíku. Všechny jsou úplně
        stejné, jeden jako druhý. "

    subLocation = &subContainer

    isPlural = true
    gcName = 'diamantů, diamantům, diamanty, diamantech, diamanty'
    gcVocab = 'diamantů/diamantům/diamantech/diamantu/diamantem'
;

++ tresorNoise: PresentLater, SimpleNoise
    'zvláštní tichounké klapání trezoru' 'klapání' *4
    "Přitiskl jsi ucho na dvířka trezoru a zkusil poslouchat cvakání uvnitř
        zámku, ale zvuk je příliš slabý. "
;
