#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* Rozvody jsou dvě lokace, tak abychom nemuseli opisovat slovník. */
class ConductRoom: BaseRoom
    vocabWords = 'rozvody rozvodů rozvodům rozvodech vzduchotechnika/
        vzduchotechniky/vzduchotechnice/vzduchotechniku/vzduchotechnikou/
        ventilace/ventilaci/ventilací'

    isPlural = true
;

/* ------------------------------------------------------------------------ */
/*
 *   NAD SKLADEM
 */
supplyConducts: ConductRoom
    'V rozvodech (nad skladem)'
    "Jsi nacpaný ve ventilaci, je tu sotva dost místa, aby ses mohl pomalu
        plazit. Otevřenou větrací mřížkou pod sebou vidíš sklad, přímo pod
        mřížkou je pracovní stůl s UniDiPem a nějakým nářadím. "

    /* Cíl v popisu směrů se liší podle toho, odkud hráč kouká. */
    destName()
    {
        if(me.isIn(technicianConducts))
            return 'nad sklad';
        else
            return 'do rozvodů';
    }

    down = supplyHoleInside
    out asExit(down)
    east = technicianConducts
    
    gender = 2
    isPlural = true
    name = 'rozvody'
    gcName = 'rozvodů, rozvodům, rozvody, rozvodech, rozvody'
    gcVocab = 'rozvody/rozvodů/rozvodům/rozvodech'
;

+ supplyHoleInside: Door -> supplyHole 'větrací otvor/mřížka' 'větrací otvor' *2
    "Větracím otvorem pod sebou vidíš sklad, přímo pod mřížkou je pracovní stůl
        s UniDiPem a nějakým nářadím. "

    dobjFor(Close)
    {
        verify() { illogical('Odsud mřížku nezavřeš, mřížka se zajišťuje z druhé
            strany. '); }
    }

    lookInDesc = "Koukáš zpátky do skladu pod sebou. Odsud vidíš akorát na
        pracovní stůl, který je pod mřížkou. "
    dobjFor(LookThrough) asDobjFor(LookIn)

    changeGender = 'mříž:3'
    gcName = 'větracího otvoru, větracímu otvoru, větrací otvor, větracím
        otvoru, větracím otvorem'
    gcVocab = 'větracího větracímu větracím otvoru/otvorem/mřížky/mřížce/mřížku/
        mřížkou'
;

/* Chrápán je kontejnerově umístěno tentokrát obecně v místnosti. */
+ Noise 'chrápání/zvuk' 'chrápání' *4
    
    /* Opakovaně při pobytu v místnosti podle rozvrhu. */
    hereWithSource = "Slyšíš chrápání. "
    
    /* Prozkoumej chrápání, poslouchej chrápání. */
    descWithSource = "Chrápání přichází z východu. "

    /* Zobrazuj po dvou tazích, pak zase po dvou, po třech atd. */
    displaySchedule = [2, 2, 3, 3, 4]

    gcName = 'chrápání, chrápání, chrápání, chrápání, chrápáním'
    gcVocab = 'chrápáním/zvuku/zvukem'
;

/* ------------------------------------------------------------------------ */
/*
 *   NAD TECHNIKOVOU KAJUTOU
 */
technicianConducts: ConductRoom
    'V rozvodech (nad kajutou technika)' 'nad kajutu technika'
    desc()
    {
        "Jsi nacpaný ve ventilaci, je tu sotva dost místa na pomalé plazení
            vpřed nebo vzad. Větrací mřížkou pod sebou vidíš Borisovu kajutu.
            Přímo pod mřížkou je stůl<<if card.isIn(trTable)>>, na stole leží
            odložená identifikační karta<<end>>. Boris hlasitě chrápe na
            posteli.<<gReveal('hint-above-technician')>> ";
    }

    west = supplyConducts

    name = 'rozvody'
    gcName = 'rozvodů, rozvodům, rozvody, rozvodech, rozvody'
    gcVocab = 'rozvody/rozvodů/rozvodům/rozvodech'
;

/* ------------------------------------------------------------------------ */

technicianGrating: PresentLater, SenseConnector, Fixture
    'mřížka vzduchotechniky' 'mřížka vzduchotechniky' *3
    "Mřížka je složená z příček s docela velkými otvory mezi nimi. Ruku
        neprotlačíš, ale něco menšího možná ano. "

    /* SenseConnector se nachází ve dvou lokacích, které spojuje. */
    locationList = [technicianConducts, techniciansRoom]
    isListedInContents = nil
    plKey = 'conducts'

    /*
     *   Kartu můžeme protáhnout skrz, ale nic jiného. Materiál fineMesh nepustí
     *   nic skrz, ale my níže do kontroly zasáhneme.
     */
    connectorMaterial = fineMesh
    checkMoveThrough(obj, dest)
    {
        if(obj == card)
            return checkStatusSuccess;
        else
            return new CheckStatusFailure(&cannotMoveThroughMsg, obj, self);
    }
    checkTouchThrough(obj, dest)
    {
        if(dest == card)
        {
            if(!picker.isIn(me))
                return new CheckStatusFailure('Skrz mřížku na kartu nedosáhneš,
                    otvory jsou na protažení ruky moc úzké. Možná, kdybys měl
                    něco, co by se dalo mřížkou prostrčit, nějaký šikovný
                    nástroj. ', dest, self);
            else
                return checkStatusSuccess;
        }
        return new CheckStatusFailure(&cannotReachThroughMsg, dest, self);
    }

    /* "Dej podávátko do mřížky" má být chápáno jako "vem kartu". */
    iobjFor(PutIn)
    {
        verify() { if(gDobj != picker) inherited; }
        action() { replaceAction(Take, card); }
    }

    /* Prostrč podávátko mřížkou. */
    iobjFor(PushTravelThrough)
    {
        verify() {}
    }

    /* Dej podávátko pod mřížku. */
    iobjFor(PutUnder) asIobjFor(PutIn)

    dobjFor(Open)
    {
        verify() { }
        check() { failCheck('Odsud mřížku neotevřeš. Není způsob, jak bys mohl
            dosáhnout na západky z druhé strany. '); }
    }
    dobjFor(Take) asDobjFor(Open)
    dobjFor(Move) asDobjFor(Open)
    dobjFor(Pull) asDobjFor(Open)
    dobjFor(Push) asDobjFor(Open)
    dobjFor(Detach) asDobjFor(Open)

    /* Rozbij mřížku. */
    dobjFor(Break)
    {
        verify() { }
        check()
            { failCheck('Teď opravdu není dobrý nápad se chovat hlučně. '); }
    }
    dobjFor(Attack) asDobjFor(Break)

    /* Podívej se do mřížky/skrz mřížku. */
    lookInDesc = "Pod sebou vidíš Borisovu kajutu. Přímo pod mřížkou je
        stůl<<if card.isIn(trTable)>>, na stole leží odložená identifikační
        karta<<end>>. "
    dobjFor(LookThrough) asDobjFor(LookIn)

    gcName = 'mřížky vzduchotechniky, mřížce vzduchotechniky, mřížku
        vzduchotechniky, mřížce vzduchotechniky, mřížkou vzduchotechniky'
    gcVocab = 'mřížky mřížce mřížku mřížkou'
;

/* Zvuk chrápání je umístěn pomocí kontejnerové hierarchie do mřížky. */
+ Noise 'chrápání' 'chrápání' *4

    /* Aby hráč mohl zadat >prozkoumej Borisovo chrápání. */
    owner = technician
    
    /* Opakovaně při pobytu v rozvodech podle rozvrhu. */
    hereWithSource = "Slyšíš Borisovo chrápání. "
    
    /* Prozkoumej chrápání, poslouchej chrápání. */
    descWithSource = "Chrápání přichází z Borisovy kajuty. "

    /* Prozkoumej mřížku (přidá na konec), poslouchej mřížku. */
    sourceDesc = "Line se z ní Borisovo chrápání. "

    /*
     *   Sice chceme, aby se chrápání připomínalo podle rozvrhnu při pobytu v
     *   místnosti, ale v rozhlédnutí ho nechceme, protože zmíňku o něm už máme
     *   v samotném popisu místnosti.
     */
    isSoundListedInRoom = nil

    /*
     *   Normálně po opuštění místnosti se zvukem se hráči zobrazí informace, že
     *   chrápání už neslyší. My ale máme v každé místnosti po trase samostatné
     *   objekty, které stupňují hlasitost a které mají na sebe navazovat.
     */
    isEmanating = me.isIn(technicianConducts)
    displaySchedule = [2, 2, 3, 3, 4]

    gcName = 'chrápání, chrápání, chrápání, chrápání, chrápáním'
    gcVocab = 'chrápáním/zvuku/zvukem'
;
