#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   MÍSTNOST S ROBOTEM
 */
robotFloor: Floor 'podlaha' 'podlaha' *3
    "Podlaha v této místnosti je viditelně rozdělená na 3×3 čtverce, zřejmě se
        jedná o nějaký organizační systém pro navigaci robota. "

    gcName = 'podlahy, podlaze, podlahu, podlaze, podlahou'
    gcVocab = 'podlahy/podlaze/podlahu/podlahou/země/zemi/zemí'
;

robotRoom: BaseRoom 'Místnost s robotem' 'do místnosti s robotem'

    /*
     *   Ještě dříve, než do této místnosti hráč vejde, bude do ní nahlížet z
     *   velína přes kamerový systém. Většina případů je odchycena níže pomocí
     *   roomRemoteDesc, ale když dá příkaz "prozkoumej místnost", tak by se
     *   ukázal desc popisek.
     */
    desc()
    {
        if(me.isIn(controlRoom)) roomRemoteDesc(me);
        else
            "Jsi ve čtvercové místnosti s robotem a velkými bednami, které
                zabírají prostor od podlahy skoro ke stropu. Na západě jsou
                zelené dveře do chodby s širokým madlem, na východ vedou průlezy
                do průzkumných vozítek a na severu jsou dveře s průzorem. ";
    }

    roomRemoteDesc(actor)
    {
        "V jednom ze záběrů poznáváš místnost, kam odešli kapitán s velitelem.
            Je čtvercová o rozměrech 3×3 čtverce a stojí v ní dvě velké bedny
            zabírající prostor od jižní stěny k prostředku, takže zbylý prostor
            v místnosti, ve kterém se dá pohybovat, má tvar podobný obrácenému
            hranatému U.

            <.p>V jihozápadním rohu jsou zelené dveře s širokým madlem, vedoucí
            do chodby na západ. Na východ vedou průlezy do průzkumných vozítek a
            na severu jsou dveře s průzorem. V jihovýchodním rohu stojí robot v
            nabíjecím doku. ";
    }

    west = largeDoorOutside
    east = roverDoorOutside
    north = gardenDoor

    /* Kvůli robotovi máme upravenou podlahu. */
    roomParts = static inherited
        - defaultFloor + robotFloor

    gender = 3
    vocabWords = 'místnost/místnosti/místností'
    gcName = 'místnosti s robotem, místnosti s robotem, místnost s robotem,
        místnosti s robotem, místností s robotem'
;

/* Dveře se samy zavírají, aby nebylo podezřelé, že je hráč nechal otevřené. */
+ largeDoorOutside: IndirectLockable, AutoClosingDoor -> largeDoor
    'velké zelené dveře' 'zelené dveře' *3
    "Jsou v jihozápadním rohu místnosti (na západní stěně) a místo klasické
        kliky mají na sobě široké madlo, o které se stačí jen opřít, a dveře se
        otevřou. Vedou do chodby. "

    isPlural = true
    sightSize = small

    gcName = 'zelených dveří, zeleným dveřím, zelené dveře, zelených dveřích,
        zelenými dveřmi'
    gcVocab = 'velkých velkým velkými zelených zeleným zelenými dveří/dveřím/
        dveřích/dveřmi'
;

++ Component 'široké madlo/(dveří)' 'madlo' *4
    "Dveře mají na sobě místo klasické kliky široké madlo, o které se stačí jen
        opřít, a dveře se otevřou. "

    /*
     *   Sada vlastností disambigName slouží k položení otázky "a co tím máš na
     *   mysli?" Madlo dveří se může plést s madly vysílacího modulu, proto v
     *   otázce upřesníme, aby hráč nebyl zmatený, na jaké madlo se ptáme.
     */
     disambigName = 'madlo dveří'
     disambigNameKohoCo = 'madlo dveří'

    gcName = 'madla, madlu, madlo, madlu, madlem'
    gcVocab = 'širokého širokému širokém širokým madla/madlu/madlem'
;

/* ------------------------------------------------------------------------ */
/*
 *   Průlez zamykáme programem když odjede vozítko.
 */
+ roverDoorOutside: IndirectLockable, Door -> roverDoor
    'pravý průlez (do) (vozítka) -*průlezy (do) (vozítka)' 'průlez do vozítka' *2
    "Průlez do vozítka je akorát tak velký, aby se jím bez potíží protáhl
        kosmonaut. Zaparkované vozítko je připojené krátkým vzduchotěsným
        tunelem. "

    cannotUnlockMsg = 'Průlez nemá žádný viditelný zámek. '
    cannotLockMsg = 'Průlez nemá žádný viditelný zámek. '
    alreadyLockedMsg = 'Průlez nemá žádný viditelný zámek. '
    alreadyUnlockedMsg = 'Průlez nemá žádný viditelný zámek. '

    disambigName = 'pravý průlez'
    disambigNameKohoCo = 'pravý průlez'

    gcName = 'průlezu do vozítka, průlezu do vozítka, průlez do vozítka,
        průlezu do vozítka, průlezem do vozítka'
    gcVocab = 'pravého pravému pravém pravým průlezu průlezem -*průlezů'
;

+ Enterable -> roverDoorOutside 'vozítko/vozidlo/vozík' 'vozítko' *4

    /*
     *   Protože jsme se prominentně zmínili o průlezu, hráč může mít tendenci
     *   zadat příkaz "prozkoumej ho", tedy odvolat se na něj zájmenem. Tohle
     *   TADS nemůže poznat sám, tak mu o tom musíme říci me.setHim(objekt).
     */
    "Průlez na východě vede do přistaveného vozítka.
        <<me.setHim(roverDoorOutside)>> "

    /*
     *   Vozítko představuje vedlejší lokaci, tak by nemělo reagovat na "vše"
     *   v příkazu hráče.
     */
    hideFromAll(action) { return true; }
    
    gcName = 'vozítka, vozítku, vozítko, vozítku, vozítkem'
    gcVocab = 'vozítka/vozítku/vozítkem/vozidla/vozidlu/vozidlem/vozíku/vozíkem'
;

+ IndirectLockable, Door
    'levý průlez (do) (vozítka) -*průlezy (do) (vozítka)' 'průlez do vozítka' *2
    "<<if gRevealed('lunch')>>Průlez vede do druhého průzkumného vozítka, ale po
        zaparkování ho někdo zavřel a zamkl.
        <<else>>Zavřený průlez vede do druhého průzkumného vozítka. Teď tam
        žádné vozítko zaparkované není. "

    /* Vlastnost rozšíření custmsg, která zabrání vypsání "je zavřený". */
    openStatusReportable = nil

    cannotUnlockMsg = 'Průlez nemá žádný viditelný zámek. '
    cannotLockMsg = 'Průlez nemá žádný viditelný zámek. '
    alreadyLockedMsg = 'Průlez nemá žádný viditelný zámek. '
    alreadyUnlockedMsg = 'Průlez nemá žádný viditelný zámek. '

    disambigName = 'levý průlez'
    disambigNameKohoCo = 'levý průlez'

    gcName = 'průlezu do vozítka, průlezu do vozítka, průlez do vozítka,
        průlezu do vozítka, průlezem do vozítka'
    gcVocab = 'levého levému levém levým průlezu průlezem -*průlezů*průlezům*
        průlezech'
;

/* ------------------------------------------------------------------------ */

+ gardenDoor: IndirectLockable, Door
    'dveře (s) průzorem/dveře/průzor/okénko' 'dveře s průzorem' *3
    "<<if me.isIn(robotRoom)>>Podle narudlého osvětlení uvnitř vedou dveře
        zřejmě do hydroponické zahrady a laboratoře. Čtečka karet u dveří ale
        signalizuje, že jsou zamčené. <<else>>Těžko říci, kam vedou. "

    cannotLockMsg = '{Kdoco dobj} nemají zámek, zamykají se po vložení karty
        do čtečky. '
    cannotUnlockMsg = '{Kdoco dobj} nemají zámek, odemykají se po vložení karty
        do čtečky. '

    dobjFor(LookIn) asDobjFor(Examine)
    dobjFor(LookThrough) asDobjFor(Examine)

    isPlural = true
    //changeGender = 'průzor:2, okén:4'
    gcName = 'dveří s průzorem, dveřím s průzorem, dveře s průzorem,
        dveřích s průzorem, dveřmi s průzorem'
    gcVocab = 'dveří dveřím dveřích dveřmi průzoru/okénka/okénku/okénkem'
;

++ RestrictedContainer, Component
    'čtečka slot (na) (kartu)/čtečka/slot' 'čtečka na kartu' *3
    "Signalizuje stav zamčeno. "

    /*
     *   Čtečka je RestrictedContainer a tato vlastnost určuje, co do ní lze
     *   vložit. Ostatní objekty reagují chybou cannotPutInMsg níže.
     */
    validContents = [card]

    cannotPutInMsg(obj)
    {
        gMessageParams(obj);
        return 'Čtečka je určena jen na identifikační karty, {kohoco obj} do
            ní vložit nemůžeš. ';
    }

    /* Nicméně za tyhle dveře se hráč nikdy nedostane. */
    iobjFor(PutIn)
    {
        check()
        {
            inherited;
            failCheck('Zkusil jsi protáhnout kartu čtečkou, ale ta jen odmítavě
                zapípala. S touto kartou tyto dveře neotevřeš. ');
        }
    }

    /* V této části je tablet jediným objektem, který můžeme namířit. */
    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tablet na čtečku u dveří s průzorem. Tablet chvíli
                předstíral činnost, načež zobrazil strohou hlášku vstup
                zakázán. ";
        }
    }

    gcName = 'čtečky na kartu, čtečce na kartu, čtečku na kartu,
        čtečce na kartu, čtečkou na kartu'
    gcVocab = 'čtečky čtečce čtečku čtečkou slotu slotem čtečky/čtečce/čtečku/
        čtečkou/slotu/slotem'
;

+ garden: Enterable -> gardenDoor
    'hydroponická hydroponický zahrada/laboratoř/hydroponie'
    'hydroponická zahrada' *3
    "Hydroponická zahrada bývá nezbytnou součástí stabilních základen.
        Astronauti také potřebují čerstvou zeleninu. Zvláště jsou-li hodně
        daleko od domova a zásobování je velmi omezené. "

    hideFromAll(action) { return true; }

    gcName = 'hydroponické zahrady, hydroponické zahradě, hydroponickou zahradu,
        hydroponické zahradě, hydroponickou zahradou'
    gcVocab = 'hydroponické hydroponickou zahrady/zahradě/zahradu/zahradou/
        laboratoře/laboratoři/laboratoří/hydroponii/hydroponií'
;

/* ------------------------------------------------------------------------ */

+ Heavy 'bedny/bedna' 'bedny' *3
    "Jsou nejspíš plechové, natřené světle šedou barvou. Nelze rozpoznat jejich
        účel, nejsou na nich viditelné nápisy. Možná je v nich nějaké zařízení,
        možná něco jiného. Obě bedny jsou pevně uchycené k podlaze a nezdá se,
        že by jimi bylo možné pohnout. "

    dobjFor(Open)
    {
        verify() {}
        action() { "Jsou kovové, pevně zavřené a nemáš sebemenší představu, jak
            se dostat dovnitř. "; }
    }
    dobjFor(Break) asDobjFor(Open)

    isPlural = true
    changeGender = 'bednu:3,bednou:3'
    gcName = 'beden, bednám, bedny, bednách, bednami'
    gcVocab = 'beden/bednám/bednách/bednami/bedně/bednu/bednou'
;

/* ------------------------------------------------------------------------ */

+ robot: Heavy

    /*
     *   Zatím jsem nevymyslel nic chytřejšího, tak anglické 's značí
     *   přivlastňovací zájmena. Je to jen značka, tato slova se zadávají
     *   u postav a hráč jimy může vyjádřit vlastnictví.
     */
    'robot/robotův\'s/robotovo\'s/robotova\'s/robotovy\'s' 'robot' *2
    "Je docela vysoký, mírně se zužující směrem nahoru, vysoký skoro až ke
        stropu, jeden z těch starých modelů od Kybernetické Automatové Robotické
        Experimentální Laboratoře. Úplně navrchu má barevný majáček
        signalizující stav. Na první pohled jsou na něm zřejmá jen nárazová
        čidla a zřejmě magnetický podvozek, protože robot očividně drží pevně na
        podlaze. "

    iobjFor(AimAt)
    {
        action()
        {
            /* Dokud je ve velínu technik, obrazovky ukazují něco jiného. */
            if(!technician.isIn(controlRoom))
            {
                if(tablet.runningApp != 'robot')
                {
                    if(me.isIn(controlRoom))
                        "<.p>Zaměřil jsi tablet na obrazovku kamerového systému a
                            ten svou kamerkou na obrazovce ihned rozpoznal robota a
                            nabídl ti možnost ho ovládat.<.p> ";
                    else
                        "<.p>Zaměřil jsi tablet na robota a ten svou kamerkou
                            ihned rozpoznal robota a nabídl ti možnost ho
                            ovládat.<.p> ";

                    tablet.runApp('robot');
                    scoreMarker.awardPointsOnce();
                }
                else
                    tablet.screenDesc();
            }
        }
    }
    scoreMarker: Achievement { +3 "ovládnutí robota" }

    gcName = 'robota, robotovi, robota, robotovi, robotem'
    gcVocab = 'robota/robotovi/robote/robotu/robotem/robotových\'s/robotově\'s/
        robotovu\'s/robotovým\'s/robotovými\'s'
;

++ Component 'magnetický podvozek' 'podvozek' *2
    "Je magnetický, takže drží na podlaze, místo aby se vznášel. "

    gcName = 'podvozku, podvozku, podvozek, podvozku, podvozkem'
    gcVocab = 'magnetického magnetickému magnetickém magnetickým podvozku/
        podvozkem'
;

++ Component 'nárazové nárazová čidlo/čidla' 'nárazová čidla' *3
    "Nárazová čidla na robotovi detekují náraz do překážky a mohou zabránit
        nevratným škodám v případě chybného programu. "
    
    isPlural = true
    gcName = 'nárazových čidel, nárazovým čidlům, nárazová čidla,
        nárazových čidlech, nárazovými čidly'
    gcVocab = 'nárazového nárazovému nárazovém nárazovým nárazových nárazovými
        čidlu/čidlem/čidel/čidlům/čidlech/čidly'
;

++ Component 'barevný výstražný majáček' 'majáček' *2
    "Signalizuje stav robota zelenou, nebo červenou barvou. "

    gcName = 'majáčku, majáčku, majáček, majáčku, majáčkem'
    gcVocab = 'barevného barevnému barevném barevným výstražného výstražnému
        výstražném výstražným majáčku/majáčkem'
;

+ Fixture 'nabíjecí dok' 'nabíjecí dok' *2
    "Nabíjecí dok leží v jihovýchodním rohu místnosti. Je na něm zaparkovaný
        robot. "

    gcName = 'nabíjecího doku, nabíjecímu doku, nabíjecí dok, nabíjecím doku,
        nabíjecím dokem'
    gcVocab = 'nabíjecího nabíjecímu nabíjecím doku/dokem'
;

/* ------------------------------------------------------------------------ */
/*
 *   Jakmile nastane správná doba, televizní záběr spojí velín s touto
 *   místností a umožní do ní nahlížet.
 */
cctvLink: SenseConnector, Intangible 'televizní záběr' 'televizní záběr' *2
    "<<cctvScreen.desc>> "

    /*
     *   SenseConnectior dědí z MultiLoc, takže místo location má locationList.
     *   Na začátku ale ještě s velínem není propojen.
     */
    locationList = [robotRoom]
    transSensingThru(sense)
    {
        /* Televizní záběr musí fungovat jen jedním směrem. */
        if(me.isIn(robotRoom)) return opaque;
        else return sense == sight ? transparent : opaque;
    }

    /* Nechceme, aby hra o místnosti psala "obsahuje televizní záběr". */
    isListed = nil
    isListedInContents = nil

    /* Příkaz "prozkoumej vše" se na nás vztahuje, ale jiné příkazy už ne. */
    hideFromAll(action)
    {
        return !action.ofKind(ExamineAction);
    }

    /*
     *   We can examine to these objects, as normal for any Thing. To make these
     *   verbs work as normal for Thing, we need to explicitly override the
     *   corresponding verifiers, so that we bypass the dobjFor(Default)
     *   verifier in Intangible. We don't need to do anything special in the
     *   overrides, so just inherit the default handling; what's important is
     *   that we do override the methods at all.
     */
    dobjFor(Examine) { verify() { inherited(); } }

    dobjFor(LookIn) asDobjFor(Examine)
    //dobjFor(LookThrough) asDobjFor(Examine)
    dobjFor(Search) asDobjFor(Examine)

    gcName = 'televizního záběru, televiznímu záběru, televizní záběr,
        televizním záběru, televizním záběrem'
    gcVocab = 'televizního televiznímu televizním záběru/záběrem'
;
