#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena. Podrobnosti o šíření v souboru LICENCE.txt.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   TOALETA
 */
toilet: BaseRoom 'Toaleta' 'na toaletu' 'z toalety'
     "Jsi na WC. Místnůstka je velice malá se samostaným větráním, posuvnými
        dveřmi, záchodovou mísou, násoskou, popruhy a držadly. "

    out = toiletDoor
    southeast asExit(out)

    /* Přemapujeme "sednout si na toaletu", tím je myšlena mísa, ne místnost. */
    dobjFor(SitOn) remapTo(SitOn, toiletSeat)

    gender = 3
    changeGender = 'záchod:2, wc:4'
    gcVocab = 'záchod/záchodu/záchodem/toaleta/toalety/toaletě/toaletu/toaletou/
        wc/místnůstka/místnůstky/místnůstce/místnůstku/místnůstkou'
    gcName = 'toalety, toaletě, toaletu, toaletě, toaletou'
;

+ toiletDoor: Lockable, Door 'posuvné dveře' 'posuvné dveře' *3
    "I kosmonauti chtějí mít na toaletě soukromí. "

    /* Zamykatelné dveře by byly na začátku zamčené, to nechceme. */
    initiallyLocked = nil

    dobjFor(Open)
    {
        /* Než hráč odejde z toalety, měl by si nasadit overal. */
        preCond = static (inherited + new ObjectPreCondition(overal, objWorn));
    }

    isPlural = true
    gcName = 'posuvných dveří, posuvným dveřím, posuvné dveře, posuvných
        dveřích, posuvnými dveřmi'
    gcVocab = 'posuvných posuvným posuvnými dveří/dveřím/dveřích/dveřmi'
;

+ toiletSeat: Chair, Fixture 'záchodová mísa' 'záchodová mísa' *3
    "Záchodová mísa je speciálně upravená pro provoz ve stavu beztíže s
        odsáváním a popruhy přidružujícími astronauta na místě. "

    /* Vylít něco do mísy, kafe je ve hře jediné, co se dá lít. */
    iobjFor(PourInto)
    {
        verify() { illogical('Jakkoliv nechutné to kafe je, Boris ho má rád
            a určitě by nebyl rád, kdyby se jím plýtvalo. '); }
    }
    iobjFor(PourOnto) asIobjFor(PourInto)

    /* Zatlač do mísy :-) */
    dobjFor(Push)
    {
        verify()
        {
            if(!me.isIn(toiletSeat)) illogicalNow('Cítíš-li potřebu zatlačit do
                mísy, tak si na ni budeš muset nejprve sednout. ');
            if(overal.isWornBy(me)) illogicalNow('Přes oblečený overal to asi
                nepůjde. ');
        }
        action() { pushingList.doScript(); }
    }
    pushingList: StopEventList
    {
        [
            'Pohodlně ses uvelebil. Ještě jednou jsi zkontroloval popruhy, aby
                ses nevznášel v nejkritičtější okamžik a pak lehce zatlačil.
                Uff. Pak ještě jednou silněji… ááách, ta úleva. Automatika
                neprodleně zareagovala a s hlasitým cucnutím odklidila, cos
                napáchal. Jen nepatrnou chvilku potom zareagovala pachová čidla
                a spustilo se na chvilku větrání. ',

            'Zkusil jsi zatlačit a… nic. Kde nic není, ani smrt nebere. '
        ]
    }

    gcName = 'záchodové mísy, záchodové míse, záchodovou mísu, záchodové míse,
        záchodovou mísou'
    gcVocab = 'záchodové záchodovou mísy/míse/mísu/mísou'
;

+ Decoration 'gumové popruhy' 'popruhy' *2
    "Gumové popruhy, které si astronaut při sezení přetáhne přes nohy, aby se
        nevznášel, když se to zrovna nehodí. "

    isPlural = true
    gcName = 'popruhů, popruhům, popruhy, popruzích, popruhy'
    gcVocab = 'gumových gumovým gumovými popruhů/popruhům/popruzích'
;

+ Decoration 'násoska' 'násoska' *3
    "Když se chce astronautům jen čurat, nemusí používat mísu, k tomu slouží
        násoska. Detaily viz historické dokumenty N.A.S.A. "

    gcName = 'násosky, násosce, násosku, násosce, násoskou'
    gcVocab = 'násosky/násosce/násosku/násoskou'
;

+ Decoration 'držadla' 'držadla' *4
    "Obyčejná držadla usnadňující pohyb v beztíži. "

    isPlural = true
    gcName = 'držadel, držadlům, držadla, držadlech, držadly'
    gcVocab = 'držadel/držadlům/držadlech/držadly'
;

+ Decoration 'větrání/ventilace/mřížka' 'větrání' *4
    "Mřížka je spíš menší, přibližně 20×30 cm, pevně přišroubovaná v otvoru
        ventilace. Nepříliš vzdálený a lehce slyšitelný ventilátor odsud odsává
        vzduch. "
    
    changeGender = 'ventil:3, mříž:3'
    gcName = 'větrání, větrání, větrání, větrání, větráním'
    gcVocab = 'větráním/ventilaci/ventilací/mřížky/mřížce/mřížku/mřížkou'
;

/*
 *   Když je technik na záchodě, tak poskytneme možnost se s ním bavit přes
 *   dveře záchoda. Obě místnosti tedy propojíme konektorem přenášejícím zvuk.
 *   Protože ale i obě části chodby, sklad a velín jsou propojené smyslovým
 *   konektorem, tak účinnost tohoto konektoru omezíme jen na západní konec
 *   chodby.
 */
SenseConnector, Intangible
    locationList = [toilet, corridorWest]
    transSensingThru(sense)
    {
        return sense == sound && me.isIn(corridorWest) ? transparent : opaque;
    }
;

/*
 *   Smrad se objeví, jakmile Boris ze záchoda vyleze. Zhmotníme ho spolu s
 *   rozvody vzduchotechniky nad Borisovou kajutou a skladem. SimpleOdor
 *   reprezentuje něco, co je trvalou součástí lokace a nemá konkrétní zdroj.
 */
+ PresentLater, SimpleOdor 'smrad' 'smrad' *2
    desc = "Nasál jsi vzduch… Vůbec by ses nedivil, kdyby pohasla světla,
        veškerý příkon energie teď asi spotřebovává klimatizace. "

    plKey = 'conducts'

    gcName = 'smradu, smradu, smrad, smradu, smradem'
    gcVocab = 'smradu/smradem'
;
