#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* Definujeme nový příkaz "vystřel" a jeho slovník. */
DefineTIAction(ShootAt)

    /*
     *   Potlačíme zájmeno pro první objekt v otázce na druhý objekt, to asi
     *   nefunguje správně.
     */
    getOtherMessageObjectPronoun(which)
        { return nil; }
;

VerbRule(ShootAt)
    ('vystřel' | 'vystřelit' | 'vypal' | 'vypálit') ('z' | 'ze') singleIobj
    'na' singleDobj
    | ('vystřel' | 'vystřelit' | 'vypal' | 'vypálit') 'na' singleDobj
    ('z' | 'ze') singleIobj
    : ShootAtAction
    verbPhrase = 'vystřelit/stříl{íš}/vystřelil{a} (na co) (z čeho)'
    askDobjResponseProd = onSingleNoun
    askIobjResponseProd = outOfSingleNoun
;

VerbRule(ShootAtWhat)
    ('vystřel' | 'vystřelit' | 'vypal' | 'vypálit') ('z' | 'ze' | ) singleIobj
    : ShootAtAction
    verbPhrase = 'vystřelit/stříl{íš}/vystřelil{a} (na co) (z čeho)'
    askIobjResponseProd = outOfSingleNoun
    construct()
    {
        /* set up the empty indirect object phrase */
        dobjMatch = new EmptyNounPhraseProd();
        dobjMatch.responseProd = onSingleNoun;
    }
;

VerbRule(ShootAtWithWhat)
    ('vystřel' | 'vystřelit' | 'vypal' | 'vypálit') 'na' singleDobj
    : ShootAtAction
    verbPhrase = 'vystřelit/stříl{íš}/vystřelil{a} (na co) (z čeho)'
    construct()
    {
        /* set up the empty indirect object phrase */
        iobjMatch = new EmptyNounPhraseProd();
        iobjMatch.responseProd = outOfSingleNoun;
    }
;

/* Zavedeme výchozí chování střílení na všechny objekty. */
modify Thing
    dobjFor(ShootAt)
    {
        verify() { }
    }
    iobjFor(ShootAt)
    {
        verify()
        {
            illogical('To není něco, z čeho bys mohl vystřelit. ');
        }
    }
;

/* Na dekorace v tunelu je logické zamířit a vystřelit, jsou to cvičné terče. */
modify Decoration
    dobjFor(ShootAt)
    {
        verify() { }
    }
    iobjFor(AimAt)
    {
        verify() { }
    }
;

/* ------------------------------------------------------------------------ */
/*
 *   TUNEL
 */
tunnel: Room 'Tunel' 'do tunelu'
    "Jsi v široké vytěžené šachtě. Dál na sever šachtou jet nelze, blokují ji z
        části zasypané trosky razicího štítu těžebního stroje, který tu
        havaroval, ale vše užitečné odsud již bylo odneseno. Je tu však dost
        místa, aby se sem pohodlně vešlo další průzkumné vozítko. "

    in = suitPortOutside
    east = tunnelPassage

    up: TravelConnector
    {
        isConnectorListed = nil
        dobjFor(TravelVia)
        {
            action() { replaceAction(StandOn, roverPlatform); }
        }
    }
    south: FakeConnector
    {
        travelDesc = "Pohlédl jsi do chodby na jih, ale ve skafandru není dost
            kyslíku na dlouhou vycházku kamenitou pustinou a jít naproti
            pronásledovatelům také není nejlepší nápad. "
    }

    /*
     *   Při kouknutí průzory zevnitř vozítka: "Venku v tunelu vidíš laser
     *   (který obsahuje dva vybité akumulátory)."
     */
    inRoomName(pov) { return 'venku v tunelu'; }

    /*
     *   Jakmile hráč provedl replikaci, ať už úspěšnou či neúspěšnou, tak se
     *   přibližují pronásledovatelé.
     */
    atmosphereList = gRevealed('replicated') ? approachingAtmosphere
        : firstAtmosphere
    firstAtmosphere: EventList
    {
        [
            'Popošel jsi pár krůčků. Skafandr ti nedovoluje moc rychlý pohyb a
                slabá gravitace taky moc nepomáhá. Zatrnulo ti při představě,
                jak snadný cíl budeš, až tě kapitán s velitelem doženou. Kdybys
                tak měl něco na svou obranu. ',
            '',
            '',
            'Rádio ve skafandru mlčí. Slyšíš jen vlastní dech a zvuky
                skafandru. ',
            '',
            '',
            'Zamrazilo tě, když sis uvědomil osamělost kolem a pronásledovatele
                v patách. '
        ]
    }
    approachingAtmosphere: EventList
    {
        [
            'Vyplul jsi od chodby už docela daleko, když sis všiml blížícího se
                vozítka pronásledovatelů. Bohužel už jsou docela blízko a
                pohybují se mnohem jistěji, než jsi schopen ve svém
                skafandru. ',
            'Vozítko pronásledovatelů se opět o notný kus přiblížilo. Ještě
                chvíli a vrazí do tebe. Pokud by ti poškodili skafandr, byl by
                to tvůj konec. ',
            'Pronásledovatelé stále nezpomalují, zdá se, že do tebe opravdu
                chtějí vrazit. ',
            'Už jsou téměř u tebe! ',

            /* Do EventListu lze dát i funkci, která se spustí. */
            new function
            {
                "Vozítko do tebe zaobleným hladkým čelem narazilo. Náraz nebyl
                    silný, ale bohužel tě odhodil, roztočil, dezorientoval a
                    postrčil právě k těm ostrým troskám, o které sis vzápětí
                    roztrhl skafandr. Během pár sekund jsi byl v bezvědomí, smrt
                    následovala nedlouho potom.

                    <.p>Kapitán s velitelem pak pečlivě vyplnili zprávu o tvé
                    nešťastné nehodě a spokojeně užívali ku svému prospěchu
                    zařízení, které mohlo změnit celý svět.<.p> ";

/* Když hrály děti soutěžně, byl na webu žebříček v reálném čase. */
#ifdef TADS_INCLUDE_NET
//                local data =
//                [
//                    'sid' -> webSession.storageSID,
//                    'event' -> 'died',
//                    'points' -> 0,
//                    'desc' -> '',
//                    'total' -> libScore.totalScore
//                ];

//                sendNetRequest(0, 'http://technoplaneta.cz/t3submit', 'POST', 0, nil,
//                    data);
#endif

                /* Jediná smrt v naší hře. */
                finishGameMsg(ftDeath, [finishOptionUndo]);
            }
        ]
    }

    pressure = 0

    gender = 2
    changeGender = 'šacht:3'
    vocabWords = 'široká široké širokou vytěžená vytěžené vytěženou tunel/
        tunelu/tunelem/šachta/šachty/šachtě/šachtu/šachtou'
    gcName = 'tunelu, tunelu, tunel, tunelu, tunelem'
;

+ tunnelPassage: TravelWithMessage, ThroughPassage -> alienPassage
    'nezvyklý nezvyklá vstup/chodba' 'nezvyklý vstup' *2
    "Vstup má průřez zaobleného obdélníku a určitě není přírodního původu, na to
        je geometricky příliš dokonalý. Tmavý materiál vnitřku vstupu má značnou
        tloušťku a postupně plynule přechází v okolní horninu, jako by s ní byl
        srostlý. To, co je tu vidět, je zřejmě jen zbytek něčeho většího,
        nenávratně zničeného těžebním strojem, který tudy projel. Jediné, co
        zbylo, je za tímto vstupem. "

    /*
     *   Normálně se jedná o popis předmětu přidaný do popisu místnosti, dokud
     *   se objekt nachází ve svém úvodním stavu, což je obvykle do té doby, než
     *   se pohne. My ovšem se vstupem pohnout nemůžeme, ale mechanismus
     *   předěláme na zobrazování popisu, dokud nedojde k replikaci.
     */
    initSpecialDesc = "Na východě je nezvyklý vstup. "
    isInInitState = !gRevealed('replicated')

    /* Chodba je vemi zvláštní, proto si zaslouží popis průchodu skrz. */
    travelDesc = "Opatrně jsi vstoupil do vstupu na východě. Jen cos proplul o
        pár metrů dovnitř, rozsvítila se okolo pozvolna světla a odhalila mnohem
        větší prostor.<<laser.target = nil>> "

    /* Jakmile se přiblíží pronásledovatelé, už není žádoucí zdrhnout pryč. */
    canTravelerPass(traveler) { return !gRevealed('replicated'); }
    explainTravelBarrier(traveler)
    {
        "Zkusil ses rozeběhnout k chodbě, ale v nízké gravitaci není snadné se
            pohybovat rychle. Místo toho jsi spíš jen lehce povyskočil a máchaje
            rukama zas pomalu snášel dolů. ";
    }

    /* Podívat se do vstupu. */
    dobjFor(LookThrough)
    {
        action()
        {
            if(torch.isHeldBy(me) && torch.isOn)
                "Posvítil sis dovnitř svítilnou, nedaleko se chodba určitě
                    rozšiřuje a něco tam uvnitř je, ale moc detailů odsud
                    nevidíš. ";
            else
                "Uvnitř vidíš chodbu nebvyklého vzhledu, na konec nedohlédneš,
                    ztrácí se v temnotě. ";
        }
    }
    dobjFor(LookIn) asDobjFor(LookThrough)

    dobjFor(ShootAt)
    {
        verify() { }
    }

    changeGender = 'chodb:3'
    gcName = 'nezvyklého vstupu, nezvyklému vstupu, nezvyklý vstup,
        nezvyklém vstupu, nezvyklým vstupem'
    gcVocab = 'nezvyklého nezvyklému nezvyklém nezvyklým nezvyklé nezvyklou
        vstupu/vstupem/chodby/chodbě/chodbu/chodbou'
;

+ Component 'zbytky neznámé neznámá tmavá temná hmoty/hmota' 'zbytky hmoty' *2
    "Na mnoha místech jsou ve skále zapuštěné zbytky tmavé hmoty. Nebýt těch pár
        posledních zachovalejších míst, kde těžební stroj konstrukci nezničil,
        nebylo by snad ani možné říci, že hmota není součástí skály. V některých
        řezech je vidět, jak plynule ve skálu přechází, jinde lze rozpoznat snad
        části podpěr a možná žebrovité výztuhy. Na východě je z hmoty vytvořený
        nezvyklý vstup. To všechno určitě nemohlo vzniknout samovolně. "

    initSpecialDesc = "V hornině jsou místy zapuštěné zbytky neznámé hmoty. "
    isInInitState = !gRevealed('replicated')

    isPlural = true
    changeGender = '!zbytk:3'
    gcName = 'zbytků hmoty, zbytkům hmoty, zbytky hmoty, zbytcích hmoty,
        zbytky hmoty'
    gcVocab = 'zbytků zbytkům zbytcích neznámou tmavé tmavou temné temnou hmotě/
        hmotu/hmotou'
;

+ Component 'žebrovité výztuhy/podpěry' 'výztuhy' *3
    "Výztuhy byly pravděpodobně součástí mnohem větší a komplikovanější
        konstrukce, ale po průjezdu těžebního stroje tu toho zbylo příliš
        málo. "

    isPlural = true
    gcName = 'výztuh, výztuhám, výztuhy, výztuhách, výztuhami'
    gcVocab = 'žebrovitých žebrovitým žebrovitými výztuh/výztuhám/výztuhách/
        výztuhami/podpěr/podpěrám/podpěrách/podpěrami'
;

+ Component 'konstrukce' 'konstrukce' *3
    "Po konstrukci z tmavé hmoty zbyly jen žalostné náznaky toho, jak precizní a
        impozantní mohla kdysi být. "

    gcName = 'konstrukce, konstrukci, konstrukci, konstrukci, konstrukcí'
    gcVocab = 'konstrukci/konstrukcí'
;

+ Component 'kamení/skála/hornina' 'hornina' *3
    "Nijak se neliší od okolních kamenů. "

    changeGender = 'kamen:4'
    gcName = 'horniny, hornině, horninu, hornině, horninou'
    gcVocab = 'kamením/skály/skále/skálu/skálou/horniny/hornině/horninu/
        horninou'
;

/*
 *   Unthing představuje něco, co tu sice není, ale hráč by si mohl myslet, že
 *   ano, takže potřebujeme umět reagovat a vysvětlit, proč to tu není.
 */
+ Unthing 'těžební stroj' 'těžební stroj' *2
    'Těžební stroj tu už není, zbyly po něm jen trosky razícího štítu a
        vyhloubený tunel. '

    gcName = 'těžebního stroje, těžebnímu stroji, těžební stroj,
        těžebním stroji, těžebním strojem'
    gcVocab = 'těžebního těžebnímu těžebním stroje/stroji/strojem'
;

+ CustomFixture
    'trosky razicího razícího (těžebního) razicí razící štítu/štít/(stroje)'
    'trosky razicího štítu' *3
    "Trosky razicího štítu jsou těžko rozpoznatelné pod usazeným prachem a
        trochou kamení. Podle záznamů, které jsi četl dříve, se tu těžební stroj
        zadřel a uvízl. "

    /* CustomFixture reaguje společnou zprávou na vzetí, posunutí a položení. */
    cannotTakeMsg = 'To nepůjde, zbytky razícího štítu jsou zadřené v hornině
        opravdu důkladně. '

    isPlural = true
    changeGender = '!trosk:2'
    gcName = 'trosek razicího štítu, troskám razicího štítu, trosky razicího
        štítu, troskách razicího štítu, troskami razicího štítu'
    gcVocab = 'trosek troskám troskách troskami razicího razicímu razicím
        razícího razícímu razícím štítem'
;

/*
 *   Vozítko se objeví až později, takže je zatím Hidden. Také je moc těžké,
 *   abychom ho zvedali a je to vnořená lokace, ve které mohou být kapitán s
 *   velitelem.
 */
+ secondRover: Hidden, Heavy, Booth
    'vozítko vozidlo vozík podvozek/pronásledovatelů/vozítko/vozidlo/vozík/řidič'
    'vozítko pronásledovatelů' *4
    "Vozítko pronásledovatelů stejně jako to, kterým jsi přijel, vypadá trochu
        jako oko mouchy na podvozku díky složenému průzoru čele kabiny. Právě
        teď míří tvým směrem a podle zarputilého výrazu řidiče zřejmě nehodlá
        zpomalit. "

    /* Zrušíme listování postav v rámci prozkoumej vozítko */
    roomListActorPosture(actor) { }

    dobjFor(ShootAt)
    {
        verify() { }
    }
    dobjFor(Attack) remapTo(ShootAt, self, laser)

    gcName = 'vozítka pronásledovatelů, vozítku pronásledovatelů, vozítko
        pronásledovatelů, vozítku pronásledovatelů, vozítkem pronásledovatelů'
    gcVocab = 'vozítka vozítku vozítkem vozidla vozidlu vozidlem vozíku vozíkem
        vozítka/vozítku/vozítkem/vozidla/vozidlu/vozidlem/vozíku/vozíkem/
        pronásledovatelé/pronásledovatelům/pronásledovatele/pronásledovatelích/
        pronásledovately/řidiče/řidičovi/řidiči/řidičem'
    changeGender = 'pronásledovatele:5, řidič:2'
;

/* ------------------------------------------------------------------------ */
/*
 *   VOZÍTKO
 */
roverOutside: Heavy, Enterable -> suitPortOutside
    'vlastní vozítko/vozidlo/vozík' 'vozítko' *4 @tunnel
    "Vozítko vypadá trochu jako oko mouchy na komplikovaném oboustranném
        podvozku. Přední zaoblená část je sestavená z mnoha menších průzorů,
        vzadu je plošina pro dva skafandry a držáky nejrůznějšího nářadí, jeden
        ze skafandrů máš právě na sobě. Největší zvláštností vozítka je
        přizpůsobivý oboustranný podvozek umožňující trochu rychlejší pohyb v
        uzavřené chodbě navzdory beztíži. "

    /* Popis předmětu pro vypsání v rámci popisu místnosti. */
    specialDesc = "Při západním okraji šachty stojí tvé průzkumné vozítko. "
    remoteSpecialDesc(actor) { }

    /*
     *   Jsou tu dvě vozítka, tak je musíme umět rozlišit při nejistotě. Tímto
     *   názvem se hra zeptá místo běžného názvu "vozítko", když se bude ptát
     *   "A které vozítko máš na mysli? Vlastní vozítko nebo vozítko
     *   pronásledovatelů?"
     */
     disambigName = 'vlastní vozítko'
     disambigNameKohoCo = 'vlastní vozítko'

    /* Abych mohl odpovědět "vlastní vozítko". */
    owner = me

    /*
     *   O vozítku se dozvíme už dříve, než ho spatříme. Je zmíněné v
     *   rozhovorech apod. Musíme ho tedy označit za známé, abychom se na ně
     *   mohli Borise zeptat. Jinak by totiž téma nebylo přístupné.
     */
    isKnown = true

    dobjFor(ShootAt)
    {
        verify() { }
    }

    gcName = 'vozítka, vozítku, vozítko, vozítku, vozítkem'
    gcVocab = 'vlastního vlastnímu vlastním vozítka/vozítku/vozítkem/vozidla/
        vozidlu/vozidlem/vozíku/vozíkem'
;

+ Component
    'přizpůsobivý oboustranný podvozek/(vlastního)/(vozítka)' 'podvozek' *2
    "Podvozek je zkonstruovaný tak, aby se mohl opřít a vzepřít proti stropu,
        nebo stěnám, čímž zajišťuje potřebnou adhezi i ve stavu beztíže. I
        přesto se vozítko pohybuje jen rychlostí srovnatelnou s rychlostí lidské
        chůze po Zemi. "

    disambigName = 'podvozek vlastního vozítka'
    disambigNameKohoCo = 'podvozek vlastního vozítka'

    dobjFor(ShootAt) remapTo(ShootAt, roverOutside, IndirectObject)

    gcName = 'podvozku, podvozku, podvozek, podvozku, podvozkem'
    gcVocab = 'přizpůsobivého přizpůsobivému přizpůsobivém přizpůsobivým
        oboustranného oboustrannému oboustranném oboustranným podvozku/podvozek/
        podvozkem'
;

+ roverFakeDoorOutside: Decoration
    'tlakové dveře*průlezy' 'tlakové dveře' *3
    "Dveře vozítka zvenku prozrazuje jen tenká spára na jeho hladkém povrchu.
        Jsou utěsněné, odsud je nelze otevřít. "

    dobjFor(ShootAt) remapTo(ShootAt, roverOutside, IndirectObject)

    isPlural = true
    gcName = 'tlakových dveří, tlakovým dveřím, tlakové dveře,
        tlakových dveřích, tlakovými dveřmi'
    gcVocab = 'tlakových tlakovým tlakové tlakovými dveří/dveřím/dveřích/dveřmi'
;

+ roverPlatform: Platform, Component
    'plošina vozítka/plošina' 'plošina vozítka' *3
    "Zadní plošina je malý rovný prostor, kudy mohou průzkumníci opustit vozítko
        ve skafandrech. Je tu i prostor na náklad a držáky pro potřebné
        nářadí. "

    maxSingleBulk = 10000

    /*
     *   This is one additional step we need to take to ensure that an
     *   actor can actually stand on the desk.
     *
     *   By default the stagingLocations property for a NestedRoom is
     *   [location], but the location of a ComplexComponent is
     *   considered to be the ComplexContainer of which it's a part, and
     *   a ComplexContainer can't (directly) hold an actor. We therefor
     *   need to change the stagingLocation to the ComplexContainer's
     *   location (the staging location is the place at actor needs to
     *   be in order to be able to enter a particular NestedRoom).
     */
    stagingLocations = [tunnel]

    /*
     *   canReachFromInside() is a custom method defined above to
     *   determine what can be reached from within a NestedRoom. When
     *   standing on the desk the PC can also reach the bookshelf and
     *   anything on the bookshelk, so we need to override
     *   canReachFromInside() to return true when the player attempts to
     *   touch what's on the shelf (or the shelf itself).
     */
    canReachFromInside(obj, dest)
    {
        return dest == roverHolder || dest.isIn(roverHolder);
    }

    dobjFor(StandOn)
    {
        check()
        {
            if(gRevealed('replicated'))
                failCheck('Zkusil ses rozeběhnout k vozítku, ale v nízké
                    gravitaci není snadné se pohybovat rychle. Místo toho jsi
                    spíš jen lehce povyskočil a máchaje rukama zas pomalu snášel
                    dolů. ');
        }
    }
    dobjFor(ClimbUp) asDobjFor(StandOn)

    dobjFor(ShootAt) remapTo(ShootAt, roverOutside, IndirectObject)

    gcName = 'plošiny vozítka, plošině vozítka, plošinu vozítka,
        plošině vozítka, plošinou vozítka'
    gcVocab = 'plošiny plošině plošinu plošinou vozítka/plošiny/plošině/plošinu/
        plošinou'
;

++ suitPortOutside: TravelWithMessage, ThroughPassage ->suitPort
    'skafandrový průlez*průlezy' 'skafandrový průlez' *2
    "Nepoužívané skafandry jsou zavěšené zády na stěně a jejich zavíratelná
        pouzdra s podporou života slouží místo průlezu. Po oblečení skafandru se
        pouzdro uzavře a uvolní, takže je možné opustit vozítko i bez přechodové
        komory. "

    /* Když chce projít, musí stát na plošině. */
    connectorStagingLocation = roverPlatform

    travelDesc = "Opřel ses zády o stěnu kabiny, dokud zádová část skafandru
        nezapadla na své místo. Spustil jsi připojovací sekvenci, skafandr se
        utěsnil proti kabině, a pak se pomalu otevřel zadní kryt, kterým ses
        provlékl do kabiny vozítka.<<roverSuit.moveInto(nil)>>
        <<roverSuit.makeWornBy(nil)>> "

    dobjFor(TravelVia)
    {
           preCond = inherited + handsEmptyDoffSuit
    }

    /* a customized hands-empty condition for wearing the suit */
    handsEmptyDoffSuit: handsEmpty {
        failureMsg = 'To, co neseš, musíš zanechat venku, chceš-li do vozítka. '

        /*
         *   Require dropping everything except the chicken suit (we
         *   obviously wouldn't want to require dropping the suit itself,
         *   since we need to be holding it to put it on).  Include even
         *   worn items that aren't AlwaysWorn's.
         */
        requireDropping(obj)
        {
            /*
             *   We have to drop everything that we're either holding or
             *   wearing, except for the chicken suit itself and any
             *   AlwaysWorn items.
             */
            return
            (
                obj != overal && obj != tshirt && obj != roverSuit
                &&
                (
                    obj.isHeldBy(gActor)
                    || (obj.ofKind(Wearable)
                        && !obj.ofKind(AlwaysWorn)
                        && obj.isWornBy(gActor))
                )
            );
        }

        /*
         *   don't try auto-bagging anything; since we need to drop
         *   everything, including the tote bag, there's no point in trying
         *   to free up space that way
         */
        autoBag = nil
    }

    dobjFor(ShootAt) remapTo(ShootAt, roverOutside, IndirectObject)

    gcName = 'skafandrového průlezu, skafandrovému průlezu, skafandrový průlez,
        skafandrovém průlezu, skafandrovým průlezem'
    gcVocab = 'skafandrového skafandrovému skafandrovém skafandrovým průlezu/
        průlezem'
;

++ roverHolder: RestrictedContainer, Component
    'držák držáky (na) nářadí/držák/držáky' 'držáky nářadí' *2
    desc()
    {
        "Držáky bezpečně zajišťují nástroje pro astronauty průzkumníky proti
            ztrátě i poškození a zároveň dovolují snadné uvolnění nástroje i v
            neforemných rukavicích skafandrů. ";

        if(!laser.location)
            PresentLater.makePresentByKey('tools');
    }

    maxSingleBulk = 10000
    validContents = [laser, torch]
    cannotPutInMsg(obj)
    {
        gMessageParams(obj);
        return '{Kdoco obj} do držáků nepasuje, jsou určeny jen na výbavu
            průzkumníků. ';
    }
    contentsListed = nil

    /* Hovoříme o "uchycených" nástrojích. */
    descContentsLister: ContentsLister, BaseThingContentsLister
    {
        showListPrefixWide(itemCount, pov, parent, selector)
        {
            gMessageParams(parent);
            "V {komčem parent} <<selector < 4 ? 'je' : 'jsou'>> uchycen<<
                ['ý', 'á', 'é', 'í', 'é', 'á'][selector]>> ";
        }

        showListSuffixWide(itemCount, pov, parent, selector) { ". "; }

        showListItem(obj, options, pov, infoTab)
        {
            obj.showListItem(options | ListKdoCo, pov, infoTab);
        }
    }

    isPlural = true

    dobjFor(ShootAt) remapTo(ShootAt, roverOutside, IndirectObject)

    dobjFor(LookIn)
    {
        action()
        {
            /* Prohledani musi vest take k objeveni obsahu. */
            if(!laser.location)
                PresentLater.makePresentByKey('tools');

            inherited;
        }
    }
    dobjFor(Search) asDobjFor(LookIn)

    gcName = 'držáků nářadí, držákům nářadí, držáky nářadí, držácích nářadí,
        držáky nářadí'
    gcVocab = 'držáku držákem držáků držákům držácích nářadím/držáku/držákem/
        držáků/držákům/držácích'
;

+++ laser: PresentLater, RestrictedContainer 'laser*nářadí*nástroje' 'laser' *2
    "Užitečná pomůcka pro zkoumání hornin. Laser umí odpařit zacílený materiál
        a prozkoumat jeho chemické složení. Je třeba s ním zacházet opatrně,
        snadno by místo horniny mohl odpařit i něco jiného. Ze strany má
        spouštěcí tlačítko. <<if target != nil>>Míříš na
        <<target.nameKohoCo>>. "

    tooFullMsg = 'V laseru už dva akumulátory jsou, další se nevejde. '

    plKey = 'tools'
    bulk = 20
    bulkCapacity = 4
    validContents = [charged1, charged2, charged3, discharged1, discharged2,
        discharged3]
    cannotPutInMsg(obj)
    {
        gMessageParams(obj);
        return 'Laser může být napájen jen dvojicí univerzálních akumulátorů,
            {kohoco obj} do něj vložit nemůžeš. ';
    }

    /* Na co hráč namířil, mířit můžeme na kde co. */
    target = nil

    dobjFor(AimAt)
    {
        verify()
        {
            if(gIobj != nil && gIobj == self)
                illogicalSelf('Laser nemůže mířit sám na sebe. ');
            if(gIobj != nil && gIobj == me)
                illogical('Ne, sebevražedné sklony rozhodně nemáš. ');
        }
        check()
        {
            if(me.isIn(alienRoom))
                failCheck('Zde se neodvažuješ laser zkoušet, zásah něčeho
                    důležitého by mohl způsobit naprosto nepředvídatelnou
                    katastrofu, nebo přinejmenším neopravitelné poškození. ');
        }
        action()
        {
            "Pečlivě jsi zamířil na {kohoco iobj}. ";
            target = gIobj;
        }
    }

    dobjFor(TurnOn) remapTo(Push, laserButton)
    dobjFor(Push) remapTo(Push, laserButton)

    iobjFor(ShootAt)
    {
        verify()
        {
            if(gDobj != nil && gDobj == self)
                illogicalSelf('Laser nemůže mířit sám na sebe. ');
            if(gDobj != nil && gDobj == me)
                illogical('Ne, sebevražedné sklony rozhodně nemáš. ');
        }
        check()
        {
            if(me.isIn(alienRoom))
                failCheck('Zde se neodvažuješ laser zkoušet, zásah něčeho
                    důležitého by mohl způsobit naprosto nepředvídatelnou
                    katastrofu, nebo přinejmenším neopravitelné poškození. ');
        }
        action()
        {
            target = gDobj;
            nestedAction(Push, laserButton);
        }
    }

    gcName = 'laseru, laseru, laser, laseru, laserem'
    gcVocab = 'laseru/laserem*nářadím*nástrojů*nástrojům*nástrojích*nástroji'
;

++++ laserButton: Button, Component
    'červené spouštěcí tlačítko (laseru) tlačítko' 'spouštěcí tlačítko' *4
    "Velké tlačítko stisknutelné i v rukavici skafandru, je celé varovně červené
        s vedle namalovaným žlutočerným symbolem neionizujícího záření. "

    dobjFor(Push)
    {
        preCond = inherited + new ObjectPreCondition(laser, objHeld)
        check()
        {
            local charged = 0, discharged = 0;

            if(charged1.isIn(laser)) charged++;
            if(charged2.isIn(laser)) charged++;
            if(charged3.isIn(laser)) charged++;
            if(discharged1.isIn(laser)) discharged++;
            if(discharged2.isIn(laser)) discharged++;
            if(discharged3.isIn(laser)) discharged++;

            if(charged < 2)
            {
                gReveal('hint-charged');
                if(charged + discharged > 0)
                    failCheck('Zkusil jsi stisknout spouštěcí tlačítko, ale
                        laser jen zablikal varovným symbolem baterie a zas se
                        hned vypnul. ');
                else
                    failCheck('Zkusil jsi stiskout spouštěcí tlačítko laseru,
                        ale nestalo se vůbec nic. Bez akumulátorů nepracuje. ');
            }

            if(me.isIn(alienRoom))
                failCheck('Zde se neodvažuješ laser zkoušet, zásah něčeho
                    důležitého by mohl způsobit naprosto nepředvídatelnou
                    katastrofu, nebo přinejmenším neopravitelné poškození. ');

            if(laser.target == roverOutside)
                failCheck('Poškodit vlastní vozítko by byl hloupý nápad. ');

            if(laser.target == nil)
                failCheck('Nejprve bys měl laserem na něco zamířit. ');
        }
        action()
        {
            if(laser.target == secondRover || laser.target == captain
                || laser.target == commander)
            {
                "Pečlivě jsi zamířil na přijíždějící vozítko a stiskl spouštěcí
                    tlačítko laseru. Na povrchu vozítka v místě, kudy vedou
                    důležité kabely, se krátce objevil jasně žhnoucí bod a
                    reflektory vozítka pohasly, motory ztratily energii.
                    <.p>Zatímco vozítko ještě zastavuje, laser ti do sluchátek
                    ve skafandru monotónním hlasem odříkává chemické složení
                    vypařených kabelů. ";

                achievement.awardPointsOnce();
//              inputManager.pauseForMore(true);

                "<.p>A je to. Teď jsou oba ve vozítku zajištěni líp, než kdybys
                    jim dal želízka a ještě svázal provazem. Zvolna se vracíš do
                    svého vozítka a jedeš na základnu. Možná by to šlo zařídit i
                    jinak, ale nejsi si jistý, kolik lidí je do téhle špinavosti
                    zapojených. Z vozítka se přesouváš rovnou do lodi a z pilotní
                    kabiny volíš tísňové volání na VESPO. Super, policejní loď
                    je jen pár hodin letu daleko.

                    <.p>Spokojeně se uvelebuješ v křesle a rovnáš si v hlavě
                    události posledních chvil. Ten duplikátor je úžasná věc,
                    podaří se někdy zjistit jeho původ? První skutečný důkaz
                    vyspělé civilizace mimo té ze Země a ti dva v tom viděli jen
                    kšeft pro sebe. Chudák Chriss, chybělo málo a mohl jsem
                    skočit stejně. ";

#ifdef TADS_INCLUDE_NET
//                local data =
//                [
//                    'sid' -> webSession.storageSID,
//                    'event' -> 'won',
//                    'points' -> 0,
//                    'desc' -> '',
//                    'total' -> libScore.totalScore
//                ];

//                sendNetRequest(0, 'http://technoplaneta.cz/t3submit', 'POST', 0, nil,
//                    data);
#endif
                finishGameMsg(ftVictory, [ finishOptionAmusing,
                    finishOptionUndo, finishOptionCredits,
                    finishOptionAfterword, finishOptionFullScore ]);

            }
            else if(laser.target.ofKind(Decoration)
                || laser.target.ofKind(CustomFixture)
                || laser.target.ofKind(Component))
            {
                local target = laser.target;
                gMessageParams(target);

                "Pečlivě jsi zamířil na {kohoco target} a stiskl tlačítko
                    laseru. <q>Prásk,</q> ozvalo se ve vzduchoprázdnu a viděl
                    jsi, jak odletují kousíčky odpařené hmoty. Tak jo, laser
                    funguje, alespoň něco. Ale zasažení {kohočeho target} nijak
                    nepomohlo odvátit hrozící nebezpečí. ";
            }
            else
            {
                "Nazdařbůh jsi vystřelil, k ničemu to nebylo. ";
            }
        }
    }
    dobjFor(TurnOn) asDobjFor(Push)
    achievement: Achievement { +10 "záchranu svého života" }

    gcName = 'spouštěcího tlačítka, spouštěcímu tlačítku, spouštěcí tlačítko,
        spouštěcím tlačítku, spouštěcím tlačítkem'
    gcVocab = 'červeného červenému červeném červeným spouštěcího spouštěcímu
        spouštěcím tlačítka tlačítku tlačítkem tlačítka/tlačítku/tlačítkem'
;

++++ Component
    'namalovaný žlutočerný symbol/(neionizujícího)/(záření)'
    'žlutočerný symbol' *2
    "Symbol na laseru zobrazuje paprskem zasaženého člověka v dramatické póze.
        Nápis <q>nekoukej do laseru zbývajícím okem</q> je více než varující. "

    gcName = 'žlutočerného symbolu, žlutočernému symbolu, žlutočerný symbol,
        žlutočerném symbolu, žlutočerným symbolem'
    gcVocab = 'namalovaného namalovanému namalovaném namalovaným žlutočerného
        žlutočernému žlutočerném žlutočerným symbolu/symbolem'
;

class DischargedAccu: Thing
    'vybitý vybité akumulátor aku*akumulátory' 'vybitý akumulátor' *2
    "Univerzální akumulátor s velkou kapacitou používaný v mnoha přenosných
        kosmických přístrojích. Je hranatý, těžký a velký podobně jako malá
        láhev limonády. Tento je vybitý. "

    /* Všechny objekty této třídy jsou zaměnitelné. */
    isEquivalent = true
    bulk = 2

    gcName = 'vybitého akumulátoru, vybitému akumulátoru, vybitý akumulátor,
        vybitém akumulátoru, vybitým akumulátorem,
        vybité akumulátory, vybitých akumulátorů, vybitým akumulátorům, vybité
        akumulátory, vybitých akumulátorech, vybitými akumulátory'
    gcVocab = 'vybitého vybitému vybitých vybitým vybitými akumulátoru/
        akumulátorem*akumulátorů*akumulátorům*akumulátorech'
;

++++ discharged1: DischargedAccu;
++++ discharged2: DischargedAccu;

+++ torch: PresentLater, Flashlight, RestrictedContainer
    'velká výkonná přenosná svítilna*nářadí*nástroje' 'přenosná svítilna' *3
    "Toto je velká a výkonná přenosná svítilna se spoustou vychytávek pro práci
        v beztíži a vzduchoprázdnu. Napájí se univerzálním akumulátorem s velkou
        kapacitou. <<if isOn>>Je zapnutá a svítí. <<else>>Je vypnutá. "

    tooFullMsg = 'Ve svítilně už jeden akumulátor je, další se nevejde. '

    plKey = 'tools'
    brightnessOn = 4
    bulk = 20
    bulkCapacity = 2
    validContents = [charged1, charged2, charged3, discharged1, discharged2,
        discharged3]
    cannotPutInMsg(obj)
    {
        gMessageParams(obj);
        return 'Do svítilny se dají vložit jen univerzální akumulátory. ';
    }

    dobjFor(TurnOn)
    {
        check()
        {
            if(!charged1.isIn(self) && !charged2.isIn(self)
                && !charged3.isIn(self))
            {
                if(discharged1.isIn(self) || discharged2.isIn(self)
                    || discharged3.isIn(self))
                    "Kontrolka nabití akumulátoru červeně zablikala. ";
                else
                    "Vůbec nic se nestalo, patrně proto, že ve svítilně není
                        žádný akumulátor. ";

                exit;
            }
        }
    }
    
    /* Abychom byli konsistentní, jde namířit i svítilna. */
    dobjFor(AimAt)
    {
        preCond = [objTurnedOn]
        verify() {}
        action()
        {
            "<<one of>>Vrhnul jsi kužel světla na {kohoco iobj}.
                <<or>>Posvítil sis na {kohoco iobj}.<<stopping>> ";
            nestedAction(Examine, gIobj);
        }
    }

    notifyRemove(obj)
    {
        if(isOn)
        {
            "Po vyjmutí akumulátoru svítilna zhasla. ";
            makeOn(nil);
        }
    }

    gcName = 'přenosné svítilny, přenosné svítilně, přenosnou svítilnu,
        přenosné svítilně, přenosnou svítilnou'
    gcVocab = 'přenosné přenosnou svítilny/svítilně/svítilnu/svítilnou*nářadím*
	nástrojů*nástrojům*nástrojích*nástroji'
;

++++ Component 'kontrolka' 'kontrolka' *3
    "Kontrolka na svítilně je právě zhasnutá, může zablikáním signalizovat
        vybitý akumulátor, nebo trvalým svícením jinou poruchu. "

    gcName = 'kontrolky, kontrolce, kontrolku, kontrolce, kontrolkou'
    gcVocab = 'kontrolky/kontrolce/kontrolku/kontrolkou'
;

class ChargedAccu: Thing
    'nabitý nabité akumulátor aku*akumulátory' 'nabitý akumulátor' *2
    "Univerzální akumulátor s velkou kapacitou používaný v mnoha přenosných
        kosmických přístrojích. Je hranatý, těžký a velký podobně jako malá
        láhev limonády. Tento je nabitý. "

    isEquivalent = true
    bulk = 2

    gcName = 'nabitého akumulátoru, nabitému akumulátoru, nabitý akumulátor,
        nabitém akumulátoru, nabitým akumulátorem,
        nabité akumulátory, nabitých akumulátorů, nabitým akumulátorům, nabité
        akumulátory, nabitých akumulátorech, nabitými akumulátory'
    gcVocab = 'nabitého nabitému nabitých nabitým nabitými akumulátoru/
        akumulátorem*akumulátorů*akumulátorům*akumulátorech'
;

++++ charged1: ChargedAccu;

/* ------------------------------------------------------------------------ */

roverSuit: Wearable 'vesmírný skafandr/oblek' 'vesmírný skafandr' *2
    "Je to úplně obyčejný průzkumnický skafandr pro krátkodobý pobyt v otevřeném
        vesmíru. Je vybaven podporou života na několik hodin a vysílačkou s
        krátkým dosahem. Od jiných skafandrů se liší jen způsobem oblékání bez
        přechodové komory. "

    hideFromAll(action)
    {
        return action.ofKind(DoffAction) || action.ofKind(DropAction)
            || action.ofKind(PutInAction) || inherited(action);
    }

    dobjFor(Doff)
    {
        verify() { illogicalNow('To by mělo fatální důsledky, kolem není vůbec
            žádný vzduch. '); }
    }

    gcName = 'vesmírného skafandru, vesmírnému skafandru, vesmírný skafandr,
        vesmírném skafandru, vesmírným skafandrem'
    gcVocab = 'vesmírného vesmírnému vesmírném vesmírným skafandru/skafandrem/
        obleku/oblekem'
;

+ Component 'přilba/helma' 'přilba' *3
    "Důležitá součást skafandru, chrání tvou hlavu, poskytuje ti výhled okolo a
        spoustu dalších samozřejmostí. "

    gcName = 'přilby, přilbě, přilbu, přilbě, přilbou'
    gcVocab = 'přilby/přilbě/přilbu/přilbou/helmy/helmě/helmu/helmou'
;

+ Component 'vysílačka/rádio' 'vysílačka' *3
    "Vysílačka je zabudovaná v přilbě, stejně jako v každém skafandru. "

    gcName = 'vysílačky, vysílačce, vysílačku, vysílačce, vysílačkou'
    gcVocab = 'vysílačky/vysílačce/vysílačku/vysílačkou/rádia/rádiu/rádiem'
;

+ Component 'podpora života' 'podpora života' *3
    "Podpora života je nezbytná součást každého skafandru regulující teplotu,
        vlhkost, umožňující dýchání… "

    gcName = 'podpory života, podpoře života, podporu života, podpoře života,
        podporou života'
    gcVocab = 'podpory podpoře podporu podporou -'
;
