#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   PLAC POD PŘÍDÍ
 */
underShipFront: PortRoom 'Pod přídí lodě' 'pod příď'
    "Jsi v západní části servisní klece na rampě pod přední částí lodi, která
        pokračuje dál na východ pod záď lodě. Prostor nad hlavou ti zakrývá
        trup lodi, který odsud vypadá ještě mohutněji, než jaký opravdu je. "

    /* Cesta z rampy na jih si říká o podrobnější popis. */
    south: TravelMessage { -> besideAirlock "Spustil ses dolů a pomalým pádem se
        snesl na povrch asteroidu. "; }
    down asExit(south)
    east = underShipBack

    /* Příkazy sešplhej, sestup, slez, pryč, ven,... */
    dobjFor(ClimbDown) remapTo(TravelVia, south)
    dobjFor(GetOffOf) remapTo(TravelVia, south)
    dobjFor(GetOutOf) remapTo(TravelVia, south)

    gender = 3
    vocabWords = 'servisní klec/rampa'
    name = 'rampa'
    gcName = 'rampy, rampě, rampu, rampě, rampou'
    gcVocab = 'klece/kleci/klecí/rampy/rampě/rampu/rampou'
;

/* Kdyby hráč bloudil, tak mu trochu napovíme. */
+ Distant 'záď zadní část lodi' 'záď lodi' *2
    "Záď lodi je odsud kousek cesty na východ. "

    gcName = 'zádi lodi, zádi lodi, záď lodi, zádi lodi, zádí lodi'
    gcVocab = 'zádi zádí části částí -'
;

+ hull: RestrictedContainer, Fixture
    'trup povrch lodi/příď/kompozit' 'trup lodi' *2
    "Trup lodi vypadá bachratě a neforemně, odsud je ale vidět jen malá část
        povrchu z vrstveného kompozitu, pod nímž se skrývá mnoho dalších vrstev.
        Objevil jsi mnoho různých modulů. "

    /*
     *   Moduly navigace jsou zasunuté v trupu, proto je trup kontejnerem.
     *   RestrictedContainer omezuje, co v něm může být pomocí validContents.
     */
    maxSingleBulk = 10000
    validContents = [firstModule, secondModule]
    cannotPutInMsg(obj)
    {
        return 'Do trupu lodi se dají zasouvat jen moduly k tomu určené. ';
    }

    iobjFor(PutIn)
    {
        /*
         *   Když hráč zadá "zasuň modul", má ho zasunout do lodi. Ale TADS by
         *   preferoval různé kontejnery, které má hráč u sebe, jako pouzdro na
         *   nářadí nebo odpadkový pytel. Proto trup lodi naboostujeme.
         *   Minimálně se pak zeptá a nebude dělat nesmysly.
         */
        verify()
        {
            if(validContents.indexOf(gDobj) != nil)
                logicalRank(300, 'valid');
        }
        action()
        {
            "Zasunul jsi modul na své místo v trupu lodě a pečlivě ho zajistil
                proti vysunutí. ";

            if(gDobj == secondModule && fixedComponents.isIn(secondModule))
            {
                if(firstModule.isIn(self))
                {
                    "A je to! Můžeme letět. ";

                    gReveal('ship-fixed');
                    achievement.awardPointsOnce();
                }
                else
                    "Tak a je opraveno, ještě vrátit přijímací modul a bude
                        hotovo. ";
            }

            if(gDobj == firstModule)
            {
                if(secondModule.isIn(self) && fixedComponents.isIn(secondModule))
                {
                    "A je to! Můžeme letět. ";

                    gReveal('ship-fixed');
                    achievement.awardPointsOnce();
                }
                else
                {
                    if(secondModule.moved)
                        "Tak, přijímací modul je v cajku. Teď ještě pořešit ten
                            druhý. ";
                    else
                        "Tak, přijímací modul je v cajku. Teď ještě vytáhnout
                            ten druhý. ";
                }
            }

            inherited;
        }
    }
    achievement: Achievement { +2 "opravení lodi" }

    gcName = 'trupu lodi, trupu lodi, trup lodi, trupu lodi, trupem lodi'
    gcVocab = 'trupu trupem povrchu povrchem lodě/lodi/přídě/přídi/přídí/
        kompozitu/kompozitem'
;

/*
 *   ComponentDeferrer je třída, která když vidí, že hráč zadal takový příkaz,
 *   že by se hra musela ptát, zda má hráč na mysli ji (loď) či její location,
 *   tj. v tomto případě trup lodi, tak sama sebe potlačí, protože předpokládá,
 *   že hráč má na mysli spíš hlavní objekt, než jeho komponentu. Používá se u
 *   komponent s podobným slovníkem, jako má hlavní objekt.
 */
++ ComponentDeferrer, Heavy, Component
    'ukotvená vesmírná vesmírné kosmická kosmické loď/konzerva/plavidlo'
    'vesmírná loď' *3
    "Ze svého místa vidíš z lodi jen malou část trupu, který je tak blízko, že
        si na něj můžeš sáhnout. "

    /* Příkaz "vyndej z lodi" přesměrujeme na "vyndej z trupu". */
    iobjFor(TakeFrom) remapTo(TakeFrom, DirectObject, hull)

    gcName = 'vesmírné lodi, vesmírné lodi, vesmírnou loď, vesmírné lodi,
        vesmírnou lodí'
    gcVocab = 'ukotvené ukotvenou vesmírné vesmírnou vesmírného vesmírnému
        vesmírném vesmírným lodi/lodí/konzervy/konzervě/konzervu/konzervou/
        plavidla/plavidlu/plavidlem'
;

/* ------------------------------------------------------------------------ */

++ firstModule: TestGearAttachable, Thing
    'přijímací radarový modul radaru/modul*moduly (radaru)'
    'přijímací modul radaru' *2
    "<<if location == hull>>Čelo modulu, ohraničené téměř neznatelnou spárou, je
        prakticky součástí povrchu lodi. Přítomnost modulu prozrazují jen madla
        k jeho vytažení.

        <<else>>Modul je z větší části uzavřený ve stínicím plechu, jen na zadní
        straně z krytu vykukuje podlouhlý konektor. "

    /* Aby se nevešel do mikrovlnky. */
    bulk = 20

    /* V dotazech "a co tím máš na mysli" neopakujeme "radaru". */
    disambigName = 'přijímací modul'
    disambigNameKohoCo = 'přijímací modul'

    /* Modul je připojitelný jen k UniDiPu, k ničemu jinému. */
    wrongAttachmentMsg = 'Nem{ůž[eš]|ohl[a] [jsi]} {ho/ji dobj} připojit
        {k/ke iobj} {komučemu iobj}, konektory nejsou kompatibilní. '

    iobjFor(PutOn) asIobjFor(PutIn)
    dobjFor(Pull) maybeRemapTo(isIn(hull), Take, self)
    dobjFor(Move) maybeRemapTo(isIn(hull), Take, self)
    dobjFor(Take)
    {
        action()
        {
            if(isIn(hull)) "Uvolnil jsi páčku zajišťující modul a vyjmul ho
                z trupu lodě. ";

            /*
             *   V okamžiku, kdy hráč první modul  vyndá, tak kapitán s
             *   velitelem odejdou z kajuty, aby je hráč později přistihl
             *   manipulovat s podezřelou bednou.
             */
            if(!moved)
            {
                captain.moveIntoForTravel(nil);
                commander.moveIntoForTravel(nil);
            }

            achievement1.awardPointsOnce();

            inherited;
        }
    }
    achievement1: Achievement { +1 "vyjmutí přijímacího modulu z lodi" }
    achievement2: Achievement { +1 "zjištění, že přijímací modul je v pořádku" }

    /* Otestování UniDiPem. */
    probeCount = 0
    probeWithUnidip()
    {
        "<.p>Přístroj chvilí bzučel a poblikával kontrolkami.

            <.p>Pak se na obrazovce začal objevovat dlouhý výpis provedených
            testů, všechny zakončené zářivě zeleným OK.

            <.p>Nakonec se zobrazil nápis <q>vše v pořádku, závada
            nenalezena</q>. ";

        if(++probeCount == 1) "<.p><q>Kruci, to je divné,</q> zabručel jsi,
            <q>že bych vytáh jinej modul?</q> ";
        else "<.p><q>Hmm, zase v pořádku. Asi vážně musím hledat závadu
            jinde.</q> ";

        /*
         *   Při otestování hráč zjistí, že je modul v pořádku. To ho přiměje
         *   jít neplánovaně ven znovu a dříve, než kapitán s velitelem čekali.
         *   V ten okamžit tedy zviditelníme druhý modul v trupu.
         */
        if(!gRevealed('module1-ok'))
        {
            gReveal('module1-ok');
            secondModule.makePresent();
            secondModule.moved = nil;
    
            clock.eventReached();
            achievement2.awardPointsOnce();
        }
    }
    clock: ClockEvent { eventTime = [2, 8, 31] }

    /*
     *   Kdyby hráči měli tendenci použít příkaz "oprav", musíme jim vysvětlit,
     *   co se od nich očekává.
     */
    dobjFor(Repair)
    {
        action()
        {
            "<<if !gRevealed('module1-ok')>>Jenže jak na to? Asi by to chtělo
                nejdříve zjistit, co je s modulem v nepořádku.
                <<else>>Vždyť jsi přeci zjistil, že tento modul je naprosto
                v pořádku. ";
        }
    }

    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tablet na modul, na displeji tabletu se objevilo:
                <.p><blockquote><tt>Identifikuji… přijímací modul navigace,
                vyrobeno v TechnoUniverse Corporation.</tt></blockquote> ";
        }
    }

    gcName = 'přijímacího modulu radaru, přijímacímu modulu radaru, přijímací
        modul radaru, přijímacím modulu radaru, přijímacím modulem radaru'
    gcVocab = 'přijímacího přijímacímu přijímacím radarového radarovým radarovém
        modulu modulem modulu/modulem*modulů*modulům*modulech'
;

+++ Component
    'stínicí stínící kovový plech/kryt/(přijímacího)/(modulu)' 'kovový kryt' *2
    "Kovový kryt vypadá nerozebiratelně. "

    cannotOpenMsg = 'Modul není potřeba otevírat, součástky jsou přístupné z
        venku. Kovový kryt tvoří spíše kostru než obal modulu. '

    disambigName = 'kryt přijímacího modulu'
    disambigNameKohoCo = 'kryt přijímacího modulu'

    iobjFor(AimAt) remapTo(AimAt, DirectObject, location)

    gcName = 'kovového krytu, kovovému krytu, kovový kryt, kovovém krytu,
        kovovým krytem'
    gcVocab = 'stínicího stínicímu stínicím stínícího stínícímu stínícím
        kovového kovovému kovovém kovovým plechu/plechem/krytu/krytem'
;

+++ ComponentDeferrer, PluggableComponent
    'podlouhlý malé konektor kontakty přijímacího modulu -*konektory'
    'konektor přijímacího modulu' *2
    "Není na něm nic zvlášního, je to úplně obyčejný podlouhlý konektor s mnoha
        malými konktakty na malé elektrické proudy. "

    disambigName = 'konektor přijímacího modulu'
    disambigNameKohoCo = 'konektor přijímacího modulu'

    iobjFor(AimAt) remapTo(AimAt, DirectObject, location)

    changeGender = 'kontakt:5'
    gcName = 'konektoru přijímacího modulu, konektoru přijímacího modulu,
        konektor přijímacího modulu, konektoru přijímacího modulu,
        konektorem přijímacího modulu'
    gcVocab = 'podlouhlého podlouhlému podlouhlém podlouhlým malých malým malými
        konektoru konektorem kontaktů kontaktům kontaktech'
;

+++ Component 'madlo madla (přijímacího) (modulu) madlo/madla' 'madla' *4
    "Umožňují vytažení modulu z trupu lodi i v neobratných rukavicích 
        skafandru."

    dobjFor(Take) asDobjFor(Pull)
    dobjFor(Pull) remapTo(Pull, location)

    iobjFor(AimAt) remapTo(AimAt, DirectObject, location)

    disambigName = 'madla přijímacího modulu'
    disambigNameKohoCo = 'madla přijímacího modulu'

    isPlural = true
    gcName = 'madel, madlům, madla, madlech, madly'
    gcVocab = 'madlu/madly/madel/madlům/madlech'
;

/* ------------------------------------------------------------------------ */

++ secondModule: TestGearAttachable, PresentLater, RestrictedContainer
    'vysílací výkonový radarový modul radaru/modul*moduly (radaru)'
    'vysílací modul radaru' *2

    /* Větvení popisku je trochu složitější, tak ho zadáme jako metodu. */
    desc()
    {
        if(location == hull)
        {
            "Čelo modulu, ohraničené témeř neznatelnou spárou, je prakticky
                součástí povrchu lodi. Přítomnost modulu prozrazují jen madla
                k jeho vytažení. ";
        }
        else
        {
            "Modul je z větší části uzavřený ve stínicím plechu, pouze na jednom
                boku ";

            if(fixedComponents.isIn(self))
                "je několik nových VIZ-54 v paticích ";
            else if(!brokenComponents.isIn(self))
                "je několik prázdných patic, kde byly zesilovače VIZ-54 ";
            else
                "vykukuje několik součástek přístupných samostatně ";

            "a ze zadní stěny čouhá kombinovaný konektor spolu s ventily
                chladicího systému. ";

            if(brokenComponents.discovered && brokenComponents.isIn(self))
                "Součástky se opravdu zdají být poškozené i na pohled. ";
        }
    }

    /* Aby nešel dát do mikrovlnky. */
    bulk = 20
    disambigName = 'vysílací modul'
    disambigNameKohoCo = 'vysílací modul'

    wrongAttachmentMsg =
        'Nem{ůž[eš]|ohl[a] [jsi]} {ho/ji dobj} připojit {k/ke iobj}
            {komučemu iobj}, konektory nejsou kompatibilní. '
    cannotOpenMsg = 'Modul není potřeba otevírat, součástky jsou přístupné z
        venku. Kovový kryt tvoří spíše kostru než obal modulu. '

    /* Místo toho máme dovětky výše. */
    contentsListedInExamine = nil

    /* Je to RestrictedContainer, aby do něj pasovaly jen součástky. */
    validContents = [ brokenComponents, fixedComponents ]
    cannotPutInMsg(obj)
    {
        return 'Do modulu nemá smysl vkládat nic jiného než součástky, které
            tam patří. ';
    }
    
    iobjFor(PutOn) asIobjFor(PutIn)
    iobjFor(AttachTo) maybeRemapTo(gDobj == fixedComponents, PutIn, gDobj, self)

    dobjFor(Pull) asDobjFor(Take)
    dobjFor(Take)
    {
        action()
        {
            if(isIn(hull)) "Uvolnil jsi páčku zajišťující modul a vyjmul ho
                z trupu lodě. ";

            if(!moved) "<.p><q>Hmm, to sem taky mohl vědět rovnou, že když
                vypadlo topení, porucha bude spíš ve výkonovém vysílači a ne
                v mikroelektronice přijímače pracující s malým napětím.</q>
                zahudroval jsi uvnitř skafandru. ";

            achievement1.awardPointsOnce();

            inherited;
        }
    }
    achievement1: Achievement { +1 "vyjmutí vysílacího modulu z lodi" }
    achievement2: Achievement { +1 "nalezení vadných součástek" }

    probeWithUnidip()
    {
        if(brokenComponents.isIn(self))
        {
            "<.p>Prozkoumal jsi diagnostickým přístrojem vadný modul z kosmické
                lodi.

                <.p>Přístroj chvíli bzučel, poblikával některými signálkami, až
                se nakonec odmlčel.

                <.p>Na displeji se zobrazuje pouze točící se duhový pentagram.

                <.p>Pak pípnul.

                <.p>Zase se odmlčel. Tentokrát déle.

                <.p>Už už to vypadalo, že nadobro a chystal ses použít
                    univerzální opravný postup (reset).

                <.p>Sotva ses přiblížil k resetovacímu tlačítku, tak přístroj
                    opět pípnul.

                <.p>Cvaklo v něm.

                <.p>Pak znovu.

                <.p>A konečně se na jeho displeji zobrazil vesele zelený nápis
                <q>Diagnostika dokončena úspěšně. Závada nalezena.</q> a pod tím
                vypsal seznam vadných součástek.

                <.p>Nyní můžeš vadné součástky z modulu vyjmout. ";

            /* Objekt tempComponents jsou součástky před otestováním. */
            if(tempComponents.location)
            {
                tempComponents.moveInto(nil);
                brokenComponents.discover();

                /*
                 *   Kapitán s velitelem už bednu odklidili a tak se zase vrátí
                 *   do kajuty, aby s nimi mohl hráč mluvit.
                 */
                captain.moveIntoForTravel(commandersRoom);
                commander.moveIntoForTravel(commandersRoom);

                clock.eventReached();
                achievement2.awardPointsOnce();
            }
        }
        if(!fixedComponents.isIn(self) && !brokenComponents.isIn(self))
        {
            "UniDiP chvíli zběsile blikal signálkami, párkrát pípnul a nakonec,
                stejně jako při prvním testu modulu, vypsal seznam vadných
                součástek. Zdá se, že to jsou přesně ty součástky, co jsi z
                modulu vytáhl. UniDiP zřejmě neumí rozlišit chybějící součástky
                od zcela vadných. ";
        }
        if(fixedComponents.isIn(self))
        {
            "UniDiP chvíli bzučel a poblikával kontrolkami, párkrát pípnul, zas
                zablikal… Trvalo to docela dlouho, postupně vypisoval
                zkontrolované části, každý řádek zakončený zeleným ok. Až úplně
                nakonec zobrazil prosté: <q>OK, nalezených závad 0.</q> ";
        }
    }
    clock: ClockEvent { eventTime = [2, 9, 24] }

    /* Pokud by hráč zadal příkaz "oprav", musíme mu trochu poradit. */
    dobjFor(Repair)
    {
        action()
        {
            if(brokenComponents.isIn(self))
            {
                if(tempComponents.location)
                {
                    "Přemýšlíš, jak to uděláš. Asi by to nejprve chtělo zjistit,
                        jakou má modul závadu. ";
                }
                else
                {
                    "Přemýšlíš, jak to uděláš. Asi bys mohl vyjmout vadné
                        součástky z modulu a něco s nimi udělat. ";
                }
            }
            if(!fixedComponents.isIn(self) && !brokenComponents.isIn(self))
            {
                "Přemýšlíš, jak to uděláš. Asi nezbyde nic jeného, než nějakým
                    způsobem získat či opravit součástky na výměnu. ";
            }
            if(fixedComponents.isIn(self))
            {
                "Modul už je opravený. ";
            }
        }
    }

    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tablet na modul, na displeji tabletu se objevilo:
                <.p><blockquote><tt>Identifikuji… výkonový modul navigace,
                vyrobeno v TechnoUniverse Corporation.</tt></blockquote> ";
        }
    }

    gcName = 'vysílacího modulu radaru, vysílacímu modulu radaru, vysílací
        modul radaru, vysílacím modulu radaru, vysílacím modulem radaru'
    gcVocab = 'vysílacího vysílacímu vysílacím výkonového výkonovému výkonovém
        výkonovým radarového radarovým radarovém modulu modulem modulu/modulem*
        modulů*modulům*modulech'
;

+++ Component
    'stínicí stínící kovový plech/kryt/(vysílacího)/(modulu)' 'kovový kryt' *2
    "Kovový kryt vypadá nerozebiratelně. "

    cannotOpenMsg = 'Modul není potřeba otevírat, součástky jsou přístupné z
        venku. Kovový kryt tvoří spíše kostru než obal modulu. '

    disambigName = 'kryt vysílacího modulu'
    disambigNameKohoCo = 'kryt vysílacího modulu'

    gcName = 'kovového krytu, kovovému krytu, kovový kryt, kovovém krytu,
        kovovým krytem'
    gcVocab = 'stínicího stínicímu stínicím stínícího stínícímu stínícím
        kovového kovovému kovovém kovovým plechu/plechem/krytu/krytem'
;

+++ ComponentDeferrer, PluggableComponent
    'kombinovaný masivní konektor kontakty vysílacího modulu -*konektory' 'konektor' *2
    "Není nijak zvláštní, je to kombinovaný konektor s několika malými kontakty
        na malé elektrické proudy a o kousek dál s několika masivními kontakty
        na veliké proudy, které vysílacím modulem protékají. "

    disambigName = 'konektor vysílacího modulu'
    disambigNameKohoCo = 'konektor vysílacího modulu'

    changeGender = 'kontakt:5'
    gcName = 'konektoru vysílacího modulu, konektoru vysílacího modulu,
        konektor vysílacího modulu, konektoru vysílacího modulu,
        konektorem vysílacího modulu'
    gcVocab = 'podlouhlého podlouhlému podlouhlém podlouhlým masivních masivním
        masivními konektoru konektorem kontaktů kontaktům kontaktech'
;

+++ ComponentDeferrer, Component
    'ventil ventily chladicího (systému)/(modulu)'
    'ventily chladicího systému' *2
    "Ventily slouží k připojení modulu na chladící okruh lodi. U výkonových
        součástek je občas potřeba teplo odvádět lépe než jen kovovým krytem a
        ventilátor by ve vakuu nepomohl. "

    isPlural = true
    gcName = 'ventilů chladicího systému, ventilům chladicího systému,
        ventily chladicího systému, ventilech chladicího systému,
        ventily chladicího systému'
    gcVocab = 'ventilu ventilem ventilů ventilům ventilech -'
;

+++ Component 'madlo madla (vysílacího) (modulu) madlo/madla' 'madla' *4
    "Umožňují vytažení modulu z trupu lodi i v neobratných rukavicích
        skafandru."

    dobjFor(Take) asDobjFor(Pull)
    dobjFor(Pull) remapTo(Pull, location)

    disambigName = 'madla vysílacího modulu'
    disambigNameKohoCo = 'madla vysílacího modulu'

    isPlural = true
    gcName = 'madel, madlům, madla, madlech, madly'
    gcVocab = 'madlu/madly/madel/madlům/madlech'
;

+++ sockets: Component 'odolné patice' 'patice' *3
    desc()
    {
        if(!brokenComponents.discovered)
            "V paticích jsou to různé větší součástky, ale dokud modul
                neotestuješ, tak nebudeš vědět, zda některá z nich není
                vadná. ";
        else if(fixedComponents.isIn(self))
            "Odolné patice s opravenými součástkami VIZ-54. ";
        else if(brokenComponents.isIn(self))
            "Odolné patice s porouchanými součástkami VIZ-54. ";
        else
            "Odolné patice pro VIZ-54, ale teď v nich součástky nejsou. ";
    }

    contentsListedInExamine = nil

    iobjFor(PutIn) remapTo(PutIn, DirectObject, location)
    iobjFor(PutOn) remapTo(PutIn, DirectObject, location)
    iobjFor(TakeFrom) remapTo(TakeFrom, DirectObject, location)
    iobjFor(DetachFrom) remapTo(TakeFrom, DirectObject, location)

    isPlural = true
    gcName = 'patic, paticím, patice, paticích, paticemi'
    gcVocab = 'odolných odolným odolnými patic/paticím/paticích/paticemi'
;

/* Dokud hráč modul nediagnostikuje, jsou v paticích tyto součástky. */
++++ tempComponents: Decoration
    'součástky' 'součástky' *3
    "Jsou to různé větší součástky zasazené v paticích, ale dokud modul
        neotestuješ, tak nebudeš vědět, zda některá z nich není vadná. "

    /*
     *   Použili jsme Decoration, tak musíme přizpůsobit zprávu. Standardní
     *   zpráva "nejsou důležité" by nedávala smysl.
     */
    notImportantMsg = 'To opravdu není dobrý nápad, nejprve by bylo dobré najít
        závadu. '

    isPlural = true
    changeGender = 'součástku:3'
    gcName = 'součástek, součástkám, součástky, součástkách, součástkami'
    gcVocab = 'součástek/součástkám/součástkách/součástkami/součástce/
        součástku/součástkou'
;

/* Jakmile hráč modul otestuje, součástky vyměníme za porouchané. */
++++ brokenComponents: TestGearAttachable, Hidden
    'porouchané vadné rozbité zesilovače součástky/součástka/VIZ-54/VIZ54/VIZ/
        pouzdra*součástky*součástek*součástkám*součástkách*součástkami'
        'porouchané součástky' *3
    "Jsou to tři výkonové integrované zesilovače VIZ-54 v keramicko--kovovém
        pouzdře s otvorem na přišroubování k chladiči. Mají podezřele ožehnutá
        pouzdra. "

    probeWithUnidip()
    {
        "<.p>Připojil jsi vadné součástky k UniDiPu. Po chvilce analyzování
            UniDiP ohlásil, že jsou vadné. ";
    }

    /*
     *   Objekt componentsGroup zastupuje součástky, když je hráč prozkoumá
     *   příkazem v plurálu a má vadné i novou. Objekt componentsListGroup
     *   řídí výpis v inventáři, kdy je použito společné označení a v závorce
     *   upřesněno.
     */
    collectiveGroups = [componentsGroup]
    listWith = [componentsListGroup]

    dobjFor(Pull) asDobjFor(Take)
    dobjFor(Remove) asDobjFor(Take)
    dobjFor(DetachFrom) remapTo(Take, self)
    dobjFor(Detach) asDobjFor(Take)
    dobjFor(Unplug) asDobjFor(Take)

    isPlural = true
    gcName = 'porouchaných součástek, porouchaným součástkám, porouchané
        součástky, porouchaných součástkách, porouchanými součástkami'
    gcVocab = 'porouchaných porouchaným porouchanými vadných vadným vadnými
        rozbitých rozbitým rozbitými zesilovačů zesilovačům zesilovačích
        zesilovači součástek/součástkám/součástkách/součástkami/součástce/
        součástku/součástkou/pouzder/pouzdrům/pouzdrech/pouzdry'
;
