#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   PLAC POD ZÁDÍ
 */
underShipBack: PortRoom 'Pod zádí lodě' 'pod záď'
    "Jsi ve východní části servisní klece na rampě pod zadní částí lodi, která
        pokračuje dál na západ pod příď lodě. Prostor nad hlavou ti zakrývá trup
        lodi, který odsud vypadá ještě mohutněji, než jaký opravdu je. "

    /* Cesta z rampy na jih si říká o podrobnější popis. */
    south: TravelMessage { -> besideAirlock "Spustil ses dolů a pomalým pádem se
        snesl na povrch asteroidu. "; }
    down asExit(south)
    west = underShipFront

    /* Příkazy sešplhej, sestup, slez, pryč, ven,... */
    dobjFor(ClimbDown) remapTo(TravelVia, south)
    dobjFor(GetOffOf) remapTo(TravelVia, south)
    dobjFor(GetOutOf) remapTo(TravelVia, south)

    gender = 3
    vocabWords = 'servisní klec/rampa'
    name = 'rampa'
    gcName = 'rampy, rampě, rampu, rampě, rampou'
    gcVocab = 'klece/kleci/klecí/rampy/rampě/rampu/rampou'
;

/* Kdyby hráč bloudil, tak mu trochu napovíme. */
+ Distant 'příď přední část lodi' 'příď lodi' *2
    "Příď lodi je odsud kousek cesty na západ. "

    gcName = 'přídi lodi, přídi lodi, příď lodi, přídi lodi, přídí lodi'
    gcVocab = 'přídi přídí části částí -'
;

+ RestrictedContainer, Fixture
    'trup povrch lodi/záď/kompozit' 'trup lodi' *2

    /* unless je negovaný if. */
    "Trup lodi vypadá bachratě a neforemně, odsud je ale vidět jen malá část
        povrchu z vrstveného kompozitu, pod nímž se skrývá mnoho dalších vrstev.
        <<unless underShipFront.visited>>K přídi zbývá ještě kousek cesty na západ. "

    /* Kdyby hráč bloudil, trochu mu napovíme. */
    maxSingleBulk = 10000
    validContents = []
    cannotPutInMsg(obj)
    {
        if(obj == firstModule || obj == secondModule)
        {
            gMessageParams(obj);
            return 'Tady v zadní části trupu lodi žádné místo pro zasunutí
                modulů není. Musíš jít k přídi. ';
        }
        else return inherited(obj);
    }

    gcName = 'trupu lodi, trupu lodi, trup lodi, trupu lodi, trupem lodi'
    gcVocab = 'trupu trupem povrchu povrchem lodě/lodi/zádi/zádí/kompozitu/
        kompozitem'
;

++ ComponentDeferrer, Heavy, Component
    'ukotvená vesmírná vesmírné kosmická kosmické loď/konzerva/plavidlo'
    'vesmírná loď' *3
    "Ze svého místa vidíš z lodi jen malou část trupu, který je tak blízko, že
        si na něj můžeš sáhnout. "

    gcName = 'vesmírné lodi, vesmírné lodi, vesmírnou loď, vesmírné lodi,
        vesmírnou lodí'
    gcVocab = 'ukotvené ukotvenou vesmírné vesmírnou vesmírného vesmírnému
        vesmírném vesmírným lodi/lodí/konzervy/konzervě/konzervu/konzervou/
        plavidla/plavidlu/plavidlem'
;
