#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   TVOJE KÓJE
 */
ycFloor: Floor 'podlaha/panel/polyuretan/zem' 'podlaha' *3
    "Podlahu kóje kryje měkký, zvuky tlumící polyuretan. "

    /* Na koho/co podlahu. */
    objIntoCase = 4

    dobjFor(LieOn)
    {
        check() { failCheck('Zkusil ses zkroutit do malého půdorysu kóje, ale
            není tu dost místa, abys mohl ležet. '); }
    }

    changeGender = 'polyuretan:2, panel:2'
    gcName = 'podlahy, podlaze, podlahu, podlaze, podlahou'
    gcVocab = 'podlahy/podlaze/podlahu/podlahou/panelu/panelem/polyuretanu/
        polyuretanem/země/zemi/zemí'
;

ycCeiling: RoomPart 'strop' 'strop' *2
    "Ve stropě jsou přihrádky pro osobní věci s malým osvětlením. "

    gcName = 'stropu, stropu, strop, stropu, stropem'
    gcVocab = 'stropu/stropem'
;

ycStarboardWall: DefaultWall
    'pravá zeď/přepážka/stěna*zdi*přepážky*stěny' 'pravá stěna' *3
    "Tuto stěnu tvoří neprůhledný zvukotěsný kryt, kterým lze vyjít ven. "

    gcName = 'pravé stěny, pravé stěně, pravou stěnu, pravé stěně,
        pravou stěnou'
    gcVocab = 'pravé pravou zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/
        stěně/stěnu/stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*
        stěn*stěnám*stěnách*stěnami'
;

ycForeWall: DefaultWall
    'přední zeď/přepážka/stěna*zdi*přepážky*stěny' 'přední stěna' *3
    "Stěnu pokrývá karimatce podobný měkký plast, na kterém je pomocí popruhů a
        suchých zipů připevněný spacák. "

    gcName = 'přední stěny, přední stěně, přední stěnu, přední stěně,
        přední stěnou'
    gcVocab = 'zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/stěně/stěnu/
        stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*stěn*stěnám*
        stěnách*stěnami'
;

ycAftWall: DefaultWall
    'zadní zeď/přepážka/stěna*zdi*přepážky*stěny' 'zadní stěna' *3
    "Na plastu pokrývajícím stěnu visí síťová kapsa na oblečení a podobné
        drobnosti. "

    gcName = 'zadní stěny, zadní stěně, zadní stěnu, zadní stěně, zadní stěnou'
    gcVocab = 'zdi/zdí/přepážky/přepážce/přepážku/přepážkou/stěny/stěně/stěnu/
        stěnou*zdí*zdím*přepážek*přepážkám*přepážkách*přepážkami*stěn*stěnám*
        stěnách*stěnami'
;

/* Bylo by divné, kdyby konektor úplně chyběl, dokud se neoblékne. */
ycFakeDoor: FakeConnector
    "<<if !tshirt.isWornBy(me) || !overal.isWornBy(me)>>Nemůžeš pobíhat po lodi
        nahý, kapitán by se mohl vyděsit. <<else>>Nemůžeš po lodi poletovat
        bosý, co kdyby sis nakopl palec? "
;

yourCabin: ShipboardRoom 'Tvoje kóje' 'do své kóje'
    "Jsi ve své kóji. Prostoru tu není mnoho -- tak akorát, aby se sem vešel
        jeden spící člověk a mohl napůl natáhnout ruce do stran. Nad hlavou máš
        dvě velké přihrádky pro osobní věci.
        <<if !overal.moved || !tshirt.moved || !shoes.moved>>Ve velké síťové
        kapse máš hromádku nezbytného ošacení.<<end>>
        <<if !me.isIn(ycSleepingBag)>>Na stěně je zavěšený spacák vhodný pro
        spaní v beztíži.<<end>> Můžeš odsud vylézt ven. "

    starboard = tshirt.isWornBy(me) && shoes.isWornBy(me) && overal.isWornBy(me)
        ? ycDoor : ycFakeDoor
    out: UnlistedProxyConnector
    {
        primaryConn()
        {
            return tshirt.isWornBy(me) && shoes.isWornBy(me)
                && overal.isWornBy(me) ? ycDoor : ycFakeDoor;
        }
    }

    roomParts = static inherited
        - shipFloor + ycFloor
        - shipCeiling + ycCeiling
        - starboardWall + ycStarboardWall
        - foreWall + ycForeWall
        - aftWall + ycAftWall

    vocabWords = 'moje kóje'
    gcVocab = 'mé mou mojí moji své svou kóji/kójí'
    gcName = 'mojí kóje, mojí kóji, mou kóji, mé kóji, mou kójí'
    gender = 3
;

+ ycDoor: Door 'kryt kóje' 'kryt kóje' *2
    "Kryt kóje zakrývá vstup do tvého soukromého prostoru, je lehký a je pokrytý
        hmotou dobře tlumící zvuk. "

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    canTravelerPass(traveler)
    {
        return tshirt.isWornBy(me) && shoes.isWornBy(me) && overal.isWornBy(me);
    }

    explainTravelBarrier(traveler)
    {
        makeOpen(nil);
        gTranscript.clearReports();

        "<<if !tshirt.isWornBy(me) || !overal.isWornBy(me)>>Nemůžeš pobíhat po
            lodi nahý, kapitán by se mohl vyděsit. <<else>>Nemůžeš po lodi
            poletovat bosý, co kdyby sis nakopl palec? ";
    }

    gcName = 'krytu kóje, krytu kóje, kryt kóje, krytu kóje, krytem kóje'
    gcVocab = 'krytu krytem -'
;

+ ycSleepingBag: Booth, Fixture 'spacák/postel' 'spacák' *2
    "Vesmírný spacák nabízí astronautovi nejen dostatečné pohodlí během
        odpočinku, ale především ho bezpečně přidržuje na místě u stěny kajuty,
        aby ve spánku nepoletoval. "

    maxSingleBulk = 10000

    /* Protože je v beztíži, "visí" ve spacáku. */
    allowedPostures = [hanging]
    obviousPostures = [hanging]
    defaultPosture = hanging

    /* Zarizuje mj. i to, ze budou veci mimo spacak zahrnuty do vem vse. */
    getDropDestination(obj, path) { return location; }

    changeGender = 'postel:3'

    objInPrep = 'v'
    objIntoPrep = 'do'
    objIntoCase = 2
    objOutOfPrep = 'ze'

    dobjFor(Enter)
    {
        action()
        {
            "Nasoukal ses do spacáku. ";
            inherited;
        }
    }
    dobjFor(LieOn) asDobjFor(Enter)

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'spacáku, spacáku, spacák, spacáku, spacákem'
    gcVocab = 'spacáku/spacákem'
;

+ Container, Fixture 'velká síťová kapsa/síťka' 'velká síťová kapsa' *3
    "Kapsa sešitá z nylonové síťky určená k uložení ošacení i jiných předmětů. "

    maxSingleBulk = 10000
    bulkCapacity = 22

    contentsLister: ContentsLister, BaseThingContentsLister
    {
        showListPrefixWide(itemCount, pov, parent, selector)
        {
            if(parent && gAction) gMessageParams(parent);

            "Ve velké síťové kapse <<selector < 4 ? 'je' : 'jsou'>>
                nacpan<<['ý', 'á', 'é', 'í', 'é', 'á'][selector]>> ";
        }
        showListSuffixWide(itemCount, pov, parent, selector)
            { ".<<extraHintManager.hintDaemon()>> "; }
    }

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'velké síťové kapsy, velké síťové kapse, velkou síťovou kapsu,
        velké síťové kapse, velkou síťovou kapsou'
    gcVocab = 'velké velkou síťové síťovou kapsy/kapse/kapsu/kapsou/síťky/síťce/
        síťku/síťkou'
;

class MyClothes: Wearable
    dobjFor(Wear)
    {
        action()
        {
            inherited;
            gReveal('clothes-worn');
        }
    }

    dobjFor(Doff)
    {
        preCond = inherited + layersNotWorn
    }

    /* Před sundáním oblečení musí automaticky sundat skafandr. */
    layersNotWorn: objsNotWorn
    {
        objList = [roverSuit, spaceSuit]
    }

    hideFromAll(action)
    {
        return (action.ofKind(ExamineAction) && isWorn())
            || action.ofKind(DropAction) || action.ofKind(PutInAction)
            || inherited(action);
    }
;

++ overal: MyClothes
    'šedý pracovní overal*oblečení ošacení' 'pracovní overal' *2
    "Šedivý overal s mnoha kapsami, na okrajích roztřepený s firemním logem
        vpředu, na levém koleni je našitá záplata ve tvaru veselého králíčka. "

    dobjFor(Wear)
    {
        preCond = inherited + objHeld
            + new ObjectPreCondition(me, actorStanding)
    }
    dobjFor(Doff)
    {
        preCond()
        {
            if(me.isIn(toilet)) return inherited + new ObjectPreCondition(
                toiletDoor, objClosed);
            else
                return inherited;
        }
        check()
        {
            if(!me.isIn(toilet) && !me.isIn(yourCabin)) failCheck('Neměl by ses
                svlékat na veřejnosti, je to neslušné. ');
        }
    }

    gcName = 'pracovního overalu, pracovnímu overalu, pracovní overal, pracovním
        overalu, pracovním overalem'
    gcVocab = 'pracovního pracovnímu pracovním overalu/overalem*oblečením
        ošacením'
;

+++ BagOfHolding, Component, Container
    'kapsy (pracovního) (overalu)' 'kapsy' *3
    "Každý overal má několik užitečných kapes, bez nich bys nemohl přenášet
        spoustu drobností. "

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    iobjFor(PutIn)
    {
        verify()
        {
            /*
             *   Kontejnery maji standardne logicky rank 70 resp. 60, pokud
             *   nejsou drzeny hracem. To pak ma ale za nasledek, ze prikaz
             *   "vloz kartu" ji vlozi radeji do kapsy, nez do slotu. Proto
             *   rank kapes snizime.
             */
            logicalRank(50, '');
            inherited;
        }
    }

    isPlural = true
    gcName = 'kapes, kapsám, kapsy, kapsách, kapsami'
    gcVocab = 'kapes kapsám kapsách kapsami -'
;

+++ Component 'záplata (veselého) (králíčka)' 'záplata' *3
    "Záplatou veselého králíčka někdo pečlivě opravil natržený overal, když byl
        novější. "

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'záplaty, záplatě, záplatu, záplatě, záplatou'
    gcVocab = 'záplaty/záplatě/záplatu/záplatou'
;

++++ Component 'veselý králíček' 'králíček' *1
    "Zubí se vesele od ucha k uchu. "

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'králíčka, králíčkovi, králíčka, králíčkovi, králíčkem'
    gcVocab = 'veselého veselému veselém veselým králíčka/králíčkovi/králíčkem'
;

+++ Component 'firemní logo' 'firemní logo' *4
    "Firemní logo společnosti TechnoUniverse Corporation Ltd. je energické,
        optimistické a jednoduše zapamatovatelné. "

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'firemního loga, firemnímu logu, firemní logo, firemním logu,
        firemním logem'
    gcVocab = 'firemního firemnímu firemním loga/logu/logem'
;

++ tshirt: MyClothes 'bavlněné tričko*oblečení ošacení' 'bavlněné tričko' *4
    "Je to bavlněné tričko s opraným obrázkem populárního týmu exozoologů. "

    dobjFor(Wear)
    {
        preCond = inherited + objHeld
            + new ObjectPreCondition(me, actorStanding)
    }
    dobjFor(Doff)
    {
        check() { failCheck('Neměl by ses svlékat na veřejnosti, je to
            neslušné. '); }
    }

    gcName = 'bavlněného trička, bavlněnému tričku, bavlněné tričko, bavlněném
        tričku, bavlněným tričkem'
    gcVocab = 'bavlněného bavlněnému bavlněném bavlněným trička/tričku/tričkem*
        oblečením ošacením'
;

++ shoes: MyClothes 'plátěné boty*oblečení ošacení' 'plátěné boty' *3
    "Boty jsou lehké, plátěné, dobře prodyšné, zapínají se na suchý zip a mají
        měkké neklouzavé podrážky. "

    bulk = 20

    dobjFor(Wear)
    {
        preCond = inherited
            + objHeld
            + new ObjectPreCondition(me, actorStanding)

        verify()
        {
            if(spaceSuit.isWornBy(me)) illogicalNow('Nemůžeš si obout boty,
                když máš na sobě skafandr. ');
            inherited;
        }
    }
    dobjFor(Doff)
    {
        check()
        {
            if(!me.isIn(dome) && !me.isIn(airlock) && !me.isIn(rover))
                failCheck('Neměl by sis zouvat boty, gravitace je tu nepatrná,
                    ale mohl by sis při odrážení něco vrazit do chodidla. ');
        }
    }

    isPlural = true
    gcName = 'plátěných bot, plátěným botám, plátěné boty, plátěných botách,
        plátěnými botami'
    gcVocab = 'plátěných plátěným plátěnými bot/botám/botách/botami*oblečením
        ošacením'
;

+++ Component 'měkké neklouzavé podrážky' 'podrážky' *3
    "Jsou měkké, neklouzavé a přizpůsobené spíš lehkému odrážení v beztíži
        uvnitř lodi než chození. "

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    isPlural = true
    gcName = 'podrážek, podrážkám, podrážky, podrážkách, podrážkami'
    gcVocab = 'měkkých měkkým měkkými neklouzavých neklouzavým neklouzavými
        podrážek/podrážkám/podrážky/podrážkách/podrážkami'
;

+ ycLeftCompartment: Fixture, OpenableContainer
    'levá přihrádka*přihrádky' 'levá přihrádka' *3
    "Je to výklopná plastová přihrádka cca 40 cm hluboká. "

    maxSingleBulk = 10000

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'levé přihrádky, levé přihrádce, levou přihrádku, levé přihrádce,
        levou přihrádkou'
    gcVocab = 'levé levou přihrádky/přihrádce/přihrádku/přihrádkou*přihrádek*
        přihrádkám*přihrádkách*přihrádkami'
;

++ Decoration 'osobní věci/drobnosti' 'osobní věci' *3
    "Hromádka osobních nedůležitých drobností nafasovaných z centrálního skladu,
        z nich většina nese firemní logo. "

    /* Sice je to dekorace, ale chceme ji objevit po otevření přihrádky. */
    isListed = true
    isListedInContents = true

    isPlural = true
    gcName = 'osobních věcí, osobním věcem, osobní věci, osobních věcech,
        osobními věcmi'
    gcVocab = 'osobních osobním osobními věcí/věcem/věcech/věcmi/drobností/
        drobnostím/drobnostech/drobnostmi'
;

+ ycRightCompartment: Fixture, OpenableContainer
    'pravá přihrádka*přihrádky' 'pravá přihrádka' *3
    "Je to výklopná plastová přihrádka cca 40 cm hluboká. "

    maxSingleBulk = 10000

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }
    dobjFor(Open)
    {
        action()
        {
            me.setHim(tablet);
            inherited();
        }
    }

    gcName = 'pravé přihrádky, pravé přihrádce, pravou přihrádku, pravé
        přihrádce, pravou přihrádkou'
    gcVocab = 'pravé pravou přihrádky/přihrádce/přihrádku/přihrádkou*přihrádek*
        přihrádkám*přihrádkách*přihrádkami'
;

+ orders: Readable 'rozkazy' 'rozkazy' *2
    "Je to pár listů přicvaknutých klipsnou na psací podložce. "

    bulk = 20
    readDesc = "Úkolem posádky, které jsi členem, je dopravit zásoby na
        těžařskou základnu a vrátit se zpět s částečně zpracovanými surovinami
        do největší továrny v Lagrangeově bodu. A možná taky zjistit proč si tě
        samotný ředitel metalurgické divize pozval k sobě do kanceláře a
        vyptával se na podrobnosti cesty, i když to dosud nikdy nedělal. "

    isPlural = true

    hideFromAll(action)
    {
        return action.ofKind(WearAction)
            || action.ofKind(DoffAction)
            || inherited(action);
    }

    gcName = 'rozkazů, rozkazům, rozkazy, rozkazech, rozkazy'
    gcVocab = 'rozkazů/rozkazům/rozkazech'
;
