#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/*
 *   Zavedeme slovník pro abstraktní témata, kterým neodpovídá žádný objekt ve
 *   hře, ale hráč se na ně může chtít vyptávat. Dáváme 1., 4. a 6. pád.
 */
tNetwork: Topic 'síť/síti/wifi/wi-fi';
tBoss: Topic 'šéf/šéfa/šéfy/šéfovi/šéfech/šéfíka/šéfíky/šéfících';
tGarden: Topic 'hydroponická hydroponické hydroponickou zahrada/zahrady/zahradě/
    zahradu/zahradou';
tTunnels: Topic 'tunel/tunelu/tunelem/tunely/tunelů/tunelům/tunelech';
tProgramming: Topic 'programování programováním (v) (robota) (robotovi)
    karla/karel/karlovi';
tInAenigmibus: Topic 'tým (in) inaenigmibus/aenigmibus';
tUtvar: Topic 'tým útvar rychlého nasazení';
tInspection: Topic 'inspekční (cestu)/(cestě)/inspekci';
tOpen: Topic 'otevření (velkých) (zelených) dveří';
tWork: Topic 'práce/práci';
tPassword: Topic 'heslo/hesla/heslu/hesle/heslem';
tDrink: Topic 'pití/pitím';
tSleep: Topic 'spánek/spánku/spaní/chrápání';
tLaboratory: Topic 'laboratoř/laboratoři';

/*
 *   Definice postavy technika Borise. Základem je třída Person a doplňujeme
 *   TourGuide kvůli tomu, že nás Boris povede z kupole do skladu.
 */
technician: TourGuide, Person 'boris/technik' 'Boris' *1 @corridorWest
    descCount = 0
    desc()
    {
        /*
         *   Delší popisek by byl časem byl otravný, tak ho po dvou vypsáních
         *   zkrátíme.
         */
        if(++descCount <= 2)
            "Těžko odhadnout, ale podle všeho je Boris starší než ty a mladší
                než kapitán. Je rozcuchaný, s nejméně týdenním strništěm. Jeho
                pracovní oblečení už určitě zažilo lepší časy, kromě spousty
                nejrůznějších skvrn je na pár místech záplatované a
                roztřepené. ";
        else
            "Technik Boris je o trochu starší než ty a vypadá zanedbaně. ";
    }

    /* Připravíme si Borisovy hlášky použité z více míst. */
    nervousList: ShuffledEventList
    {
        [
            '<.p><q>Nesnáším, když mi někdo furt čučí přes rameno,</q> zasyčel
                na tebe, <q>já chůvu nepotřebuju!</q> ',
            '<.p><q>Co je tobě po tom, co já mám na monitoru,</q> zavrčel na
                tebe, <q>dělám si svou práci a tebe jako kontrolora
                nepotřebuju.</q> ',
            '<.p><q>Musíš tu furt postávat a sísat, co dělám?</q> otráveně si
                povzdechl a pokračoval, <q>běž dělat, co máš, a neokouněj
                tu.</q> '
        ]
    }

    attackList: ShuffledEventList
    {
        [
            '<.p>Rozmáchl ses k útoku na Borise, ale zapomněl jsi, že Newtonovy
                zákony platí v celém vesmíru. Tady si na tobě konkrétně smlsnul
                zákon akce a reakce. Praštil jsi hlavou o stěnu a chuť na
                ubližování jiným tě zcela přešla. ',
            '<.p>Sice máš obrovskou chuť Borisovi zakroutit krkem, ale když
                vidíš jeho unavenou tvář, je ti ho líto. Vykašli se na to,
                násilí nic nevyřeší. ',
            '<.p>Zabij! Zabij! Zabij! -- davové šílenství se ti vždycky
                hnusilo a ani teď takovému nátlaku nepodlehneš. '
        ]
    }

    dobjFor(Attack)
    {
        action()
        {
            attackList.doScript();
        }
    }
    dobjFor(Break) asDobjFor(Attack)

    /*
     *   Nesmíme dovolit, aby hráč naivně dal Borisovi to, čím ho pak tolik
     *   potrápí.
     */
    iobjFor(GiveTo)
    {
        verify()
        {
            if(gDobj == syringe || gDobj == laxative) illogical('To není dobrý
                nápad, Boris by asi neměl vědět, že jsi našel projímadlo. ');
            inherited;
        }
    }

    /* Kvůli "Borisovo rozbití by bylo k ničemu" */
    zajmenoTvoje { return 'Borisovo'; }

    gcName = 'technika, technikovi, technika, technikovi, technikem'
    gcVocab = 'borise/borisi/borisovi/borisem/technika/techniku/technikovi/
        technikem/technikův\'s/technikovu\'s/technikovo\'s/borisův\'s/
        borisova\'s/borisovu\'s/borisovo\'s'
;

+ card: Wearable
    'identifikační provlečená karta/šňůrka' 'identifikační karta' *3
    "Bezdrátová identifikační karta s provlečenou šňůrkou na krk, z jedné strany
        je Borisovo celé jméno s natištěným obrázkem, z druhé strany je logo
        společnosti T. U. Corp. "

    /*
     *   Díky syntaxi s pluskem na začátku definice objektu je karta umístěna v
     *   Borisovi, tj. má ji ve svém inventáři. Třída Wearable je určena pro
     *   oblečení a podobné věci, které lze obléci resp. mít na sobě. Nastavením
     *   wornBy = technician zařídíme, že ji Boris má "oblečenou". Zde ale místo
     *   technician je v přiřazení použita vlastnost location, která ukazuje na
     *   nadřazený objekt v kontejnerové hierarchii definované zmíněnými plusky.
     */
    wornBy = location

    dobjFor(Take)
    {
        /*
         *   Tohle je docela záhada, podle info v Learning T3 by to nemělo jít,
         *   možná, že to jde kvůli tomu, že přemapovávám TAction na TIAction?
         */
        remap = isIn(technician) || isIn(trTable) && me.isIn(techniciansRoom)
            ? [AskForAction, technician, self] : nil

        /* Během jízdy vozítkem nedovolíme kartu vyndat. */
        verify()
        {
            if(isIn(slot) && gRevealed('rover-driving')
                && !gRevealed('rover-destination'))
                    illogicalNow('Teď určitě nechceš zastavit. ');
        }
        action()
        {
            /* První získání karty musíme patřičně obodovat. */
            if(self.isIn(trTable) && me.isIn(technicianConducts))
            {
                "Opatrně a potichu jsi prostrčil podávátko zapadlých šroubů
                    jedním z otvorů v mřížce. Nikdy bys neřekl, jak mohou být
                    šňůrky neposedné. Už jsi to chtěl vzdát, když se ti konečně
                    podařilo šňůrku zachytit a kartu protáhnout mřížkou k sobě
                    nahoru. ";

                scoreMarker.awardPointsOnce();
            }
            inherited;
        }
    }
    scoreMarker: Achievement { +2 "získání Borisovy identifikační karty" }

    /*
     *   Hráči mají tendenci zadat příkaz "podej si kartu", což je ale úplně
     *   jiná akce určená na předávání předmětů jiným postavám a "si" pak
     *   zvratně ukazuje na hráče samotného. Hra by kartu vzala a pak by
     *   napsala, že "podáním karty sám sobě ničeho nedosáhneš" a tomu se právě
     *   chceme vyhnout.
     */
    dobjFor(GiveTo) remapTo(Take, self)

    /* Přemapujeme kvůli formulaci "přilož", např. přilož kartu ke čtečce. */
    dobjFor(AttachTo) remapTo(PutIn, self, IndirectObject)
    iobjFor(AttachTo)
    {
        verify()
        {
            /* Povolíme přiložit podávátko ke kartě. */
            if(gDobj != picker) inherited();
        }
    }

    iobjFor(AimAt)
    {
        action()
        {
            "Tablet zobrazil informace o kartě. Patří Borisovi a mimo jiné ho
                opravňuje k řízení průzkumných vozítek. ";
        }
    }

    gcName = 'identifikační karty, identifikační kartě, identifikační kartu,
        identifikační kartě, identifikační kartou'
    gcVocab = 'provlečené provlečenou karty/kartu/kartě/kartou/šňůrky/šňůrce/
        šňůrku/šňůrkou'
;

/* ------------------------------------------------------------------------ */
/*
 *   Nejprve globání témata konverzace přidaná přímo do postavy. Ty jsou k
 *   dispozici vždy, pokud není řečeno jinak pomocí isActive.
 */
+ AskTellTopic @captain
    "<.p><q>Hele, ty znáš mýho kapitána dlouho? Co mi o něm můžeš říct?</q>
        zeptal ses jakoby jen tak mimochodem.

        <.p><q>Jo, Henry, lítá sem celou dobu, co jsem tady na základně,</q>
        zamyslel se Boris, <q>s našim velitelem se znají určitě ještě ze Země,
        mám pocit, že jsou fakt kámoši. Dost mě překvapilo, že přiletěl s tebou,
        jsi úplně jiný, než byl ten jeho parťák před tebou. A tak trochu jsem si
        myslel, že po tom, co se stalo s Chrissem, se už nevrátí.</q>
        <.reveal chriss-death><.topics> "
;

+ AskTellTopic @commander
    "<.p><q>Když už tak vedeme řeč, jakej je váš velitel?</q> nadhodil jsi
        otázečku.

        <.p><q>Ivan Petronov?</q> protáhl slabiky Boris a chvilku se odmlčel,
        <q>šéf, každým coulem. Ono když jsi s někým na takové hroudě daleko od
        ostatních, tak k němu vystřídáš všechny pocity včetně vražedné
        nenávisti. Ale on si umí držet odstup a nenechá si koukat do
        karet.</q> "
;

+ AskTellTopic @tChriss
    "<.p><q>Borisi,</q> zeptal ses technika, <q>jaký byl vlastně ten Christian
        Anderson, ten Chriss?</q>

        <.p><q>No,…</q> Boris očividně s odpovědí nespěchá, <q>párkrát jsme se
        potkali tady na základně, ale on se moc s nikým nebavil, chtěl mít
        pečlivě vyloženo a naloženo, to ho zajímalo nejvíc.</q> "
;

++ AltTopic, SuggestedAskTopic
    "<.p><q>Ty, Borisi,</q> zeptal ses technika, <q>co se vlastně stalo s tím
        Chrissem?</q>

        <.p><q>Hmm, no,</q> Borisovi se do odpovědi očividně nechce, <q>taková
        blbá nehoda. Nevím, co ho to napadlo, vyrazil ven, že si vezme nějaké
        vzorky kamenů. Netuším, k čemu. A když se nehlásil, jeli ho velitel s
        kapitánem hledat. Našli ho v zakázané oblasti už mrtvýho. Viděl, jsem
        když ho přinesli. Rozsekl skafandr, zřejmě nějaké blbé došlápnutí,
        zakymácení -- náhoda a bylo to.</q><<gSetKnown(sq71)>> "

    name = 'Chrisse'

    /*
     *   AltTopic je odpověď, která nahradí výše uvedenou odpověď na @tService,
     *   jakmile je splněna podmínka isActive. V tomto případě po té, co si hráč
     *   zaběhá na pásu.
     */
    isActive = gRevealed('chriss-death')
;

+ AskTellTopic @suspiciousContainer
    "<.p><q>Borisi,</q> obrátil ses k technikovi, <q>říká ti něco bedna typu
        KBR?</q>

        <.p><q>Hmmm,</q> podrbal se Boris ve vlasech, <q>tenhle typ jsem tu
        nikdy neviděl, ty se posílají na vzdálenější cíle. Proč se ptáš?</q>

        <.p><q>Jedna s námi cestovala,</q> odpověděl jsi.

        <.p><q>Nesmysl,</q> ostře se ohradil Boris, <q>to bych o tom něco
        věděl.</q> "
;

++ AltTopic
    "<.p><q>Borisi, viděl jsem bedny, které jsme v nákladu mít neměli,</q>
        vykládáš přes dveře technikovi.

        <.p><q>Možná to je divné, ale teď mě nech žít!</q> ozvalo se po
        chvíli. "

    isActive = technician.isIn(toilet)
;


+ AskTellTopic @sq71
    "<.p><q>Borisi,</q> zeptal ses technika, <q>co víš o té zakázané
        oblasti?</q>

        <.p><q>No,</q> zmlkl na chvilku Boris ve snaze srovnat si myšlenky,
        <q>tenkrát, když došlo k té havárce, řekl velitel, že nemá smysl se tou
        oblastí zabývat, když je vlastně vytěžená, a uzavřel ji. Nechtěl ani,
        abych se jel podívat na trosky rypadla, takže ti nic víc neřeknu.</q> "
;

+ AskTellTopic @tGarden
    "<.p><q>Prej tu máte hydroponickou zahradu,</q> hodil jsi poznámku směrem k
        Borisovi.

        <.p><q>Zahrada? Určitě tu někde je. Nikdy jsem tam nebyl. Mám alergii na
        všechno zelené,</q> zavrčel na tebe Boris. "
;

+ AskTellTopic @tTunnels
    "<.p><q>Borisi, řekni mi něco o tunelech,</q> zaškemral jsi ma technika.

        <.p><q>Tunely? Dělají z asteroidu ementál,</q> odvětil Boris, <q>stejně
        jako na jiných planetkách.</q> "
;

+ AskTellTopic @roverOutside
    "<.p><q>Borisi,</q> zkoušíš vytáhnout z Borise další informace, <q>máte tu
        vozítka?</q>

        <.p><q>Samozřejmě, že tu jsou vozítka. Přece nebudeme chodit pěšky!</q>
        utnul diskusi technik. "
;

+ AskTellTopic @asteroid
    "<.p><q>Mohl bys mi, Borisi, říci něco o zdejším asteroidu?</q> hodil jsi
        dotaz směrem k technikovi.

        <.p><q>Základní plky najdeš v každé encyklopedii,</q> odsekl technik,
        <q>vypadám snad jako tetička Wiki, že tím otravuješ mě?</q> "
;

+ AskTellTopic @base
    "<.p><q>Borisi, mohl bys mi říci něco o základně?</q> zeptal ses technika.

        <.p><q>Mladej, cos dělal celou cestu sem, že sis nic nepřečetl?</q>
        zakroutil hlavou Boris. "
;

+ AskTellTopic @tresorDiamonds
    "<.p><q>Borisi, prosím tě,</q> domáháš se technikovy pozornosti, <q>co víš o
        diamantech?</q>

        <.p><q>Diamanty, krystalická forma uhlíku,</q> Boris očividně bloumá ve
        svých myšlenkách, <q>životě jsem žádný nedržel v ruce.</q> "
;

+ AskTellTopic [tresorBills, tresorLetter, tresorPapers]
    "<.p><q>Borisi,</q> nadechl ses k otázce k technikovi, ale pak ti došlo, že
        to by asi nebylo vhodné přiznávat, kde jsi všude strkal svůj zvědavý
        nos. "
;

+ AskTellTopic @tCmx12
    "<.p><q>Šéfové mi řekli, že náhradní součástky vytáhli z vyřazených rypadel
        CMX12,</q> poinformoval jsi Borise.

        <.p>Ten povytáhl obočí a tázavě se na tebe zahleděl: <q>To jsi, Toby,
        asi špatně rozmněl. CMX dvanáctky a vůbec celá tahle řada jsou určené na
        velké měsíce se slušnou gravitací, na takovémhle asteroidu jsou k
        ničemu. Nemáme tu ani jeden.</q><.reveal cmx12-lie> "
;

+ AskTellTopic @laxative
    "<.p><q>Borisi, víš něco o projímadle?</q> tiše ses zeptal přes dveře
        technika.

        <.p><q>Běda ti, jestli s tím máš něco společného,</q> zavrčel zpoza
        dveří Boris. "

    isActive = technician.isIn(toilet)
;

+ AskTellAboutForTopic @toilet
    "<.p><q>Borisi,</q> naklonil ses k technikovi a zašeptal, <q>a co
        záchod?</q>

        <.p><q>Vesmírná klasika, sedneš, zatlačíš do mísy, co bys čekal?</q>
        odpověděl Boris a máchl rukou někam neurčitě do prostoru. "
;

++ AltTopic
    "<.p><q>Borisi,</q> opatrně jsi zaťukal na dveře, <q>mohl bych na
        záchod?</q>

        <.p><q>Soráč, obsazeno,</q> ozvalo se po hlubokém výdechu zpoza dveří. "

    isActive = technician.isIn(toilet)
;

+ AskTellTopic @tProgramming
    "<.p><q>Borisi,</q> váhavě oslovuješ technika, <q>pomůžeš mi s
        programováním?</q>

        <.p><q>Nedělej si legrácky,</q> odsekl Boris, <q>copak ty jsi nechodil
        do Kapsy na kroužek?</q> "
;

+ AskTellTopic @tInAenigmibus
    "<.p><q>Jo a Borisi,</q> zavzpomínal jsi na dávné časy, <q>pamatuješ si na
        tým In Aengimibus z Technoplanety?</q>

        <.p><q>Počkej,</q> zamyslel se Boris, <q>to je ta Ráchel a spol? Slyšel
        jsem, že je to skvělá holka. Teda kromě těch momentů, kdy začne mít řeči
        a to je pak na zabití.</q> "
;

+ AskTellTopic @tUtvar
    "<.p><q>Jo a Borisi,</q> zavzpomínal jsi na dávné časy, <q>pamatuješ si na
        tým Útvar rychlého nasazení na Technoplanetě?</q>

        <.p><q>Ale ano, ten nešel přehlédnout,</q> vzpomíná Boris, <q>víš, že
        Filip jednu dobu psal pomalu tolik příspěvků na fórum, co všichni
        ostatní dohromady?</q> "
;

+ AskTellTopic @ship
    "<.p><q>Borisi,</q> pokoušíš Borise další otázkou, <q>co víš o naší
        lodi?</q>
        <.p><q>Zkoušíš mě, nebo co? Je to VAŠE loď,</q> odsekl zprudka
        technik. "
;

+ AskTellTopic @tInspection
    "<.p><q>Prosím tě, Borisi,</q> ztišil jsi hlas do tajuplného šepotu, <q>na
        jakou inspekci jezdí?</q>

        <.p>Technik k tobě pomalu stočil zrak: <q>Co já vím? Mně se tady toho
        moc neřekne! A potom, co se stalo s Chrissem, začal jezdit šéf po
        asteroidu na ty inspekce ještě častěji.</q>
        <.reveal chriss-death><.topics> "
;

+ AskTellTopic @technician
    "<.p><q>Borisi,</q> pousmál ses na technika, <q>řekni mi něco o sobě.</q>
        <.p><q>Dej mi pokoj, mladej,</q> zavrčel Boris, <q>žádného
        psychoanalytika nepotřebuju!</q> "
;

+ AskTellTopic @garden
    "<.p><q>Chtěl bych brouzdat ranní rosou,</q> zasnil ses, <q>Borisi, šlo by
        to v hydroponické zahradě?</q>
        
        <.p><q>Nepotřebuješ spíše lékaře?</q> zakroutil hlavou Boris, <q>vždyť
        víš, že se do hydroponiky nesmí!</q> "
;

+ AskTellTopic @tAnomaly
    "<.p><q>Borisi, prosím tě,</q> otázal ses technika, <q>dočetl jsem se o
        nějaké geologické anomálii.</q>
        
        <.p><q>Dočetl? Tak víš tolik, co já,</q> zavrčel na tebe Boris. "
;

+ AskTellTopic @figure
    "<.p><q>Borisi, sbíráš figurky?</q> zase jsi vytrhnul Borise z jeho
        činnosti, <q>myslím figurky kosmonautů.</q>
        
        <.p><q>Jako malý jsem kvůli nim jedl ke každé snídani cornflake,</q>
        usmál se Boris, <q>a tuhle si jednu vylovil z vloček i náš
        velitel.</q> "
;

+ AskTellTopic @tresor
    "<.p><q>Borisi,</q> nahnul ses směrem <<if technician.isIn(toilet)>>ke
        dveřím,<<else>>k technikovi,<<end>> <q>proč tu má velitel trezor?</q>
        
        <.p><q>Nevím, netuším a asi ani nechci vědět,</q> pokrčil rameny Boris,
        <q>mně říkal, že je to dobré pro image velitele.</q> "
;

+ AskTellTopic @tCargo
    "<.p><q>Borisi,</q> snažíš se být zcela nenápadný, <q>co víš o našem
        nákladu?</q>

        <.p><q>Co chceš?</q> Boris tě očividně příliš nevnímá, <q>přivezli jste
        objednávku, nebo snad ne?</q> "
;

+ AskTellTopic @tRab4
    "<.p><q>Může mi tu někdo říci,</q> hodil jsi s očima otočenými ke stropu,
        <q>co je to ta zatracená ra-b4</q>

        <.p><q>Myslíš toho rozkousávače asteroidů? Až do té havárky by mě
        nenapadlo, že by je něco mohlo zastavit,</q> zamyslel se technik. "
;

+ AskTellTopic [laxative, syringe]
    "<.p><q>Psst,</q> napomenul jsi v duchu sám sebe. <q>Třeba se to bude ještě
        hodit.</q> "

    /*
     *   Protože tohle vlastně není konverzace, hráč si rozmyslí a nepoloží
     *   otázku, tak musíme označit, aby neproběhlo automatické pozdravení.
     */
    isConversational = nil
;

++ AltTopic
    "<.p><q>Koleduješ si o průšvih,</q> napomenul jsi v duchu sám sebe. <q>Kdyby
        Boris přišel na to, že jsem to byl já, mohl by mě poslat nakládat raketu
        a bez skafandru.</q> "

    isConversational = nil
    isActive = technician.isIn(toilet) || gRevealed('lunch')
;

+ AskTellTopic @pharmacyCabinet
    "<.p><q>Borisi,</q> obrátil ses na technika, <q>kde máte lékárničku?</q>
        <.p><q>Copak,</q> syknul Boris, <q>udělal sis bebí?</q>
        <.p><q>Ale ne,</q> pokrčil jsi rameny, <q>ale jeden nikdy neví.</q>
        <.p><q>To jo, je ve skladu,</q> odfrknul technik, <q>a buď si jistý, že
        v ní najdeš to, co zrovna potřebuješ.</q> "
;

+ AskTellTopic [supplyRoom, shelves, packages, c3a24Package, c3a24Unpackage]
    "<.p>Zadumal ses a pak se obrátil na Borise: <q>Prosím tě, jak vlastně něco
        najdu v tom vašem skladu?</q>

        <.p><q>Snadno, lehce, přehledně, to je náš sklad,</q> usmál se Boris,
        <q>pokud víš, jakou součástku potřebuješ, zadej ji do tabletu. A pokud
        ji máme, dozvíš se i číslo balíku, ve kterém je. A jakmile znáš číslo,
        najdeš balík v regálu.</q> "
;

+ AskTellTopic @tPluto
    "<.p><q>Borisi,</q> začal jsi zcela rozhodně, <q>opravdu jsem viděl na rampě
        bednu KBR-3867. Podle počítače byla před dvěma lety vyřazena jako
        poškozená, ale tady a teď byla zcela v pořádku!</q>

        <.p><q>Hm,</q> zamručel pochybovačně technik, <q>o bedny se starají
        automaty. Takže pokud bys neměl vlčí mhu před očima, musel by někdo
        zmanipulovat i je.</q> "
;

+ AskTellTopic @tIncident
    "<.p><q>Hele, Borisi,</q> nedalo ti to se nezeptat, <q>jak to bylo tehdá s
        tou havárkou rypadla?</q>

        <.p><q>Ta havárka byla docela vzrůšo,</q> Boris se pustil do vyprávění,
        jakoby o tom mluvil poprvé, <q>najednou jsme přestali těžit. Nedokázali
        jsme zjistit, co se stalo, tak jsme raději na čas zastavili všechno. O
        té anomálii nikdo neměl ani ponětí, nevypadalo to, že by byl odfláknutý
        průzkum. A velitel to uzavřel. Tečka.</q>

        <.p><q>Takže jsi tam nikdy nebyl?</q> zeptal ses.

        <.p>Boris povzdechl: <q>Chtěl jsem se podívat na trosky štítu, ale neměl
        jsem šanci, šéf tvrdě zakázal jakýkoliv pohyb v tom směru.</q> "
;

/* ------------------------------------------------------------------------ */
/*
 *   Mimo probuzení rozlišujeme u karty AskTell vs. AskFor. Jakmile ho vzbudíme,
 *   vše směřujeme na žádost o kartu.
 */
+ AskTellTopic @card
    "<.p><q>Pěkná karta, dělaná přímo na tebe?</q> zeptal ses Borise, <q>co
        všechno ještě umí?</q>

        <.p><q>Klasická identifikační karta, vždyť to znáš,</q> odvětil
        technik s pohledem dál upřeným na svou práci, <q>děda mi kdysi
        vyprávěl, jak s sebou tahali svazky klíčů -- ke každým dveřím,
        dokonce i ke startování aut.</q> "

    isActive = !technician.isIn(techniciansRoom)
;

++ AltTopic
    "<.p><q>Borisi,</q> tiše jsi zaťukal na dveře, <q>co ta tvoje karta, k čemu
        všemu je?</q>

        <.p><q>Jsi horší než čtvrtodenní zimnice,</q> ozvalo se po hlubokém
        výdechu zpoza dveří, <q>jsi v životě žádnou kartu neviděl? Přece nebudu
        tahat po základně tuny otevíráku, přístupů a kódů!</q> "

    isActive = technician.isIn(toilet)
;

/* StopEventList prochází možnosti v řadě a poslední opakuje stále dokola. */
+ AskForTopic, StopEventList @card
    [
        '<.p><q>Borisi, půjč mi svou kartu,</q> poprosil jsi technika.

            <.p><q>Upadl jsi na hlavu?</q> zavrtěl Boris hlavou, <q>a ani svůj
            zubní kartáček ti nepůjčím.</q> ',

        '<.p><q>Mohl bys mi přeci jen půjčit svou identifikační kartu?</q>
            zdvořile ses obrátil na technika.

            <.p><q>A moji ledvinu půjčit nechceš?</q> zcela nezdvořile odseknul
            Boris. ',

        '<.p>Hodila by se ti technikova karta, ale nemá cenu si o ni znovu
            říkat, Boris ti ji nedá. '
    ]

    /* Poslední varianta už není konverzací. */
    isConversational = curScriptState < eventList.length()
    isActive = !technician.isIn(techniciansRoom)
;

+ AskTellAboutForTopic, StopEventList @card
    [
        '<.p><q>Borisi, spi, nevstávej, já si jen půjčím tvou kartu,</q> šeptem
            oznamuješ do prostoru.

            <.p><q>Abych ti ruku nepřerazil,</q> zarazil tě Borisův hlas, takže
            jsi zacouval zpět. ',

        '<.p><q>Borisi, můžu si půjčit tvou kartu?</q> promluvil jsi na
            technika, <q>fakt ji potřebuju.</q>

            <.p><q>A já zas potřebuju klid na spaní,</q> zavrčel Boris, <q>zavři
            za sebou zvenku!</q> ',

        '<.p><q>Já bych si jen tak na chvilku půjčil tvou kartu,</q> pokoušíš se
            nenápadně využít ospalosti Borise.

            <.p><q>Já ti dám kartu, nejlépe sekerou do hlavy,</q> překvapivě
            svižně zareagoval Boris a tobě nezbývá než bleskově vypadnout. ',

        '<.p>Hodila by se ti technikova karta, ale raději do jámy se škorpiony
            než si o ni znova říkat. '
    ]

    isConversational = curScriptState < eventList.length()
    isActive = technician.isIn(techniciansRoom)
;

/* ------------------------------------------------------------------------ */
/*
 *   Celá tato skupina je k dispozici jen dokud se nevrátí kapitán s
 *   velitelem. Jakmile Boris odejde spát, tak už není relevantní.
 */
+ TopicGroup
    isActive = !gRevealed('lunch')
;

/* Pokud se téma týká více objektů, dáme je do hranatých závorek jako seznam. */
++ AskTellTopic, SuggestedAskTopic [ unidip, probe ]
    "<.p><q>Jak se zachází s UniDiPem?</q> zeptal ses a hekl jsi při pokusu
        protáhnout si záda.

        <.p><q>Normálně připojíš sondu k tomu, co chceš testovat, a na obrazovce
        uvidíš výsledek kontroly,</q> zřejmě po stoosmdesátdruhé vysvětluje
        Boris. "

    name = 'UniDiP'
;

++ AskTellTopic [ coffeeBox, coffee1, coffee2, coffee3 ]
    "<.p><q>Ty bez toho kafe neuděláš ani krok,</q> usmál ses na Borise,
        <q>stojí vůbec za to?</q>

        <.p>Boris potáhl z kafovaku dlouhý lok: <q>Soustavně a marně se pokouším
        dostat sem pravou arabicu, ale v tom koncentrátu nebudou ani ty mletý
        bukvice, jak říkával můj děda. Ale máme jí hodně.</q> "
;

+++ AltTopic
    "<.p><q>Borisi, jsi v pořádku?</q> naklonil jsi lehce hlavu na bok, aby ti
        neunikl ani hlásek. <q>Nepřehnal jsi to s tím kafem?</q>

        <.p>Na Borisovu odpověď jsi nečekal dlouho: <q>Dej mi laskavě
        pokoj.</q> "

    isActive = technician.isIn(toilet)
;

++ GiveShowTopic [ coffee1, coffee2, coffee3 ]
    "<.p><q>Borisi, dáš si kafe?</q> natáhl jsi ruku s kafovakem k technikovi.

        <.p><q>Díky, ale nechci,</q> zavrtěl Boris hlavou, <q>ještě jsem
        nedopil, pak si ho podám sám.</q> "

    isActive = technician.isIn(controlRoom)
;

++ AskTellTopic @computer
    "<.p><q>Borisi,</q> vyrušil jsi technika ze soustředění, <q>v tomhle všem se
        orientuješ jen tak lážo plážo?</q> a ukázal jsi rukou směrem k počítači.

        <.p><q>To víš, roky praxe,</q> hrdě se napřímil Boris, <q>podařilo se mi
        vymakat systém tak, že se dostaneme ke každé informaci, kterou
        potřebujeme. A když řeknu, ke každé, myslím tím opravdu ke každé! I
        kdyby si šéf vzpomněl a chtěl vědět, kdy jsme používali bleděmodré
        ponožky, ta informace tu je.</q> "
;

++ AskTellTopic @cctvScreen
    "<.p><q>Můžu se zeptat?</q> vyrušil jsi Borise, <q>tohle je kamerový systém?
        Jak dalece je základna pod dohledem?</q> projevil jsi zvědavost.

        <.p><q>To víš, tohle není ulice u vás v Kotěhůlkách,</q> usmál se Boris,
        <q>kde je spousta lidí. Nás je tu málo a nemůžeme být všude. Takže
        potřebujeme alespoň vidět, jestli si třeba roboti nedávaj tajně
        čouda.</q> "
;

++ AskTellTopic [tablet, tNetwork]
    "<.p><q>Borisi,</q> zeptal ses technika, <q>můžu už používat síť základny
        přes svůj tablet?</q>

        <.p><q>Mám snad v zadku vrtulku?</q> ušklíbnul se technik, <q>až si
        sednu k počítači, tak to udělám.</q> "
;

+++ AltTopic
    "<.p><q>Borisi,</q> oslovil jsi technika, <q>co moje připojení k síti přes
        tablet?</q>

        <.p><q>Za co mě máš?</q> odvětil, <q>když makám, tak makám. Máš to dávno
        hotové a kdybys místo zbytečného vyptávání vyzkoušel třeba vyhledat
        asteroid, tak jsi mě nemusel rušit.</q> "

    isActive = gRevealed('database-access')
;

++ AskTellTopic @largeDoor
    "<.p><q>Borisi, a co ty zelené dveře?</q> zeptal ses technika, <q>kam
        vlastně vedou?</q>

        <.p><q>Myslíš ty veliké?</q> potvrdil si Boris otázku, <q>ty vedou do
        druhé části základny. Máme tam hydroponickou zahradu, u ní je laboratoř
        a záložní zdroje. A hlavně je to přístup k tunelovým vozítkům. Je to
        tady vlastně náš jediný dopravní prostředek, dá se s nimi jezdit
        samozřejmě i mimo tunely, ale vzhledem k tomu, jak je asteroid
        provrtaný, je to vnitřkem pohodnější.</q> "
;

++ AskTellTopic @tOpen
    "<.p><q>Borisi, prosím tě,</q> zeptal ses tak neurčitě, <q>jak se otevřou
        dveře?</q>

        <.p><q>Dveře? Copak jsem nějakej vrátnej?</q> odseknul Boris, zase
        vytržený z práce. "
;

++ AskTellTopic [tLaboratory, tMicroscope]
    "<.p><q>Borisi, pověz mi, prosím, jak vypadá ta zdejší laboratoř?</q> zeptal
        ses technika.
        <.p><q>Ty myslíš tu špeluňku u hydroponiky? Hrdý název pro zahradní
        kůlnu,</q> konstatoval Boris s lehkým pohrdáním technika ke všemu
        zelenému.
        <.p><q>Takže tam nemáte ani mikroskop?</q> pokračoval jsi v získávání
        informací.
        <.p>Boris se zasmál: <q>Tohle je asteroid a těžíme tu rudu. K čemu
        mikroskop? Ani na prohlížení lístečků v zahradě ho nepotřebujeme.</q> "
;

++ AskTellTopic @tBoss
    "<.p><q>Borisi,</q> zamyslel ses, <q>kde jsou teďka šéfové?</q>

        <.p><q>Myslíš tím našeho velitele Ivanova a tvýho kapitána Scotta?</q>
        zeptal se pro upřesnění Boris. <q>Pokud vím, jsou u velitele v kajutě a
        řeší papíry.</q> "
;

+++ AltTopic
    "<.p><q>Ty, Borisi,</q> zeptal ses, <q>nevíš čistě náhodou, kde máme
        velení?</q>

        <.p><q>Myslíš Ivanova a Scotta?</q> potvrzuje pro sebe technik, <q>před
        chvíli si brali vozítko a vyrazili asi na nějakou inspekci. Dělají to
        pokaždé, když váš kapitán dorazí.</q> "

    isActive = gRevealed('coffee')
;

++ AskTellTopic @robot
    "<.p><q>Borisi, co víš o tom robotovi?</q> zeptal ses technika.

        <.p><q>Robot?</q> Boris očividně bloumá ve svých myšlenkách, <q>víš, že
        pořád spousta lidí si myslí, že to slovo vymyslel Karel Čapek? Určitě i
        ty!</q> "
;

++ AskTellShowTopic, SuggestedAskTopic [firstModule, brokenComponents]
    "<.p><q>No, chtěl bych se zeptat,</q> začínáš váhavě, <q>co s tím
        modulem?</q>

        <.p><q>To není zas tak velký problém,</q> usmál se Boris, <q>vezmi si
        skafandr a vylez ven k lodi. Na přídi najdeš radarovou navigaci,
        vytáhneš ovládací modul a prověříš ho.</q> "

    name = 'modul'
    isActive = !gRevealed('hint-second-module')
;

+++ AltTopic
    "<.p><q>Prosím tě,</q> zase vytrhuješ technika ze zaujetí, <q>tak jsem ten
        modul dostal ven a jak dál?</q>

        <.p><q>Přece projet UniDiPem,</q> nestojíš Borisovi ani za zvednutí
        hlavy, <q>co vás v té škole naučili?</q> "

    isActive = firstModule.moved && !gRevealed('hint-second-module')
;

+++ AltTopic
    "<.p><q>Mám tu problém,</q> mluvíš na technika, <q>prověřil jsem ten modul
        UniDiPem a ten tvrdí, že je všechno OK.</q>

        <.p><q>Zapnul jsi správné testování? Nedal jsi tam modul obráceně?</q>
        klade Boris zcela zbytečné otázky, jakoby se na testování UniDiPem dalo
        něco pokazit.

        <.p><q>Samozřejmě, že jsem tohle nezvoral<<if firstModule.probeCount
        > 1>>, a projel jsem to pro jistotu <<spellInt(firstModule.probeCount,
        2)>>krát<<end>>. Je možné, že by byla chyba jinde?</q> tázavě se obracíš
        k odborníkovi. <q>Všechny přístroje jinak fungují, vyplo se topení a
        hlavní osvětlení a přestala fungovat navigace.</q>

        <.p>Boris zpozorněl: <q>Aha, tos mi neřekl, to by mohla být závada úplně
        jinde. Zkontroloval bych vysílací modul, ten je napájen ze silových
        rozvodů. Budeš muset znova ven.</q><.reveal hint-second-module>
        <<gSetKnown(secondModule)>> "

    isActive = gRevealed('module1-ok') && !gRevealed('hint-second-module')
;

++ AskTellTopic, SuggestedAskTopic @spaceSuit
    "<.p><q>Borisi,</q> hodil jsi dotaz na technika, <q>nevíš o nějakém
        skafandru?</q>
        
        <.p><q>Tak si říkám, jak ses mohl dostat až sem,</q> zakroutil
        hlavou Boris, <q>pokud nemáš svůj z lodi, tak nějaký visí nahoře v
        kopuli u přechodové komory.</q> "

    name = 'skafandr'
    isActive = !spaceSuit.moved
;

++ AskTellShowTopic, SuggestedAskTopic [secondModule, brokenComponents]
    "<.p><q>Ale počkej,</q> ptáš se zaraženě, <q>ono je těch modulů více?</q>

        <.p><q>To dá přeci rozum,</q> schovívavě vysvětluje Boris, <q>přijímač
        je od vysílače oddělen kvůli rušení. Oba bývají na přídi hned vedle
        sebe.</q> "

    name = 'modul'
    isActive = gRevealed('hint-second-module')
;

+++ AltTopic
    "<.p><q>Jsem zpátky, jsem šikovný, našel jsem ten druhý modul,</q> vytahuješ
        se před Borisem.

        <.p><q>A jak dopadl test? Je tam nějaká závada?</q> uzemňuje tě
        přízemním dotazem technik.

        <.p><q>Hmm, ještě jsem ho netestoval,</q> váhavě přiznáváš.

        <.p><q>Tak na co čekáš?</q> popohání tě Boris do práce. "

    isActive = me.hasSeen(secondModule)
;

+++ AltTopic
    "<.p><q>Tak je to ten vadný modul,</q> hlásíš spokojeně technikovi,
        <q>UniDiP mi i vypsal součástky, které je potřeba vyměnit. Potřebuju
        poradit, jak je v tom vašem skladu najdu.</q>

        <.p><q>Zapni si tablet,</q> radí ti Boris, <q>máš přece už umožněný
        přístup do systému. A najdi si, co konkrétně potřebuješ.</q> "

    isActive = brokenComponents.discovered
;

+++ AltTopic
    "<.p><q>Borisi,</q> začal jsi váhavě, <q>potřebuju tyhle součástky tři 
    a systém tvrdí, že máte jen jednu.</q>

    <.p><q>Raději prohrabej balíky,</q> mávl Boris rukou, <q>nikdy nevíš,
    kdy ti systém něco zapře.</q> "

    isActive = gRevealed('low-stock')
;

+++ AltTopic
    "<.p><q>A kurňa,</q> komentuješ situaci, <q>potřebuju tyhle součástky tři a
        na skladu máte fakt jen jednu. Borisi, máte nějaké zásoby, které nejsou
        zanesené v systému?</q>

        <.p><q>Tak to je v kelu,</q> znechucuje se Boris, <q>nic mimo nemáme a
        tato série se ani v ničem jiném nepoužívá. Měl bys to probrat s
        šéfíky.</q><<me.setThem(tBoss)>> "

    isActive = gRevealed('viz54-found')
;

+++ AltTopic
    "<.p><q>Tak jsem s šéfama mluvil,</q> povídáš, <q>ale nevím, jestli jsem
        dopadl dobře.</q>

        <.p><q>A co ti řekli ti naši šéfové?</q> ptá se tě zvědavě Boris. <q>Máš
        si vyhlédnout postel na ty 2–3 měsíce, než dorazí nová zásilka?</q>

        <.p><q>To ne, vzali si ode mě tu dobrou i ty vadné,</q> vysvětluješ,
        <q>a že to ještě proberou.</q>

        <.p><q>Aha, budou opravovat zaříkáváním?</q> pohrdavě komentuje technik.
        <<gReveal('look-for-room')>> "

    isActive = brokenComponents.isIn(commander)
;

++ GiveTopic [firstModule, secondModule, brokenComponents]
    "<.p>Pokoušíš se strčit {kohoco dobj} technikovi do rukou: <q>Dej s tím
        pokoj,</q> ohrazuje se, <q>mám dost své práce. S tímhle si poraď
        sám!</q> "
;

++ AskTellTopic [paper1, paper2, paper3, paper4, paper5]
    "<.p><q>Borisi,</q> oslovil jsi technika, <q>co to je za papírky, které jsem
        viděl na monitoru?</q>

        <.p><q>Od mých poznámek drž pracky dál,</q> zavrčel na tebe Boris. "
;

+++ AltTopic
    "<.p><q>Borisi,</q> natáhl jsi ruku, <q>co to tu máš za papírky?</q>

        <.p><q>Od mých poznámek drž pracky dál,</q> zavrčel na tebe Boris. "

    isActive = technician.isIn(controlRoom)
;

++ AskTellTopic @tWork
    "<.p><q>Borisi,</q> dotazuješ se technika, <q>co vlastně děláš?</q>

        <.p><q>Cože chceš?</q> Boris očividně bloumá ve svých myšlenkách,
        <q>neruš, mám práci.</q> "
;

++ AskTellAboutForTopic @tPassword
    "<.p><q>Borisi, slyšíš mě? Potřeboval bych heslo k tvému počítači,</q>
        neurčitě jsi nadhodil přes dveře.

        <.p><q>Cože chceš?</q> zaúpěl Boris, <q>dej pracky pryč od mého
        stroje!</q> "

    isActive = technician.isIn(toilet)
;

++ AskTellTopic @canteen
    "<.p><q>Borisi, můžu do jídelny?</q> zeptal ses technika.

        <.p><q>A co bys tam dělal? Jídlo stejně nedostaneš dřív, než bude
        čas,</q> hladově na tebe zavrčel Boris. "
;

++ AskTellTopic @tDrink
    "<.p><q>Jak je to s pitím?</q> zeptal ses Borise.

        <.p><q>O dodržování pitného režimu se stará každý sám,</q> odsekl
        technik, <q>jsme přece dospělí lidé!</q> "
;

/* ------------------------------------------------------------------------ */
/*
 *   Celá tato skupina je k dispozici, když Boris spí ve své kajutě.
 */
+ TopicGroup
    isActive = technician.isIn(techniciansRoom)
;

++ AskTellTopic [ coffeeBox, coffee1, coffee2, coffee3 ]
    "<.p><q>Borisi,</q> snažíš se mírně provokovat, <q>nedal by sis ještě loka
        té své kávy?</q>

        <.p>Na Borisovu odpověď jsi nečekal dlouho: <q>Dej mi laskavě
        pokoj.</q> "
;

++ AskTellGiveShowTopic [secondModule, fixedComponents]
    "<.p><q>Borisi,</q> mluvíš do ztemnělé kóje, <q>mám už ty tři součástky!</q>

        <.p><q>Tak doufám, že budou co nejdříve v modulu, ten v raketě a ta i s
        vámi daleko odsud,</q> ozvalo se v odpověď. <q>A já budu mít konečně
        klid na spaní.</q> "
;

++ AskTellTopic @tBoss
    "<.p><q>Jsou dobrý, co?</q> domáháš se odpovědi ze ztichlé kajuty, <q>sehnat
        takhle rychle náhradní součástky. Jak se jim to mohlo podařit?</q>

        <.p><q>Třeba jim je přinesl děda Mráz nebo expres zásilka České
        pošty,</q> ozval se Borisův povzdech, <q>ale je mi to úplně jedno, nech
        mě konečně spát!</q> "
;

/* ------------------------------------------------------------------------ */

+ DefaultAskTopic, ShuffledEventList
    [
        '<.p><q>Borisi,</q> nadechl ses, <q>mohl bych se ještě zeptat…?</q>
            <.p><q>Cože chceš?</q> Boris očividně bloumá ve svých myšlenkách,
            <q>nevím, asi 42.</q> ',
        '<.p><q>Jo, a Borisi,</q> začal jsi, ale technik se už předem brání:
            <.p><q>Nevím, netuším a nechci vědět.</q> ',
        '<.p>Pověděl jsi Borisovi svou otázku, ale ten jen odsekl:
            <.p><q>A jak bych to mohl vědět? Vypadám snad jako tetička
            Wiki?!</q> '
    ]
;

+ DefaultTellTopic
    "<.p><q>Borisi,</q> nadechl ses k dalším slovům, ale technik tě přerušil:
        <.p><q>Můžeš mě nechat aspoň chvíli napokoji?</q> "
;

+ DefaultAskForTopic
    "<.p><q>Borisi,</q> nadechl ses, <q>mohl bys mi půjčit <<gTopicText>>?</q>
        <.p>Ale technik nevypadá soustředěně: <q>Cože chceš? Nemám, nedám.</q> "
;

+ DefaultAnyTopic
    "<.p><q>Borisi,</q> oslovil jsi technika, ale ten tě očividně nevnímá:
        <.p><q>Hmm, to jsou mi věci, když to říkáš.</q> "
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK PŘICHÁZÍ DO KUPOLE
 *
 *   Během cesty se technik nenechá rušit, to zařídí HermitActorState. Cestu
 *   řídí TravelAgendaItem a aktivujese ihned, jak zapneme stav
 *   technicianWelcomes.
 */
+ technicianArriving: HermitActorState
    isInitState = true

    sayArrivingUpStairs(conn) { "Z průlezu nejprve opatrně vykoukla rozcuchaná
        hlava dalšího člověka, vzápětí vyplul nahoru celý. "; }
;

+ technicianWalkAgenda: TravelAgendaItem
    isReady = gRevealed('technician-incoming')
    initiallyActive = true
    agendaOrder = 10
    travelPath = [corridorWest, dome]

    destReached()
    {
        technician.setCurState(technicianWelcomes);
    }
;

+ technicianWelcomes: ActorState
    stateDesc = "Stojí poblíž a naslouchá rozhovoru. "
    /* Bude popsan v ramci skup. */
    specialDesc = ""
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK DOPROVÁZÍ HRÁČE DO DÍLNY
 *
 *   Technik nás vede do skladu, ale na nás je, abychom přesun mezi lokacemi
 *   zahájili. Boris jen ukazuje cestu. Každý přechod mezi místnostmi se skládá
 *   z dvojice stavů, jeden pro čekání na nás a druhý pro samotný přechod mezi
 *   lokacemi.
 */
+ technicianGuideToCorridorWest: GuidedTourState
    stateDesc = "Čeká u žebříku do dolního patra základny, až se k němu
        připojíš. "
    specialDesc { inherited; stateDesc; }

    escortDest = ladderDown
    stateAfterEscort = technicianGuideToSupplyRoom

    escortStateClass = TechnicianGuideToCorridorWestInTravel
;

class TechnicianGuideToCorridorWestInTravel: GuidedInTravelState
    sayDeparting(conn) { "Obratně jsi sklouzl za Borisem po žebříku dolů. "; }
    specialDesc = "<q>Vstup v mé doupě, řekl pavouk mouše,</q> mávl Boris rukou
        jižním směrem k svému pracovišti. "
;

+ technicianGuideToSupplyRoom: GuidedTourState
    stateDesc = "Čeká u skladu, až přestaneš koukat po okolí a vejdete
        dovnitř. "
    specialDesc { inherited; stateDesc; }

    escortDest = supplyRoom
    stateAfterEscort = technicianInSupplyRoom

    escortStateClass = TechnicianGuideToSupplyRoomInTravel
;

class TechnicianGuideToSupplyRoomInTravel: GuidedInTravelState
    sayDeparting(conn) { "Vešli jste do skladu. "; }

    specialDesc()
    {
        "<q>Vítej v mém království,</q> ukázal kolem sebe Boris, <q>všechno, co
            tady potřebujeme k přežití a něco navíc. Moje dílna, UniDiP, přístup
            na síť… To mi připomíná, máš svůj tablet? Hned jak sednu k počítači,
            tak mu povolím přístup do naší databáze, abys mohl hledat, cokoliv
            bys zjistil, že potřebuješ na opravu. Poradíš si, že jo? Pokud chceš
            něco vědět, tak se klidně ptej.</q><.topics> ";

        /* Zahájili jsme konverzaci sami, tak to musíme sdělit knihovně. */
        technician.noteConversation(gPlayerChar);
        gReveal('supply-reached');
    }
;


/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK UKAZUJE HRÁČI DÍLNU
 */
+ technicianInSupplyRoom: InConversationState
    stateDesc = "Ukazuje ti dílnu a vybavení, které máš na opravu k dispozici. "
    specialDesc = "Boris je tu s tebou. Ukazuje ti dílnu a vybavení, které máš
        na opravu k dispozici. "

    sayDepartingLocally(dest, conn)
    {
        /* Když jsi ve skladu a technik odchází na chodbu. */
        if(conn == corridorWest)
            "<.p>Technik vyrazil ze skladu. ";
    }

    /*
     *   Jakmile se postava začne nudit, ukončí rozhovor a je připravená na nové
     *   oslovení. My ale chceme, aby Boris odešel, tak mu přesměrujeme stav, do
     *   kterého se přepne.
     */
    nextState = technicianGoToControlRoom
;

++ technicianGoToControlRoom: HermitActorState, ConversationReadyState
    stateDesc = "Boris odchází do velínu věnovat se své práci. "
    specialDesc = "Boris odchází do velínu věnovat se své práci. "
    noResponse = "Nezaslechl tě, je právě je na cestě do velínu. "

    leaveReason = nil
    enterFromConversation(actor, reason, oldNode)
    {
        inherited(actor, reason, oldNode);
        leaveReason = reason;
    }

    activateState(actor, oldState)
    {
        inherited(actor, oldState);

        if(leaveReason == endConvBoredom)
            technicianTravel.invokeItem();
    }

    sayDepartingLocally(dest, conn)
    {
        /* Když jsi v západní části chodby a technik jde do velínu. */
        if(conn == controlPassageOutside)
            "Technik zamířil do velínu. ";

        /* Když jsi ve skladu a technik odchází na chodbu. */
        if(conn == corridorWest)
            "Technik vyrazil ze skladu. ";
    }
    sayArrivingLocally(dest, conn)
    {
        /* Když jsi ve velínu. */
        if(conn == corridorWest)
            "Technik dorazil do velínu a usadil se na pracovišti. ";

        /* Když jsi na západní straně chodby. */
        if(conn == supplyRoom)
            "Technik vyšel ze skladu. ";
    }
    sayArrivingDir(dir, conn)
    {
        /* Když jsi ve velínu. */
        "Technik vyšel ze skladu. ";
    }
    sayDepartingThroughPassage(conn)
    {
        /* Když jsi ve skladu a technik se ztrácí na chodbě zahne do velínu. */
        "Technik zahnul do velínu. ";
    }
    sayTravelingRemotely(dest, conn)
    {
        "Technik míří do velínu. ";
    }
;

+++ HelloTopic "K čemu zdravit uprostřed hovoru? ";

+++ ByeTopic
    "<.p><q>Tak díky, Borisi,</q> usmál ses na technika, <q>myslím, že bych
        si už mohl poradit sám.</q>

        <.p><q>Dobře,</q> kývl Boris v odpověď, <q>jdu dohlížet na vykládku těch
        vašich beden. Kdybys něco potřeboval, jsem vedle.</q> "
;

+++ BoredByeTopic
    "<.p><q>Koukám, že se beze mě obejdeš, jdu něco dělat,</q> oznamuje technik,
        <q>kdybys měl nějaký problém, jsem hned vedle ve velínu.</q> ";
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK ODCHÁZÍ PRACOVAT DO VELÍNU
 */
+ technicianTravel: TravelAgendaItem
    isReady = (technician.curState == technicianGoToControlRoom)
    initiallyActive = true
    agendaOrder = 10
    travelPath = [supplyRoom, corridorWest, controlRoom]

    destReached()
    {
        technician.moveIntoForTravel(crChair);
        technician.makePosture(sitting);
        technician.setCurState(technicianWorking);

        /*
         *   Boris je u počítače a povolí přístup z hráčova tabletu do databáze
         *   skladu. Také se objeví papírky na monitoru, které byly zatím
         *   schované, kdyby náhodou hráč nešel s Borisem do skladu a zahnul do
         *   velínu.
         */
        gReveal('database-access');
        PresentLater.makePresentByKey('paper');
    }
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK PRACUJE VE VELÍNU
 */
+ technicianTalking: InConversationState
    stateDesc = "Věnuje se práci a zároveň s tebou hovoří. "
    specialDesc = "Boris s tebou během práce hovoří. "
;

++ technicianWorking: ConversationReadyState
    stateDesc = "Zrovna sleduje obrazovky počítače a kamerového systému. "
    specialDesc = "Technik sleduje na obrazovce záběry kamer a několik textových
        výpisů současně. Občas je různě přepíná. Evidentně mu nedělá potíže
        sledovat několik věcí současně. "
;

+++ HelloTopic, StopEventList
    [
        '<.p><q>Borisi, promiň, že ruším,</q> přiblížil ses k technikovi,
            <q>měl bys chvilku?</q>

            <.p>Boris zvedl hlavu: <q>Copak potřebuješ, Tobiáši?</q> ',

        '<.p><q>Borisi?</q>, promluvil jsi na technika.
            <.p>Boris se otočil od práce k tobě: <q>Tak co ti zase nejde?</q> '
    ]
;

+++ ByeTopic, ShuffledEventList
    [
        '<.p><q>Díky moc, jdu pokračovat.</q>
            <.p>Boris obrátil svou pozornost zpět ke své práci. ',

        '<.p><q>Děkan, to mi pomohlo.</q>
            <.p>Boris obrátil svou pozornost zpět ke své práci. ',

        '<.p><q>Máš to u mě!</q>
            <.p>Boris obrátil svou pozornost zpět ke své práci. '
    ]
;

+++ ImpByeTopic, CyclicEventList
    [
        '<.p>Technik opět zaměřil svou pozornost na obrazovky počítačového
            terminálu, jakoby se jim nikdy věnovat nepřestal. ',

        '<.p>Boris obrátil svou pozornost zpět k obrazovkám. ',

        '<.p>Boris opět věnuje plnou pozornost obrazovkám. '
    ]
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK JE NA TOALETĚ
 */
+ technicianTalkingOnToilet: InConversationState
    stateDesc = "Je zavřený na záchodě a slabě úpí. "
    specialDesc = "Boris je zavřený na záchodě. "
;

++ technicianOnToilet: ConversationReadyState
    stateDesc = "Borise teď nevidíš, jen slyšíš přes dveře záchodu. Zvuky jsou
        dostatečně charakteristické. "
;

+++ HelloTopic, StopEventList
    [
        '<.p>Přiblížil ses ke dveřím záchodu a lehce na ně zaťukal:
            <q>Borisi, promiň, že ruším, můžu na tebe mluvit?</q> Napnul jsi
            sluch a zaposlouchal ses do zvuků zpoza dveří: <q>Škrňk, grrrr,
            škrund!</q> Ne, to nevypadá, že by s tebou chtěl technik
            komunikovat. Znovu jsi lehce zaškrábal na dveře.

            <.p><q>Hoří snad?</q> ozval se lehce podrážděný Borisův hlas, <q>tak
            povídej, co chceš, když už tu oxiduješ.</q> ',

        '<.p>Lehce jsi zaklepal na dveře záchodu: <q>Borisi, já vím, že ruším,
            ale ještě bych něco potřeboval.</q>

            <.p><q>Tady člověk nemá klid ani se pořádně ***,</q> zavrčel zpoza
            dveří technik, <q>povídej, co máš za problém.</q> '
    ]
;

+++ ByeTopic, ShuffledEventList
    [
        '<.p><q>Díky moc, jdu pokračovat.</q>
            <.p><q>To já bych taky rád pokračoval,</q> odpověděl Boris. ',

        '<.p><q>Děkan, to mi pomohlo.</q>
            <.p><q>Mně by nejvíc pomohla chvilka soukromí,</q> ozval se Boris. ',

        '<.p><q>Máš to u mě!</q>
            <.p><q>Jo, nápodobně, taky tě příjdu někdy rušit,</q> odvětil
            Boris. '
    ]
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK JE NA TOALETĚ, ALE VELITEL ZA ZÁDY
 */
+ technicianOnToiletCommanderNearby: HermitActorState
    stateDesc = "Je zavřený na záchodě a slabě úpí. "
    specialDesc = "Boris je zavřený na záchodě. "
    noResponse = "Teď není vhodná doba, když máš velitele za zády. "
;

/* ------------------------------------------------------------------------ */
/*
 *   TECHNIK SE SNAŽÍ SPÁT V KAJUTĚ
 */
+ technicianAwaken: InConversationState
    stateDesc = "Vzbudil jsi ho. "
    specialDesc = "Borise jsi probudil a vypadá dost nevlídně. "
    attentionSpan = nil
;

++ technicianSleeping: ConversationReadyState
    stateDesc = "Spí na svém lůžku. "
    specialDesc = "Boris spí na svém lůžku. "

    /* Opravdu není dobrý nápad na technika mluvit z rozvodů vzduchotechniky. */
    handleConversation(otherActor, topic, convType)
    {
        if(me.isIn(technicianConducts))
        {
            "Zbláznil ses? Snad se nechceš prozradit! ";
            return;
        }
        else inherited(otherActor, topic, convType);
    }
;

+++ HelloTopic, StopEventList
    [
        '<.p>Nahlédl jsi do Borisovi kajuty a ten jako správný vesmířan okamžitě
            zareagoval na prudké světlo z chodby, které mu dopadlo na obličej:
            <q>Co se děje?</q><.reveal hint-wakeup> ',

        '<.p>Potichounku jsi zkusil vejít k Borisovi, ale ten zatracený chlap i
            ve spaní reaguje na změnu světla: <q>Co zas chceš?</q> '
    ]
;

+++ ByeTopic, CyclicEventList
    [
        '<.p><q>Promiň, že jsem rušil, dobrou noc,</q> popřál jsi Borisovi
            klidné spaní. ',

        '<.p><q>Tak já jdu, ty klidně spi,</q> rozloučil ses s technikem. '
    ]
;

++ AskTellTopic @tSleep
    "<.p><q>Borisi,</q> protáhl jsi větu, <q>jaké bylo to tvé spaní?</q>

        <.p><q>Nádherné, v žádném snu ses ty ani nemihnul!</q> zavrčel Boris. "
;

++ DefaultGiveShowTopic
    "<.p>Udělal jsi krok a položil Borisovi do dlaně {kohoco dobj}: <q>Na,
        Borisi.</q>

        <.p><q>Teda, na spícího člověka má rychlé reakce,</q> pomyslel sis při
        bleskovém sehnutí před letícím předmětem. {Kdoco dobj} tě naštěstí
        minul{a dobj} a zarachotil{a dobj} někde na chodbě.
        <<gDobj.moveInto(corridorEast)>> "
;
