#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   JÍDELNA
 */
canteen: BaseRoom 'Jídelna' 'do jídelny'
    "Jídelna je velká asi jako dvě kajuty dohromady, kromě pár větších jídelních
        stolů uzpůsobených nízké gravitaci, vodomatu a nezbytného ohřívače tu
        není skoro nic. "

    south = canteenPassage
    out asExit(south)

    /*
     *   Atmosféra jsou texty vypisované v lokaci během činnosti hráče. Umí
     *   podtrhnout děj a dodat dojem živosti světa kolem, ale nesmíme jejich
     *   četnost přehnat, tak po čase četnost vypisování snížíme.
     */
    atmosphereList = gRevealed('lunch') && !technician.isIn(techniciansRoom)
        ? lunchAtmosphere : nil

    lunchAtmosphere: ShuffledEventList
    {
        /*
         *   Hned po vkročení do místnosti atmosféru potlačíme, protože v tu
         *   chvíli se toho děje trochu moc najednou.
         */
        [ nil ]
        [
            'Okolo se ozývá spokojené tiché srkání strávníků nasávajících
                dobroty z plastových sáčků. ',
            'Někdo zašustil pytlíkem s jídlem. ',
            'Poblíž se ozvalo zašplouchání protřepávaného pytlíku s nápojem. ',
            'Kdosi hlasitě nasál trochu jídla z pytlíku. ',
            'Klapání a šustění plastu naplňuje celou jídelnu. ',
            'Ozvalo se zabzučení vodomatu při ředění nápoje. ',
            'Cink! Ohřívač jídla dokončil svou práci. ',
            'Tiché plesknutí prozradilo neopatrnost některého strávníka, kterému
                sáček s jídlem omylem odplul pryč. '
        ]

        eventPercent = 100
        eventReduceAfter = 3
        eventReduceTo = 33

        /* Atmosféru potlačíme i při rozhovoru. */
        doScript()
        {
            if (!captain.conversedThisTurn() && !commander.conversedThisTurn())
                inherited();
        }
    }

    gender = 3
    vocabWords = 'jídelna/jídelny/jídelně/jídelnu/jídelnou'
    gcName = 'jídelny, jídelně, jídelnu, jídelně, jídelnou'
;

+ canteenPassage: ThroughPassage
    'vstup (na) chodbu' 'vstup na chodbu' *2
    "Vstup na jihu vede na chodbu. "

    gcName = 'vstupu na chodbu, vstupu na chodbu, vstup na chodbu,
        vstupu do na chodbu, vstupem na chodbu'
    gcVocab = 'vstupu vstupem -'
;

/* ------------------------------------------------------------------------ */

+ OpenableContainer, Fixture 'ohřívač/(jídla)' 'ohřívač jídla' *2
    "Ohřívač patří k nejdůležitějším přístrojům kosmického stravování.
        Elektromagnetickým zářením v oblasti mikrovln zahřívá obsah
        potravinových balíčků na poživatelnou teplotu. "
    
    /* Některé věci se do ohřívače vejdou, ale zdaleka ne vše. */
    maxSingleBulk = 15

    /* Aby bylo vidět dovnitř. */
    material = glass
    
    dobjFor(TurnOn)
    {
        /* Při zapnutí automaticky zavřeme dvířka. */
        preCond = [ objClosed ]

        /* Tohle normálně není zapnutelný objekt, tak zapnutí musíme povolit. */
        verify() {}

        action()
        {
            "Po chvilce hučení ohřívače jasné cinknutí oznámilo konec procesu.";
        }
    }
    
    gcName = 'ohřívače jídla, ohřívači jídla, ohřívač jídla, ohřívači jídla,
        ohřívačem jídla'
    gcVocab = 'ohřívače/ohřívači/ohřívačem'
;

/* ------------------------------------------------------------------------ */
/*
 *   Stůl je kontejner, na který lze pokládat věci.
 */
+ Fixture, Surface 'jídelní stůl/stoly' 'stůl' *2
    "Stůl je dost veliký, aby se u něj mohlo při jídle usadit více osob.
        Součástí stolů je jednoduchá lavice bez opěradla s popruhy. "

    maxSingleBulk = 10000

    gcName = 'stolu, stolu, stůl, stole, stolem'
    gcVocab = 'jídelního jídelnímu jídelním jídelních jídelními stolu/stole/
        stolem/stolů/stolům/stolech'
;

/* Balíček je kontejner, který můžeme otevřít. */
++ platter: PresentLater, OpenableContainer
    'potravinový vymačkávací vymačkaný krabička balíček/sáček/váček/obaly'
    'potravinový balíček' *2
    desc()
    {
        if(strawberries.isIn(self) && pasta.isIn(self))
            "Potravinový balíček osahuje plastový vymačkávací sáček s 
                těstovinami a krabičku s jahodami. ";
        else if(strawberries.isIn(self))
            "Potravinový balíček osahuje vymačkaný sáček od těstovin a krabičku
                s jahodami. ";
        else if(pasta.isIn(self))
            "Potravinový balíček osahuje plastový vymačkávací sáček s
                těstovinami a prázdnou krabičku od jahod. ";
        else
            "Balíček obsahuje už jen prázdné obaly od jídla. ";
    }

    /* Je vidět dovnitř, lze to očuchat, ale prostrčit ruku ne. */
    material = fineMesh

    bulk = 15

    /* Sněz svůj balíček. */
    owner = me

    dobjFor(Eat)
    {
        preCond = [touchObj]
        verify() {}
        action()
        {
//            nestedAction(Eat, pasta);
//            nestedAction(Eat, strawberries);
            throw new ReplacementCommandStringException('sněz jídlo',
                gIssuingActor, gActor);
        }
    }
    
    changeGender = 'obal:5, krab:3'
    gcName = 'potravinového balíčku, potravinovému balíčku, potravinový balíček,
        potravinovém balíčku, potravinovým balíčkem'
    gcVocab = 'potravinového potravinovému potravinovém potravinovým
        vymačkávacího vymačkávacímu vymačkávacím vymačkaného vymačkanému
        vymačkaném vymačkaným krabičky krabičce krabičku krabičkou balíčku/
        balíčkem/sáčku/sáčkem/váčku/váčkem'
;

+++ strawberries: Food 'jahody*jídlo oběd' 'jahody' *3
    "Jahody jsou spíš menší a vypadají lehce nedozrále, ale v hydroponii toho
        asi moc vypěstovat nejde. Energie ani náhradních výbojek Sunmaster není
        nikdy nadbytek. "

    /* Vzpomínáte na Hawkeye Pierce, jak všechno jídlo očuchával? */
    smellDesc = "Přivoněl jsi k jahodám. Hmmm, letní slunce, posečená tráva,
        prázdniny u babičky… "
    tasteDesc = "Ochutnal jsi jahody. No, jahodová žvýkačka je chuťově
        výraznější. "

    dobjFor(Eat)
    {
        preCond = [touchObj]
        action()
        {
            "Snědl jsi jahody. Úžasné, jahody vypěstované na hydroponii na
                asteroidu byly úplně stejné jako ty, které ti babička kupovala v
                prosinci v Tescu. ";

            inherited;
        }
    }

    isPlural = true
    changeGender = 'jídl:4, oběd:2'
    gcName = 'jahod, jahodám, jahody, jahodách, jahodami'
    gcVocab = 'jahod/jahodám/jahodách/jahodami*jídla*jídlu*jídlem'
;

+++ pasta: Food 'těstoviny*jídlo oběd' 'těstoviny' *3
    "Pěkně bachratý sáček naplněný lákavě vypadajícími těstovinami v jakési
        omáčce. Určitě budou plné zdravých vitamínů, minerálů, nezbytných tuků s
        trochou vlákniny i potřebných iontů. "

    tasteDesc = "Ochutnal jsi těstoviny. Jo, vypadá, že budou jedlé. Nejsou
        oblepené ani nekřupou. "
    smellDesc = "Přivoněl jsi k těstovinám. Ááá, tady někdo ví něco o koření.
        Bazalka, tymián, dobromysl, špetka majoránky. "

    dobjFor(Eat)
    {
        preCond = [touchObj]
        action()
        {
            "Snědl jsi těstoviny. Chutnalo ti. Ostatně po dietě cestou na lodi
                bys snědl i hřebíky přelité vyjetým olejem. ";

            inherited;
        }
    }

    isPlural = true
    changeGender = 'jídl:4, oběd:2'
    gcName = 'těstovin, těstovinám, těstoviny, těstovinách, těstovinami'
    gcVocab = 'těstovin/těstovinám/těstovinách/těstovinami*jídla*jídlu*jídlem'
;

+ bench: Chair, CustomFixture 'lavice' 'lavice' *3
    "Lavice je připevněná ke stolu a slouží spíš k připoutání na místě během
        jídla než ke skutečnému sezení. "

    /*
     *   Na lavici sedí i další postavy, tak musíme zvednout její kapacitu.
     *   Chair normálně povoluje jen jedinou postavu.
     */
    bulkCapacity = 40

    /*
     *   Hráče držíme u stolu, dokud nedojí, aby neodešel moc brzy. Musíme mu
     *   stihnout předat součástky na opravu lodi.
     */
    dobjFor(GetOutOf)
    {
        check()
        {
            inherited;
            
            if(gRevealed('lunch') && me.isIn(bench) 
                    && (strawberries.isIn(platter) || pasta.isIn(platter)))
                failCheck('Seď, není slušné odcházet od stolu, když jsi
                    nedojedl. ');
        }
    }

    gcName = 'lavice, lavici, lavici, lavici, lavicí'
    gcVocab = 'lavici/lavicí'
;

++ Component 'popruhy' 'popruhy' *2
    "Popruhy přidržují astronauta u lavice, aby při jídle v prostředí s velmi
        malou gravitací neodlétl od stolu. "

    isPlural = true
    gcName = 'popruhů, popruhům, popruhy, popruzích, popruhy'
    gcVocab = 'popruhů/popruhům/popruzích'
;

/* ------------------------------------------------------------------------ */
/*
 *   Opravené součástky, které přinese kapitán s velitelem hráči ze své
 *   "inspekční" cesty.
 */
fixedComponents: PresentLater, Thing
    'původ opravené nové náhradní zesilovače součástky/součástka/díl/díly/
        VIZ-54/VIZ54/VIZ/pouzdra' 'opravené součástky' *3
    "Jsou to tři výkonové integrované zesilovače VIZ-54 v keramicko-kovových
        pouzdrech s otvorem na přišroubování k chladiči. Všechny vypadají nově a
        hezky se lesknou. "

    isPlural = true

    dobjFor(PutIn)
    {
        action()
        {
            /* Pokud dáme součástky do modulu, splnili jsme úkol. */
            if(gIobj == secondModule)
            {
                achievement.awardPointsOnce();
            }
        }
    }
    achievement: Achievement { +1 "opravení modulu" }

    dobjFor(AttachTo) asDobjFor(PutIn)

    gcName = 'opravených součástek, opraveným součástkám, opravené součástky,
        opravevných součástkách, opravenými součástkami'
    gcVocab = 'opravených opraveným opravenými nových novým novými náhradních
        náhradním náhradními zesilovačů zesilovačům zesilovačích zesilovači
        součástek/součástkám/součástkách/součástkami/součástce/součástku/
        součástkou/dílu/dílem/dílů/dílům/dílech/pouzder/pouzdrům/pouzdrech/
        pouzdry'
;
