#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   SPOLEČNÝ OBSAH VENKOVNÍCH LOKACÍ
 */
class PortRoom: Room
{
    pressure = 0
    roomParts = [asteroidGround, asteroidSky]
}

asteroidSky: Distant, RoomPart
    'obloha/nebe/nebesa/vesmír' 'obloha' *3
    "Pohlédl jsi na vesmír nad hlavou, všude kolem je jen temná prázdnota posetá
        nekonečným množstvím neustále se pohybujících hvězd. Rotace asteroidu
        kolem osy za něco málo přes 4 hodiny udělá své. "

    gcName = 'oblohy, obloze, oblohu, obloze, oblohou'
    gcVocab = 'oblohy/obloze/oblohu/oblohou/nebi/nebem/nebes/nebesům/nebesech/
        nebesy/vesmíru/vesmírem'
;

asteroidGround: Floor
    'šedý povrch asteroidu/asteroid/skála/prach/kameny/svah/kráter'
    'povrch asteroidu' *2
    "Povrch asteroidu tvoří převážně šedý prach usazený mezi většími kameny
        neustále se lepící na skafandr i vše kolem. V bezprostřední blízkosti
        základny je povrch více urovnaný, o kousek dál jsou vidět navrstvené
        ostré kameny nejrůznější velikosti a dokonce svah malého kráteru.
        Procházka mezi tolika ostrými hranami by mohla být pro člověka ve
        skafandru hodně nebezpečná navzdory nepatrné gravitaci. "

    objOutOfPrep = 'ze'
    
    changeGender = 'skál:3, kamen:5'
    gcName = 'povrchu asteroidu, povrchu asteroidu, povrch asteroidu,
        povrchu asteroidu, povrchem asteroidu'
    gcVocab = 'šedého šedému šedém šedým povrchu povrchem asteroidem/skály/
        skále/skálu/skálou/prachu/prachem/kamenů/kamenům/kamenech/svahu/svahem/
        kráteru/kráterem'
;
