#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   PLAC PŘED ZÁKLADNOU
 */
besideAirlock: PortRoom 'Před základnou' 'před základnu'
    "Stojíš u kupole základny nedaleko přechodové komory. Na severu je na rampě
        ukotvená loď, na západě je otevřený vstup do přechodové komory. V dáli
        na východě leží překladiště kontejnerů.<.reveal hint-port-visited>
        <<if !gRevealed('lunch')>>Automaty vykládají kontejnery a postupně
        nahrazují přivezené těmi k odvezení. "

    west = airlockOuterDoorOutside
    in asExit(west)

    /* Při cestě na rampu pod loď vypisujeme doprovodnou hlášku. */
    north: TravelMessage { -> underShipBack "Opatrně jsi vyskočil do výšky a
        zachytil ses úchytů na rampě pod zakotvenou lodí. " }
    up asExit(north)
    
    /* Měkká bariéra, hráč zkusí tím směrem jít, ale vrátíme ho zpět. */
    east: DeadEndConnector { 'k překladišti' "Vydal ses na východ k překladišti,
        ale v cestě je příliš mnoho vysokých a ostrých kamenů, tudy se k nim
        nedostaneš, za riziko poškození skafandru to nestojí, takže ses zase
        vrátil zpátky. " }

    /*
     *   Atmosféra jsou texty vypisované v lokaci během činnosti hráče. Umí
     *   podtrhnout děj a dodat dojem živosti světa kolem, ale nesmíme jejich
     *   četnost přehnat, tak po čase četnost vypisování snížíme.
     */
    atmosphereList = !gRevealed('lunch') ? automatasAtmosphere : nil
    automatasAtmosphere: ShuffledEventList
    {
        [
            'Jeden z automatů se zachytil rampy a vyjel k nákladnímu
                prostoru. ',
            'Dva automaty synchronizovaně přesouvají jeden z těžších
                kontejnerů. ',
            'Na povrch vykoukl další prázdný automat a vydal se k lodi. ',
            'Jeden z automatů do volného nákladního prostoru právě umístil
                kontejner s materiálem. ',
            'Automat zahájil pozvolné brždění s nákladem. ',
            'Automat s kontejnerem se pomalu rozjíždí od rampy. ',
            'Jeden z automatů se zachytil lodi, aby mohl vysunout prázdný
                kontejner. ',
            'Automat pozvolna změnil směr pryč od lodi. ',
            'Dva automaty se pomalu vyhýbají. ',
            'Automat synchronizovaně zmizel pod povrchem. '
        ]
        eventPercent = 50
        eventReduceAfter = 7
        eventReduceTo = 20
    }

    /*
     *   Do této metody si můžeme přidat cokoliv, hra ji spouší po každém tahu,
     *   když je hráč v této místnosti.
     */
    roomDaemon()
    {
        /* Při první návštěvě posuneme hodiny. */
        if(!gRevealed('first-time-outside'))
        {
            gReveal('first-time-outside');
            clock1.eventReached();
        }

        /* Když musí hráč podruhé ven, najde podezřelý kontejner. */
        if(gRevealed('module1-ok') && !suspiciousContainer.discovered)
        {
            "<.p>Vykládka probíhá zcela plynule. Zastavil ses a chvíli sledoval
                synchronizovaný tanec vykládacích automatů. Něco tu ale neladí.
                Pátravě se rozhlížíš, než ti došlo, že to je jeden z automatů
                s kontejnerem mimo trasu. Očividně nepatří k těm, co jste sem
                přivezli, ale podle rýh na zemi byl před chvíli vyložen z vaší
                lodi. Už to označení KBR-3867! Nic takového jste přece nevezli –
                vy jste měli přece kódové znaky ze série PHM. Kde se to tu
                vzalo? KBR-3867?

                <.p>Odvrátil jsi pohled. Marně se snažíš najít vysvětlení
                přebývající bedny. Co v ní asi je?
                <<if gRevealed('fuel-consumption')>>Mohla být příčinou té vyšší
                spotřeby při letu sem?<<end>> Musíš si zapamatovat její číslo a
                kouknout se do nějaké databáze. Třeba najdeš vysvětlení! ";

            automata.discover();
            suspiciousContainer.discover();
            clock2.eventReached();
        }
        else inherited;
    }
    clock1: ClockEvent { eventTime = [2, 8, 2] }
    clock2: ClockEvent { eventTime = [2, 8, 56] }
    
    name = 'prostor před základnou'
    gender = 2
    gcName = 'prostoru před základnou, prostoru před základnou, prostor před
        základnou, prostoru před základnou, prostorem před základnou'
    gcVocab = 'prostor prostoru prostorem (před) základnou'
;

+ EntryPortal -> airlockOuterDoorOutside
    'přechodová komora' 'přechodová komora' *3
    "Nakoukl jsi do přechodové komory, místa je uvnitř nejvýš pro dva lidi ve
        skafandrech. Dveře jsou <<if airlockOuterDoorOutside.isOpen()
        >>otevřené<<else>>zavřené<<end>>. "

    gcName = 'přechodové komory, přechodové komoře, přechodovou komoru,
        přechodové komoře, přechodovou komorou'
    gcVocab = 'přechodové přechodovou komory/komoře/komoru/komorou'
;

++ airlockOuterDoorOutside: ComponentDeferrer, IndirectLockable, Door
    -> airlockOuterDoor
    'dveře přechodové komory/dveře' 'dveře přechodové komory' *3
    "Vypadají jako běžné tlakové dveře, natřené čistě bílou, s kovovými
        výztuhami a maličkým okénkem. Ovládají se pákou uvnitř přechodové
        komory. "

    isPlural = true
    gcName = 'dveří přechodové komory, dveřím přechodové komory, dveře
        přechodové komory, dveřích přechodové komory, dveřmi přechodové komory'
    gcVocab = 'dveří dveřím dveřích dveřmi'
;

+ Enterable -> airlockOuterDoorOutside 'kupole/kopule' 'kupole' *3
    "Kupole je jedinou obytnou částí základny nad povrchem. Hladký povrch ruší v
        jednom místě přechodová komora a o kousek dál tunel spojující ukotvenou
        loď se základnou. "

    hideFromAll(action) { return true; }
    
    gcName = 'kupole, kupoli, kupoli, kupoli, kupolí'
    gcVocab = 'kupoli/kupolí/kopuli/kopulí'
;

+ Enterable -> airlockOuterDoorOutside
    'obytnou část těžební základna/komplex/prostory/prostor/zařízení'
    'základna' *3
    "Základna je komplex obytných prostor ukrytých ve skále asteroidu pro
        dlouhodobý pobyt malé posádky a těžebního zařízení z části na povrchu.
        Konstrukce se téměř neliší od mnoha jiných osvědčených staveb na Marsu,
        Měsíci a dalších místech. "
    
    hideFromAll(action) { return true; }
    
    gcName = 'základny, základně, základnu, základně, základnou'
    gcVocab = 'obytné čísti částí těžebního těžebnímu těžebním základny/
        základně/základnu/základnou/komplexu/komplexem/prostorů/prostorům/
        prostorech/zařízením'
;

/* Distant jsou objekty, které jsou vidět, ale nelze na ně sáhnout. */
+ Distant '(přechodový) tunel' 'tunel' *2
    "Vzduchotěsný ohebný tunel umožňující pohodlný přestup z lodi do základny
        bez použití skafandrů. "

    gcName = 'tunelu, tunelu, tunel, tunelu, tunelem'
    gcVocab = '(přechodového) (přechodovému) (přechodovém) (přechodovým) tunelu/
        tunelem'
;

+ Distant 'ocelová rampa/konstrukce' 'rampa' *3
    "Mohutná ocelová konstrukce sloužící k ukotvení lodi a usnadnění jejího
        startu. "

    dobjFor(ClimbUp) remapTo(TravelVia, besideAirlock.north)

    gcName = 'rampy, rampě, rampu, rampě, rampou'
    gcVocab = 'ocelové ocelovou rampy/rampě/rampu/rampou/konstrukci/konstrukcí'
;

+ Distant
    'ukotvená vesmírná vesmírné kosmická kosmické loď/konzerva/plavidlo'
    'vesmírná loď' *3
    "Malá, ale výkonná kosmická loď pro přepravu těžkých nákladů na velké
        vzdálenosti. Touto lodí jsi přiletěl a nyní je ukotvena na rampě. "

    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tablet na loď, software loď rozpoznal a dohledal
                sériové číslo, datum nasazení do provozu a podobné
                zbytečnosti. ";
        }
    }

    gcName = 'vesmírné lodi, vesmírné lodi, vesmírnou loď, vesmírné lodi,
        vesmírnou lodí'
    gcVocab = 'ukotvené ukotvenou vesmírné vesmírnou vesmírného vesmírnému
        vesmírném vesmírným lodi/lodí/konzervy/konzervě/konzervu/konzervou/
        plavidla/plavidlu/plavidlem'
;

++ Distant, Component
    'nákladní nákladový prostor/(lodi)' 'nákladní prostor' *2
    "Nákladní prostor lodi je ta část, která slouží k přepravě nákladu. "

    gcName = 'nákladního prostoru, nákladnímu prostoru, nákladní prostor,
        nákladním prostoru, nákladním prostorem'
    gcVocab = 'nákladního nákladnímu nákladním nákladového nákladovému
        nákladovém nákladovým prostoru/prostorem'
;

+ Distant 'překladiště (kontejnerů)' 'překladiště kontejnerů' *4
    "Překladiště je prakticky jen urovnaná planina, kde je možné kontejnery
        dočasně ukotvit a kde se mohou automaty pohybovat. "

    gcName = 'překladiště kontejnerů, překladišti kontejnerů, překladiště
        kontejnerů, překladišti kontejnerů, překladištěm kontejnerů'
    gcVocab = 'překladišti překladištěm -'
;

/* ------------------------------------------------------------------------ */

+ automatas: Distant 'automaty' 'automaty' *2

    /*
     *   Zde máme variabliní popisek. Protože je delší, uděláme tu metodu, aby
     *   bylo jeho větvení čitelnější.
     */
    desc()
    {
        if(suspiciousContainer.discovered
            && suspiciousContainer.location == nil)
            "Práce automatů zas o trochu pokročila. Vše je již vyloženo a k
                naložení nezbývá mnoho. Už naložené kontejnery automaty
                sestavují do pevného celku. ";
        else if(gRevealed('module1-ok'))
            "Práce automatických manipulátorů pokračují pořád stejným tempem,
                ale přesto už je značná část nákladu přeložena a loď bude jistě
                připravena k odletu s naloženou surovinou včas. Kontejnery se
                zásobami, zdá se, jsou všechny shromážděny u zásobovacího vstupu
                do podzemí.

                <.p>Jen jeden z automatů se stojí i s kontejnerem mimo trasu,
                kudy se pohybují ostatní, oranžově bliká a nehýbe se. Zvláštní,
                jako by nedokázal kontejner podle čísla správně zařadit. ";
        else
            "Automaty teď vykládají kontejnery z lodi a přemisťují je podle
                obsahu, kam patří. Každý kontejner evidují podle identifikačních
                čísel. Jde jim to pomalu, protože příliš nízká gravitace rychlý
                pohyb znesnadňuje, skoro tak, jako by práce probíhaly v úplné
                beztíži. ";
    }
    
    iobjFor(AimAt)
    {
        /*
         *   Protože automat je Distant, musíme explicitně překrýt verify, aby
         *   se neuplatnilo iobjFor(Default).
         */
        verify { inherited(); }
        action()
        {
            "Namířil jsi tablet na jeden z automatů. Tablet po chvilce zobrazil
                zelené ok a hlášku <q>nevyžaduje zásah operátora</q>. ";
        }
    }
    
    dobjFor(Follow) remapTo(TravelVia, besideAirlock.east)

    isPlural = true
    gcName = 'automatů, automatům, automaty, automatech, automaty'
    gcVocab = 'automatů/automatům/automatech'
;

/* Unthing reprezentuje něco, co tu nění, ale hráč by se na to mohl zeptat. */
+ unAutomatas: PresentLater, Unthing 'automat/automaty' 'automaty' *2
    'Žádný automat tu už není, nejspíš jsou po dokončení překládky
        někde zaparkované. '

    isPlural = true
    gcName = 'automatů, automatům, automaty, automatech, automaty'
    gcVocab = 'automatu/automatem/automatů/automatům/automatech'
;

+ automata: Hidden, Distant 'zaseknutý automat' 'zaseknutý automat' *2
    "Nepohybující se automat stojí s kontejnerem mimo trasu a oranžově bliká.
        Zdá se, že neví, kam má kontejner umístit a pouze zastavil stranou od
        ostatních, aby neblokoval práci, dokud za něj nerozhodne obsluha. "

    iobjFor(AimAt)
    {
        /*
         *   Protože automat je Distant, musíme explicitně překrýt verify, aby
         *   se neuplatnilo iobjFor(Default).
         */
        verify { inherited(); }
        action()
        {
            "Namířil jsi tablet na zaseknutý automat. Tablet po chvilce zobrazil
                varovný vykřičník a hlášku <q>vyžaduje rozhodnutí oprávněné
                osoby</q>. ";
        }
    }

    dobjFor(Follow) remapTo(TravelVia, besideAirlock.east)

    gcName = 'zaseknutého automatu, zaseknutému automatu, zaseknutý automat,
        zaseknutém automatu, zaseknutým automatem'
    gcVocab = 'zaseknutého zaseknutému zaseknutém zaseknutým automatu/automatem'
;

/* ------------------------------------------------------------------------ */

+ Decoration 'kontejnery' 'kontejnery' *2
    "Univerzální přepravní kontejnery z tvarovaného plechu, mají tvar kvádru,
        lze je spojovat s dalšími kontejnery a nejsou hermetizované. "

    isPlural = true
    gcName = 'kontejnerů, kontejnerům, kontejnery, kontejnerech, kontejnery'
    gcVocab = '(kontejnerů)/kontejnerům/kontejnerech'
;

++ Component 'tvarovaný plech' 'kontejnery' *2
    "Univerzální přepravní kontejnery z tvarovaného plechu, mají tvar kvádru,
        lze je spojovat s dalšími kontejnery a nejsou hermetizované. "

    gcName = 'kontejnerů, kontejnerům, kontejnery, kontejnerech, kontejnery'
    gcVocab = 'tvarovaného tvravanému tvarovaném tvarovaným plechu/plechem'
;

++ Component 'identifikační čísla' 'identifikační čísla' *3
    desc()
    {
        if(suspiciousContainer.discovered
            && suspiciousContainer.location == nil)
            "Není na nich nic zvláštního. Ten podezřelý kontejner KBR-3867 už tu
                není. ";
        else if(gRevealed('module1-ok'))
            "Jeden z kontejnerů má označení KBR-3867… že by se sem kontejner
                zatoulal nedopatřením? Prvními písmeny se označuje cíl cesty a
                bývají v celé zásilce stejná. A nebyl v přepravních listech,
                takovou zvláštnost by sis určitě pamatoval. ";
        else
            "Nevidíš odsud vše, zdá se, že všechny bedny mají čísla začínající
                písmeny PHM, stejně jako si pamatuješ z přepravních listů. ";
    }

    isPlural = true
    gcName = 'identifikačních čísel, identifikačním číslům, identifikační čísla,
        identifikačních číslech, identifikačními čísly'
    gcVocab = 'identifikačních identifikačním identifikačními čísel/číslům/
        číslech/čísly'
;

+ suspiciousContainer: Hidden, Distant
    'podezřelý podezřelá transportní kontejner (s) (materiálem) (nákladem)
        kontejner/bedna/KBR-3867/KBR3867/KBR' 'podezřelý kontejner' *2
    "Na první pohled vypadá, jako docela obyčejný přepravní kontejner, stejně
        jako ostatní, ale zdá se být trochu otlučenější a celkově
        opotřebovanější, jako by za sebou měl už mnoho cest vesmírem. Je na něm
        štítek s číslem KBR-3867. "

    dobjFor(Open)
    {
        verify()
        {
            illogical('Na tu dálku vypadá neotevíratelně a motat se mezi
                pracujícími automaty by nebylo bezpečné. ');
        }
    }

    changeGender = 'bedn:3'
    gcName = 'podezřelého kontejneru, podezřelému kontejneru, podezřelý
        kontejner, podezřelém kontejneru, podezřelým kontejnerem'
    gcVocab = 'podezřelého podezřelému podezřelém podezřelým podezřelé
        podezřelou kontejneru/kontejnerem/bedny/bedně/bednu'
;

+ unSuspiciousContainer: PresentLater, Unthing
    'podezřelý podezřelá transportní kontejner (s) (materiálem) (nákladem)
        kontejner/bedna/KBR-3867/KBR3867/KBR' 'podezřelý kontejner' *2
    'Podezřelý kontejner KBR-3867 tu už není, stihli ho odvézt dřív, než jsi
        mohl pořádně zahlédnout, kdo ho odvezl. '

    changeGender = 'bedn:3'
    gcName = 'podezřelého kontejneru, podezřelému kontejneru, podezřelý
        kontejner, podezřelém kontejneru, podezřelým kontejnerem'
    gcVocab = 'podezřelého podezřelému podezřelém podezřelým kontejneru/
        kontejnerem'
;
