#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   SPOLEČNÉ ČÁSTI CHODEB
 */
corridorHolders: RoomPart, Decoration
    'madla držadla (na) (chodbě) (stěnách) madla/držadla' 'madla' *4
    "Pevná držadla připevněná po celé délce chodby na dosah rukou, aby si
        jimi mohli astronauti pomáhat při pohybu chodbou. Nízká gravitace
        asteroidu nedovoluje normální chůzi. Pohyb se spíš podobá dlouhým
        plavným skokům, skoro jako v úplné beztíži. "

    /*
     *   První se zobrazuje, když parser oznamuje název objektu při vícenásobném
     *   příkazu (např. prozkoumej vše) a druhé v otázce "a co tím máš na
     *   mysli?"
     */
    disambigName = 'madla na chodbě'
    disambigNameKohoCo = 'madla na chodbě'

    isPlural = true
    gcName = 'madel, madlům, madla, madlech, madly'
    gcVocab = 'madel madlům madlech madly držadel držadlům držadlech držadly
        madel/madlům/madlech/madly/držadel/držadlům/držadlech/držadly'
;

corridorLights: RoomPart, Decoration
    'osvětlovací panely/osvětlení/světlo' 'osvětlovací panely' *2
    "Osvětlovací panely osvětlují chodbu příjemným žluto bílým, rozpýleným
        světlem. Z povrchu stropu nijak nevyčnívají, aby se o ně astronauti
        nemohli při pohybu chodbou zranit. "

    sightSize = small
    dobjFor(Break)
    {
        verify() { illogical('To opravdu není dobrý nápad, musel bys zaplatit
            nejenom nové panely, ale i jejich drahou dopravu sem na základnu ze
            svého.'); }
    }
    dobjFor(TurnOff)
    {
        verify() { illogical('Bohužel se osvětlovací panely vypnout nedají, když
            je na základně posádka, svítí pořád.'); }
    }

    isPlural = true
    gcName = 'osvětlovacích panelů, osvětlovacím panelům, osvětlovací panely,
        osvětlovacích panelech, osvětlovacími panely'
    gcVocab = 'osvětlovacích osvětlovacím osvětlovacími panelů/panelům/panelech/
        osvětlením/světla/světlu/světlem'
;

/*
 *   Protože nevíme, odkud hráč vyjde v momentě, kdy splní trojici úkolů (a
 *   tudíž na kterém konci chodby se bude nacházet), dáme reakci do společné
 *   třídy, ze které se odvodí oba konce chodby.
 */
CorridorRoom: BaseRoom
    roomParts = static inherited + corridorLights + corridorHolders

    roomDaemon()
    {
        /* Jakmile hráč vyjde na chodbu, když je vše potřebné splněno. */
        if(!gRevealed('lunch') && gRevealed('tresor-solved2')
            && gRevealed('computer-solved2') && gRevealed('robot-solved2'))
        {
            "Ozvalo se zarachocení a tobě ztuhla krev v žilách. To bylo o fous.
                Kdyby ses o chviličku zdržel, ufff -- ani nepomyslet. Do dveří
                vcházejí kapitán s velitelem, očividně v dobrém rozpoložení:
                <q>Tak pojď, mladej, právě čas k obědu. A až se dozvíš novinky,
                bude ti chutnat dvojnásob,</q> pobízí tě gestem velitel, abys
                vešel za kapitánem do jídelny. ";

            /*
             *   Musíme si zapamatovat, že kapitán odešel do jídelny, kdyby hráč
             *   chtěl následovat kapitána místo velitele. Aby to bylo účinné,
             *   je potřeba nejprve umístit kapitána sem.
             */
            captain.moveIntoForTravel(corridorWest);
            me.trackFollowInfo(captain, corridorWest.north, corridorWest);

            /* Kapitána posadíme na laviču a začne jíst. */
            captain.moveIntoForTravel(bench);
            captain.makePosture(sitting);
            captain.setCurState(captainInCanteen);

            /* Velitel na nás čeká u vchodu do jídelny. */
            commander.moveIntoForTravel(corridorWest);
            commander.setCurState(commanderGuideToCanteen);

            /* Ať už hráč vyšel odkudkoliv, přesuneme ho na západní konec. */
            me.moveIntoForTravel(corridorWest);

            technician.setCurState(technicianOnToiletCommanderNearby);

            brokenComponents.moveInto(nil);
            newComponent.moveInto(nil);
            automatas.moveInto(nil);
            unAutomatas.makePresent();

            gReveal('lunch');
            clockContainer.clock1.eventReached();
        }

        /* Jakmile hráč vyjde z jídelny s náhradními součástkami. */
        if(fixedComponents.location != nil && !technician.isIn(techniciansRoom))
        {
            "<.p>Ze dveří vyšel Boris. Tedy vyšel, je hodně nadnesené. Táhl své
                unavené tělo jak zhroucený pytel: <q>Máte naloženo,</q> zamával
                na tebe identifikační kartou. Šňůrka od karty povlávala kolem,
                naštěstí ne tak dlouhá, aby se unavenému technikovi zamotala pod
                nohy. <q>Tímhle se odhlásím ze služby,</q> zdůraznil mávnutím
                karty, <q>tímhle tělem prásknu do postele a dělejte si tu, co
                chcete. Mám volnou čtyřiadvacítku,</q> dořekl Boris a potácel se
                k své kajutě. Ještě jsi zavírajícími se dveřmi zahlédl, jak hází
                kartu na stolek, a pak už následovala jen dvě bouchnutí -- to
                první byly dveře, to druhé zřejmě Borisovo tělo ukládající se do
                postele. Jak to dokáže v téhle gravitaci, je ti záhadou, ale
                bylo to efektní. ";

            toiletDoor.makeLocked(nil);
            toiletDoor.makeOpen(true);

            technician.moveIntoForTravel(trBed);
            technician.makePosture(lying);
            technician.setCurState(technicianSleeping);

            card.makeWornBy(nil);
            card.moveInto(trTable);

            techniciansDoor.makeOpen(nil);
            PresentLater.makePresentByKey('conducts');

            platter.moveInto(nil);
            clockContainer.clock2.eventReached();
        }

        inherited;
    }

    /* Protože postavy nepostojí a jdou, není třeba je více popisovat. */
    roomActorThereDesc(actor)
    {
        if(!gRevealed('supply-reached') || gRevealed('commander-in-his-room'))
            inherited(actor);
    }

    gender = 3
    vocabWords = 'chodba/chodby/chodbě/chodbu/chodbou'
;

/*
 *   Potřebujeme jedny společné ClockEventy, takže je nemůžeme definovat na
 *   třídě, ze které vzniknou dvě instance.
 */
clockContainer: object
    clock1: ClockEvent { eventTime = [2, 12, 7] }
    clock2: ClockEvent { eventTime = [2, 12, 32] }
;

/* ------------------------------------------------------------------------ */
/*
 *   ZÁPADNÍ ČÁST CHODBY
 */
corridorWest: CorridorRoom
    'Západní část chodby' 'do západní části chodby' 'ze západní části chodby'
    "Jsi na západním konci hlavní chodby spojující všechny prostory v obytné
        části základny. Stěny jsou obložené světlými plastovými panely, ve
        stropě jsou některé z nich prostřídány s panely osvětlovacími, podlaha
        je pokrytá tlumícím neklouzavým materiálem a na mnoha místech jsou madla
        usnadňující pohyb stejně jako v úplné beztíži. Vedou odsud vstupy do
        velína na západ, jídelny na severu, do skladu na jihu a žebřík nahoru do
        kupole. Na severozápadě je malý záchod. Chodba pokračuje na východ. "

    east = corridorEast
    west = controlPassageOutside
    south = supplyRoom
    northwest = toiletDoorOutside
    north = canteenPassageOutside
    up = dome

    roomParts = static inherited - defaultEastWall

    gcName = 'západní části chodby, západní části chodby, západní část chodby,
        západní části chodby, západní částí chodby'
    gcVocab = 'části částí -'
;

+ ladderUp: StairwayUp -> ladderDown 'žebřík' 'žebřík' *2
    "Lehký kovový žebřík zavěšený ve stropním průlezu, dole připevněný k
        podlaze. Vede nahoru do kupole. "

    sightSize = small

    gcName = 'žebříku, žebříku, žebřík, žebříku, žebříkem'
    gcVocab = 'žebříku/žebříkem'
;

+ Enterable -> ladderUp 'kupole/kopule' 'kupole' *3
    "Do kupole vede žebřík.<<me.setHim(ladderUp)>> "

    sightSize = small
    hideFromAll(action) { return true; }

    gcName = 'kupole, kupoli, kupoli, kupoli, kupolí'
    gcVocab = 'kupoli/kupolí/kopuli/kopulí'
;

+ toiletDoorOutside: IndirectLockable, Door -> toiletDoor
    'posuvné dveře' 'posuvné dveře' *3
    "I kosmonauti chtějí mít na toaletě soukromí. "

    isPlural = true
    sightSize = small

    cannotOpenLockedMsg = 'Vzal jsi za kliku, zatáhl, ale dveře jsou zamčené.
        <.p><q>Obsa-ze-no,</q> ozvalo se na několikrát z druhé strany dveří. '
    cannotLockMsg = '{Kdoco dobj} nemají žádný zámek, alespoň ne z této
        strany. '
    cannotUnlockMsg = (cannotLockMsg)

    /* Boris je na toaletě, ale hráč s ním může mluvit. */
    getExtraScopeItems(actor)
    {
        return technician.isIn(toilet) ? technician : [];
    }

    dobjFor(Attack)
    {
        verify() { illogical('Rozkročil ses, abys mohl pořádně kopnout do dveří,
            a pak ti došlo, že takové věci se nedělají! '); }
    }
    dobjFor(Break)
    {
        verify() { illogical('Záchod s funkčními dveřmi se může hodit i tobě.
            Jejich rozbití by bylo k ničemu. '); }
    }

    gcName = 'posuvných dveří, posuvným dveřím, posuvné dveře, posuvných
        dveřích, posuvnými dveřmi'
    gcVocab = 'posuvných posuvným posuvnými dveří/dveřím/dveřích/dveřmi'
;

+ Enterable -> toiletDoorOutside 'malý záchod/toaleta/wc' 'záchod' *2
    "Severozápadní dveře vedou na záchod.<<me.setThem(toiletDoorOutside)>> "

    sightSize = small
    hideFromAll(action) { return true; }

    dobjFor(Open) remapTo(Open, toiletDoorOutside)

    changeGender = 'toal:3, wc:4'
    gcName = 'záchodu, záchodu, záchod, záchodu, záchodem'
    gcVocab = 'malého malému malém malým záchodu/záchodem/toalety/toaletě/
        toaletu/toaletou'
;

+ canteenPassageOutside: ThroughPassage -> canteenPassage
    'vstup (do) jídelny' 'vstup do jídelny' *2
    "Vstup na severu vede do jídelny. "

    hideFromAll(action) { return true; }
    
    gcName = 'vstupu do jídelny, vstupu do jídelny, vstup do jídelny,
        vstupu do jídelny, vstupem do jídelny'
    gcVocab = 'vstupu vstupem -'
;

+ Enterable -> canteenPassageOutside 'jídelna' 'jídelna' *3
    "Vstup na severu vede do jídelny.<<me.setHim(canteenPassageOutside)>> "

    sightSize = small
    hideFromAll(action) { return true; }

    gcName = 'jídelny, jídelně, jídelnu, jídelně, jídelnou'
    gcVocab = 'jídelny/jídelně/jídelnu/jídelnou'
;

+ controlPassageOutside: ThroughPassage -> controlPassage
    'vstup (do) velínu' 'vstup do velínu' *2
    "Vstup na západě vede do velínu. "

    hideFromAll(action) { return true; }
    
    gcName = 'vstupu do velínu, vstupu do velínu, vstup do velínu,
        vstupu do velínu, vstupem do velínu'
    gcVocab = 'vstupu vstupem -'
;

+ Enterable -> controlPassageOutside 'velín' 'velín' *3
    "Vstup na západ vede do velínu.<<me.setHim(controlPassageOutside)>> "

    sightSize = small
    hideFromAll(action) { return true; }

    gcName = 'velínu, velínu, velín, velínu, velínem'
    gcVocab = 'velínu/velínem/velína'
;

/* ------------------------------------------------------------------------ */
/*
 *   VÝCHODNÍ ČÁST CHODBY
 */
corridorEast: CorridorRoom
    'Východní část chodby' 'do východní části chodby' 'z východní části chodby'
    "Jsi na východním konci hlavní chodby spojující všechny prostory v obytné
        části základny. Stěny jsou obložené světlými plastovými panely, ve
        stropě jsou některé z nich prostřídány s panely osvětlovacími, podlaha
        je pokrytá tlumícím neklouzavým materiálem a na mnoha místech jsou madla
        usnadňující pohyb stejně jako v úplné beztíži. Odsud vedou dveře do
        kajuty velitele na sever, kajuty technika na jih a na východě jsou velké
        zelené dveře vedoucí do druhé části základny. Chodba pokračuje na
        západ. "

    west = corridorWest
    east = largeDoor
    north = commandersDoor
    south = techniciansDoor

    roomParts = static inherited - defaultWestWall

    gcName = 'východní části chodby, východní části chodby, výchoní část chodby,
        východní části chodby, východní částí chodby'
    gcVocab = 'části částí -'
;

+ commandersDoor: Door
    'severní dveře (velitelovy) (od) (do) (kajuty) (velitele) dveře' 'dveře' *3
    "Každá kajuta je uzavřena lehkými vzduchotěsnými a zvukotěsnými dveřmi. Měly
        by vydržet mírné výkyvy tlaku na základně. Zevnitř se dají zajistit
        proti otevření, ale astronauti je obvykle nezamykají. "

    isPlural = true
    sightSize = small

    canTravelerPass(traveler)
    {
        return traveler != me
            || commander.isIn(commandersRoom)
            || technician.isIn(toilet);
    }

    barrierCount = 0
    explainTravelBarrier(traveler)
    {
        if(!gRevealed('commander-in-his-room'))
        {
            "Chceš vstoupit do kapitánovy kajuty, ale Boris tě upozorňuje:
                <q>Tobiáši, dílna je opačným směrem, pojď zpátky.</q> ";

            return;
        }
        if(technician.isIn(techniciansRoom))
        {
            "Chceš vstoupit do kapitánovy kajuty, ale za rohem slyšíš hlasy.
                Velitel s kapitánem! To by asi nebylo vhodné, kdyby tě viděli s
                rukou na klice. ";

            return;
        }

        switch(++barrierCount)
        {
        case 1:
            "<.p>Pokoušíš se otevřít dveře velitelovy kajuty, když se ozval
                Borisův hlas: <q>Tobiáši, tam nikdo není, chlapi
                <<if gRevealed('coffee')>>odjeli na inspekci<<else>>odešli
                přebrat nějaké zásoby<<end>>.</q> ";
            break;
        case 2:
            "<.p>Strčil jsi do dveří, ale zastavil tě lehce podrážděný technikův
                hlas: <q>Hele, už jsem ti říkal, že tam nikdo není, tak tam
                nelez!</q> ";
            break;
        default:
            "<.p>Zastavil ses přede dveřmi: <q>Boris mi už několikrát řekl, že
                tam nemám co dělat. Takže dokud ho mám za zády, tak to nemá
                smysl pokoušet. Potřeboval bych se ho nějak zbavit,</q> zamyslel
                ses. ";
        }
        gReveal('guard');
    }

    disambigName = 'severní dveře'
    disambigNameKohoCo = 'severní dveře'

    gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
    gcVocab = 'severních severním severními dveří dveřím dveřích dveřmi dveří/
        dveřím/dveřích/dveřmi'
;

+ Enterable -> commandersDoor 'kajuta (velitele)' 'kajuta velitele' *3
    "Dveře na severu vedou do kajuty velitele.<<me.setThem(commandersDoor)>> "

    sightSize = small
    hideFromAll(action) { return true; }

    gcName = 'kajuty velitele, kajutě velitele, kajutu velitele, kajutě
        velitele, kajutou velitele'
    gcVocab = 'kajuty kajutě kajutu kajutou -'
;

+ techniciansDoor: Door
    'jižní dveře (technikovy) (od) (do) (kajuty) (technika) dveře' 'dveře' *3
    "Každá kajuta je uzavřena lehkými vzduchotěsnými a zvukotěsnými dveřmi. Měly
        by vydržet mírné výkyvy tlaku na základně. Zevnitř se dají zajistit
        proti otevření, ale astronauti je obvykle nezamykají.
        <<me.setThem(techniciansDoor)>> "

    isPlural = true
    sightSize = small

    canTravelerPass(traveler)
    {
        return traveler != me
            || technician.isIn(techniciansRoom)
            || technician.isIn(toilet);
    }

    barrierCount = 0
    explainTravelBarrier(traveler)
    {
        switch(++barrierCount)
        {
        case 1:
            "<.p>Pokoušíš se otevřít dveře kajuty k technikovi, když se ozval
                Borisův hlas: <q>Tobiáši, já jsem tady, pokud mě hledáš.</q> ";
            break;
        case 2:
            "<.p>Strčil jsi do dveří, ale zastavil tě lehce podrážděný technikův
                hlas: <q>Mladej, jestli něco chceš od mě, tak pojď sem a nelez
                mi do kajuty!</q> ";
            break;
        default:
            "<.p>Zastavil ses přede dveřmi: <q>Boris je na svou kajutu nějak
                háklivý, pořád mi říká, že tam nemám co lozit. Takže dokud ho
                mám za zády, tak to nemá smysl pokoušet. Potřeboval bych se ho
                nějak zbavit,</q> zamyslel ses. ";
        }
        gReveal('guard');
    }
    
    dobjFor(TravelVia)
    {
        action()
        {
            inherited;
            if(technician.isIn(techniciansRoom))
                nestedAction(TalkTo, technician);
        }
    }

    disambigName = 'jižní dveře'
    disambigNameKohoCo = 'jižní dveře'

    gcName = 'dveří, dveřím, dveře, dveřích, dveřmi'
    gcVocab = 'jižních jižním jižními dveří dveřím dveřích dveřmi dveří/dveřím/
        dveřích/dveřmi'
;

++ SimpleNoise 'velmi tlumené chrápání' 'tlumené chrápání'
    "Přiložil jsi ucho na Borisovy dveře a chvíli poslouchal velmi tlumené
        chrápání. Není pochyb o tom, že spí. "

    soundSize = small
    isEmanating = technician.isIn(techniciansRoom) && !me.isIn(techniciansRoom)
;

+ Enterable -> techniciansDoor 'kajuta (technika)' 'kajuta technika' *3
    "Dveře na jihu vedou do kajuty technika. "

    sightSize = small
    hideFromAll(action) { return true; }

    gcName = 'kajuty technika, kajutě technika, kajutu technika, kajutě
        technika, kajutou technika'
    gcVocab = 'kajuty kajutě kajutu kajutou -'
;

+ largeDoor: IndirectLockable, AutoClosingDoor
    'velké zelené dveře' 'zelené dveře' *3
    "Dveře do technické části základny jsou velké a zeleně natřené. Na stěně
        vedle nich je čtečka identifikační karty. "

    isPlural = true
    sightSize = small

    canTravelerPass(traveler)
    {
        return !commander.isIn(corridorWest);
    }

    explainTravelBarrier(traveler)
    {
        makeOpen(nil);
        gTranscript.clearReports();

        "Právě jsi o fous unikl prozrazení, že čmucháš, kde nemáš. Opravdu
            nechceš pokoušet štěstí příliš tím, že bys před zraky velitele šel
            do místnosti s robotem. ";
    }

    cannotLockMsg = '{Kdoco dobj} nemají zámek, zamykají se samy po průchodu. '
    cannotUnlockMsg = '{Kdoco dobj} nemají zámek, odemykají se po vložení karty
        do čtečky. '

    iobjFor(AimAt) remapTo(AimAt, DirectObject, slot2)
    dobjFor(Break)
    {
        verify() { illogical('Zkusil jsi lehce šťouchnout do dveří, ale nevypadá
            to nadějně. Jsou dost odolné, abys při zdejší nepatrné gravitaci
            neměl šanci. '); }
    }
    dobjFor(Attack) asDobjFor(Break)

    gcName = 'zelených dveří, zeleným dveřím, zelené dveře, zelených dveřích,
        zelenými dveřmi'
    gcVocab = 'velkých velkým velkými zelených zeleným zelenými dveří/dveřím/
        dveřích/dveřmi'
;

++ slot2: RestrictedContainer, Component
    'čtečka slot (na) (kartu)/čtečka/slot' 'čtečka na kartu' *3
    "Je to úzká štěrbina na identifikační kartu, bez karty nelze dveře z této
        strany otevřít. "

    validContents = [card]
    cannotPutInMsg(obj)
    {
        gMessageParams(obj);
        return 'Čtečka je určena jen na identifikační karty, {kohoco obj} do
            ní vložit nemůžeš. ';
    }

    iobjFor(PutIn)
    {
        check()
        {
            inherited;
            failCheck('To není potřeba. Po té, co do dveří vrazil robot, zůstaly
                odemčené. ');
        }
    }

    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tablet na čtečku. Tablet ověřil tvé oprávnění ke
                vstupu, ale v databázi oprávněných osob tě nenašel. ";
        }
    }

    dobjFor(Pour)
    {
        verify() { illogical('Čtečka vypadá vodotěsně a nevypadá to, že polití
            by ji jakkoliv ublížilo. '); }
    }

    iobjFor(PourInto)
    {
        verify() { illogical('Čtečka vypadá vodotěsně a nevypadá to, že polití
            by ji jakkoliv ublížilo. '); }
    }
    iobjFor(PourOnto) asIobjFor(PourInto)

    gcName = 'čtečky na kartu, čtečce na kartu, čtečku na kartu,
        čtečce na kartu, čtečkou na kartu'
    gcVocab = 'čtečky čtečce čtečku čtečkou slotu slotem čtečky/čtečce/čtečku/
        čtečkou/slotu/slotem'
;
