#charset "utf-8"

/*
 *   Základna na asteroidu
 *
 *   Původní česká textová hra, která vznikla jako speciál pro dětskou šifrovací
 *   hru Technoplaneta.
 *
 *   Copyright © 2015, Tomáš Bláha, Pavel Čejka, Milan Vančura a Alena Vávrová.
 *   Všechna práva vyhrazena.
 */

#include <adv3.h>
#include <cs_cz.h>

/* ------------------------------------------------------------------------ */
/*
 *   SERVISNÍ ŠACHTA
 */

ldFloor: shipFloor 'tlumicí podlaha/polyuretan' 'podlaha' *3
    "Podlaha v servisním podpalubí je lehce zaoblená podle tvaru trupu, povrch
        je krytý pevným, trochu zdrsněným plastem bez ostrých hran. "
;

ldCeiling: RoomPart 'strop' 'strop' *2
    "Ve stropě je otvor vedoucí do společenské místnosti. "

    gcName = 'stropu, stropu, strop, stropu, stropem'
    gcVocab = 'stropu/stropem'
;

lowerDeck: DarkRoom, ShipboardRoom 'Servisní šachta' 'do servisní šachty'
    desc()
    {
        "Jsi v servisní šachtě. Tudy vedou kabely z přední části lodi s řídicím
            počítačem k dalším částem lodi -- k motorům, zadním anténám,
            nákladovému prostoru, řízení podpory života… Na stěně ve směru
            pilotní kabiny je nouzový ovládací panel hlavního a záložního
            počítače, jističe, obvody záložních baterií. Otvorem ve stropě se
            lze vrátit nahoru do společenské místnosti. ";

        scoreMarker.awardPointsOnce();
    }
    scoreMarker: Achievement { +3 "přinesení zdroje světla" }

    /* Popis pokud v místnosti není zdroj světla. */
    roomDarkDesc = "Je tu naprostá tma.<.reveal ship-dark> "
    brightness = 1

    up = ldHole
    out asExit(up)

    roomParts = static inherited
        - shipFloor + ldFloor
        - shipCeiling + ldCeiling
        - shipLights
        - shipVents

    /* Zarazíme položení všeho ve tmě. */
    roomBeforeAction()
    {
        if(gActionIs(Drop) && senseAmbientMax([sight]) < 2)
            failCheck('Asi bys tu neměl nic odkládat, protože bys to v té tmě už
                nemusel najít. ');
    }

    /* Předměty jsou vždy dostupné. */
    getExtraScopeItems(actor)
    {
        return [ldFloor, ldCeiling, portWall, starboardWall, aftWall, foreWall];
    }

    gender = 3
    changeGender = 'prostor:2, podpalubí:4'
    vocabWords = 'servisní šachta/prostor/podpalubí'
    gcVocab = 'šachty/šachtě/šachtu/šachtou/prostoru/prostorem/podpalubím'
    gcName = 'servisní šachty, servisní šachtě, servisní šachtu,
        servisní šachtě, servisní šachtou'
;

+ ldHole: TravelWithMessage, Door 'otvor/díra' 'otvor' *2
    "Vede skrz podlahu do společenské místnosti. "

    travelDesc = "Vyhoupl ses do společenské místnosti. Konečně se už necítíš
        jako sardinka. "

    /* Objekt jde prozkoumat, i když je ve tmě. */
    brightness = 1

    dobjFor(Close)
    {
        verify() { illogical('Zašmátral jsi otvorem, ale na panel nedosáhneš.
            Odsud otvor zavřít nemůžeš. '); }
    }

    changeGender = 'dír:3'
    gcName = 'otvoru, otvoru, otvor, otvoru, otvorem'
    gcVocab = 'otvoru/otvorem/díry/díře/díru/dírou'
;

+ Decoration 'kabely' 'kabely' *2
    "Kabely vedou z přední části lodi s řídicím počítačem k dalším částem lodi
        -- k motorům, zadním anténám, nákladovému prostoru, řízení podpory
        života atp. "

    isPlural = true

    gcName = 'kabelů, kabelům, kabely, kabelech, kabely'
    gcVocab = 'kabelů/kabelům/kabelech'
;

+ OnOffControl, Fixture 'jističe' 'jističe' *2
    "Jističe chrání silové rozvody před poškozením při zkratu. Odpojený jistič
        by byl vidět na první pohled, ale nyní jsou všechny zapnuté a v pořádku.
        Náhodné vypínání by byl velmi špatný a riskantní nápad, který by mohl
        (ještě více) ohrozit fungování lodi. "

    isOn = true
    dobjFor(TurnOff)
    {
        check() { failCheck('To by ses neodvážil bez výslovného svolení
            kapitána.'); }
    }

    isPlural = true
    gcName = 'jističů, jističům, jističe, jističích, jističi'
    gcVocab = 'jističů/jističům/jističích/jističi'
;

+ Decoration 'nákladní nákladový prostor' 'nákladní prostor' *2
    "Nákladový prostor je část lodi, kde může být uskladněný náklad. Odsud není
        přístupný. "

    gcName = 'nákladního prostoru, nákladnímu prostoru, nákladní prostor,
        nákladním prostoru, nákladním prostorem'
    gcVocab = 'nákladního nákladnímu nákladním nákladového nákladovému
        nákladovým prostoru/prostorem'
;

+ Decoration
    'obvody záložních záložní baterií/baterie' 'obvody záložních baterií' *2
    "Mohou být k užitku v případě výpadku. "

    isPlural = true
    gcName = 'obvodů záložních baterií, obvodům záložních baterií, obvody
        záložních baterií, obvodech záložních baterií, obvody záložních baterií'
    gcVocab = 'obvodů obvodům obvodech záložním záložními bateriím/bateriích/
        bateriemi'
;

/* ------------------------------------------------------------------------ */

+ panel: Fixture 'nouzový ovládací panel' 'nouzový ovládací panel' *2
    desc()
    {
        if(gRevealed('ship-landed'))
        {
            "Trojice kontrolek signalizující přepnutí na ruční ovládání lodi
                svítí zeleně. ";
            return;
        }
        
        "Nevelký panel je nadepsaný <q>nouzové ovládání autopilota</q>. Je na
            něm řada sedmi kontrolek vedle sebe a pod každou z nich je jedno
            tlačítko. Tlačítka jsou očíslována od 1 do 7 a kousek stranou je
            ještě jedno tlačítko označené <q>R</q>, které nejspíš panel resetuje
            do úvodního stavu. ";

        if(isInInitState)
        {
            "<.p>Levá trojice kontrolek je označená <q>autopilot</q> a všechny
                tři kontrolky svítí zeleně, čímž dávají najevo, že všechny
                okruhy porouchaného autopilota jsou aktivní a řídí loď.
                Prostřední kontrolka je označena <q>rezerva</q> a je zhasnutá.
                Pravá trojice kontrolek je označená <q>ruční řízení</q> a
                všechny tři kontrolky svítí červeně, čímž dávají najevo, že
                ruční řízení není momentálně aktivní: ";

            lightsDesc();

            "<.p>Zřejmě to bude chtít okruhy prohodit, autopilota vypnout a
                nahodit ruční řízení dřív, než do něčeho vletíme a bude po
                nás. ";
        }
        else
        {
            "<.p>Levá trojice kontrolek je označená <q>autopilot</q>, prostřední
                <q>rezerva</q> a pravá trojice <q>ruční řízení</q>. Momentální
                stav kontrolek je: ";

            lightsDesc();

            "<.p>Chtělo by to, aby kontrolky ručního řízení svítily zeleně a
                autpilota červeně. ";
        }

    }

    isInInitState = true
    isStalled = nil
    lightsState = [ 1, 1, 1, 0, 2, 2, 2 ]

    lightsDesc()
    {
        say('<.p><font size="200%"><tt>');

        for(local i = 1; i <= 7; i++)
        {
            switch(lightsState[i])
            {
            case 0:
                "<font color=\"#c0c0c0\"> ◦ </font>";
                break;
            case 1:
                "<font color=\"#00dd00\"> • </font>";
                break;
            case 2:
                "<font color=\"#ff0000\"> • </font>";
                break;
            }
        }
        "</tt></font>";
    }

    checkSolution(quite = nil)
    {
        gReveal('hint-panel-operated');
        if(lightsState == [ 2, 2, 2, 0, 1, 1, 1 ])
        {
            "<.p>Konečně je autopilot vyřazen a zapnuto ruční řízení: ";

            lightsDesc();

            "<.p>Jakmile jsi vyřadil autopilota z činnosti a bylo zřejmé, že lze
                loď ovládat ručně, přesunul ses zpět do pilotní kabiny a začal
                korigovat dráhu letu.

                <.p><center>* * * * *</center>

                <.p>Když se po dalších několika hodinách konečně probudil i
                kapitán, navedli jste společně loď na přistávací rampu, kde se
                o poslední decimetry postaraly automaty základny.

                <.p>K výstupu z lodi se před malou chvilkou přisál pružný
                přechodový tunel s atmosférou vedoucí přímo do základny. ";

            gReveal('ship-landed');
            scoreMarker.awardPointsOnce();

            me.moveIntoForTravel(cNavigatorChair);
            me.makePosture(sitting);

            captain.moveIntoForTravel(cockpit);
            captain.setCurState(captainGuideToDome);

            shipDoor.makeLocked(nil);
            shipDoor.makeOpen(true);
            cockpit.port = shipDoor;
            cockpit.out = shipDoor.createUnlistedProxy();
            PresentLater.makePresentByKey('ship-landed');

            "<.p>";
            me.lookAround(nil);

            clock.eventReached();
        }
        else
        {
            if(!quite)
                "<.p>Kontrolky na panelu změnily svůj stav. Nyní svítí: ";

            lightsDesc();

            /* Nejsme zaseknuti? */
            local moves = 0;
            for(local i = 1; i <= 7; i++)
            {
                if(checkMove(i) != 0) moves++;
            }

            if(!moves)
            {
                "<.p>Zdá se, že se panel nějak zasekl. Promačkal jsi ještě pro
                    jistotu všechna tlačítka, ale panel už na žádné nereaguje.
                    Nezbývá, než stisknout resetovací tlačítko R. ";

                if(!gRevealed('panel-read'))
                    "<.p><q>Hmmm,</q> zabručel jsi nejistě sám pro sebe, <q>tak
                    by mě zajímalo, jestli se o ovládání panelu nedá ještě někde
                    něco zjistit.</q> ";

                isStalled = true;
                gReveal('hint-panel-stalled');
            }
        }
    }
    scoreMarker: Achievement { +5 "vypnutí porouchaného autopilota" }
    clock: ClockEvent { eventTime = [2, 7, 10] }

    checkMove(index)
    {
        local pos = 0, jump = nil, dir;

        if(lightsState[index] == 1)
            dir = 1;
        else if(lightsState[index] == 2)
            dir = -1;
        else
            return 0;

        for(local j = index + dir; j >= 1 && j <= 7; j += dir)
        {
            /* Pokud skacu, musi byt volno. */
            if(jump)
            {
                if(lightsState[j] == 0) pos = j;

                /* Skacu maximalne o jedno pole, takze kazdopadne break. */
                break;
            }

            /* Je tam obsazeno stejnou barvou? Nemuzu tam jit. */
            if(lightsState[j] == lightsState[index])
                break;

            /* Je tam volno? Jdu tam. */
            if(lightsState[j] == 0)
            {
                pos = j;
                break;
            }

            /* Jinak je tam opacna a tu mohu preskocit. */
            jump = true;
        }

        return pos;
    }

    dobjFor(EnterOn)
    {
        verify() { }
        action()
        {
            local str;

            /* remove spaces from the string */
            str = gLiteral.findReplace(' ', '', ReplaceAll);

            /* ensure we have a valid string */
            if(rexMatch('^[1-7Rr]+$', str, 1) == nil)
            {
                "<.p>Na panelu jsou jen tlačítka označená čísly 1 až 7 a
                    resetovací tlačítko označené symbolem <q>R</q>. ";
                return;
            }

            /* process the string one character at a time */
            for(local i = 1, local len = str.length(); i <= len; ++i)
            {
                /* Ignoruji pripadny zbytek sekvence. */
                if(gRevealed('ship-landed')) continue;

                /* get the current character */
                local ch = str.substr(i, 1);

                if(ch == 'r' || ch == 'R')
                {
                    "Panel se vyresetoval a opět svítící zelené kontrolky
                        ukazují, že autopilot plně (a blbě) řídí loď: ";

                    isStalled = nil;
                    lightsState = [ 1, 1, 1, 0, 2, 2, 2 ];
                    lightsDesc();
                }
                else
                {
                    /* Ignoruji pripadny zbytek sekvence. */
                    if(isStalled) continue;

                    local index = parseInt(ch), pos = 0;

                    if(lightsState[index] != 0)
                    {
                        pos = checkMove(index);
                        if(pos != 0)
                        {
                            lightsState[pos] = lightsState[index];
                            lightsState[index] = 0;

                            if(len > 1 && i == 1)
                                "Postupně jsi provedl sérii přepnutí: ";

                            checkSolution(len > 1);
                        }
                        else
                        {
                            "<.p>Nic se nestalo, panel na stisknuté tlačítko
                                nijak nezareagoval. ";
                        }
                    }
                    else
                    {
                        "<.p>Nic se nestalo, asi proto, že kontrolka u tohoto
                            tlačítka vůbec nesvítila. ";
                    }
                    isInInitState = nil;
                }
            }
        }
    }
    dobjFor(TypeLiteralOn) asDobjFor(EnterOn)

    iobjFor(AimAt)
    {
        action()
        {
            "Namířil jsi tablet na nouzový ovládací panel, tablet na obrazovce
                zobrazil aktuální stav tlačítek a obrázek ruky signalizující, že
                toto zařízení je nezbytné ovládat ručně a nelze jeho stav měnit
                z displeje tabletu. ";
        }
    }

    dobjFor(Break)
    {
        verify() { }
        action()
        {
            "Zapřel ses a vší silou kopnul do panelu, ale asi to nemělo ten
                účinek, ve který jsi doufal. ";

            nestedAction(TypeLiteralOn, self, 'R');
        }
    }
    dobjFor(Attack) asDobjFor(Break)

    gcName = 'nouzového ovládacího panelu, nouzovému ovládacímu panelu, nouzový
        ovládací panel, nouzovém ovládacím panelu, nouzovým ovládacím panelem'
    gcVocab = 'nouzového nouzovému nouzovém nouzovým ovládacího ovládacímu
        ovládacím panelu/panelem'
;

++ ComponentDeferrer, Component
    'kontrolka kontrolky okruh okruhy (1) (2) (3) (4) (5) (6) (7) -' 'kontrolky' *3
    "Nad sedmi tlačítky je sedm dvojbarevných kontrolek. Levá trojice kontrolek
        je označená <q>autopilot</q> a když svítí zeleně, je autopilota zapnutý.
        Prostřední kontrolka je označena <q>rezerva</q>. Pravá trojice kontrolek
        je označená <q>ruční řízení</q> a pokud svítí červeně, je ruční řízení
        vypnuto. Současný stav kontrolek je následující: <<panel.lightsDesc>> "

    isPlural = true
    gcName = 'kontrolek, kontrolkám, kontrolky, kontrolkách, kontrolkami'
    gcVocab = 'kontrolce kontrolku kontrolkou kontrolek kontrolkám kontrolkách
        kontrolkami'
;

class PanelButton: Button, Component
    'tlačítko tlačítka (na) (panelu) tlačítko/(panelu)*tlačítka'

    name = perInstance('tlačítko <q>' + calcStr + '</q>')
    nameKohoCeho = perInstance('tlačítka <q>' + calcStr + '</q>')
    nameKomuCemu = perInstance('tlačítku <q>' + calcStr + '</q>')
    nameKohoCo = perInstance('tlačítko <q>' + calcStr + '</q>')
    nameKomCem = perInstance('tlačítku <q>' + calcStr + '</q>')
    nameKymCim = perInstance('tlačítkem <q>' + calcStr + '</q>')
    desc = "Tlačítko je označené jako <q><<calcStr>></q>. "

    /* the string I enter on the calculator when pushed */
    calcStr = nil

    dobjFor(Push)
    {
        action()
        {
            /* enter my string */
            nestedAction(TypeLiteralOn, location, calcStr);

            /*
             *   if this is the first time I've been pushed, mention that
             *   it's easier to enter whole strings
             */
            if(++PanelButton.pushCount == 3)
                "<.p><font color=\"#808080\"><b>Tip:</b> Kdybys chtěl, můžeš
                    místo mačkání jednotlivých tlačítek ZADAT delší sekvenci NA
                    PANELU, např. ZADEJ 123.</font> ";
        }
    }

    /* treat ENTER the same as pressing the button */
    dobjFor(Enter) asDobjFor(Push)
    dobjFor(Switch) asDobjFor(Push)

    /* class variable: number of times we've pushed a button */
    pushCount = 0

    /* defer to our collective group object for some actions */
    collectiveGroup = panelButtonGroup
;

++ PanelButton '1/jedna/jednička/jedničku' calcStr = '1';
++ PanelButton '2/dva/dvě/dvojka/dvojku' calcStr = '2';
++ PanelButton '3/tři/trojka/trojku' calcStr = '3';
++ PanelButton '4/čtyři/čtyřka/čtyřku' calcStr = '4';
++ PanelButton '5/pět/pětka/pětku' calcStr = '5';
++ PanelButton '6/šest/šestka/šestku' calcStr = '6';
++ PanelButton '7/sedm/sedmička/sedmičku' calcStr = '7';
++ PanelButton 'R/reset' calcStr = 'R';

/* a collective group for the buttons */
++ panelButtonGroup: CollectiveGroup, Component
    'tlačítko (na) (panelu) tlačítko/(panelu)*tlačítka' 'tlačítka na panelu'
    "Na panelu je řada tlačítek označená z leva do prava čísly 1 až 7. "

    /* take over Examine, Push, and Enter */
    isCollectiveAction(action, whichObj)
    {
        return (action.ofKind(ExamineAction)
                || action.ofKind(PushAction)
                || action.ofKind(EnterAction));
    }

    /* take over singular and unspecified quantities */
    isCollectiveQuant(np, requiredNum) { return requiredNum is in (nil, 1); }

    /* for Push and Enter, just say they need to say which button */
    dobjFor(Push)
    {
        verify() { }
        action() { "Budeš muset říci konkrétně, které tlačítko na panelu chceš
            zmáčknout, např. ZMÁČKNI TLAČÍTKO 1. "; }
    }
    dobjFor(Enter) asDobjFor(Push)

    /* don't allow this collective object as a default for ENTER */
    hideFromDefault(action)
    {
        /* hide from ENTER, as well as any inherited hiding */
        return action.ofKind(EnterAction) || inherited(action);
    }

    gcName = 'tlačítek na panelu, tlačítkům na panelu, tlačítka na panelu,
        tlačítkách na panelu, tlačítkami na panelu'
    gcVocab = 'tlačítek tlačítkům tlačítkách tlačítkami -'
;
